/* 

2645_InterruptIn

Sample code from ELEC2645 

Demonstrates how to use InterruptIn to generate an event-triggered interrupt

(c) Craig A. Evans, University of Leeds, Jan 2016

*/ 

#include "mbed.h"

// Create objects for SW2 (right switch) and red LED
InterruptIn sw2(SW2);
DigitalOut red_led(LED_RED);

// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_sw2_flag = 0;

// function prototypes
void sw2_isr();

int main()
{
    // SW2 has a pull-up resistor, so the pin will be at 3.3 V by default
    // and fall to 0 V when pressed. We therefore need to look for a falling edge
    // on the pin to fire the interrupt
    sw2.fall(&sw2_isr);
    // since SW2 has an external pull-up, we should disable to internal pull-down
    // resistor that is enabled by default using InterruptIn
    sw2.mode(PullNone);
    // the on-board RGB LED is a common anode - writing a 1 to the pin will turn the LED OFF
    red_led = 1;

    while (1) {

        // check if flag i.e. interrupt has occured
        if (g_sw2_flag) {
            g_sw2_flag = 0;  // if it has, clear the flag

            // send message over serial port - can observe in CoolTerm etc.
            printf("Execute task \n");
            // DO TASK HERE
        }

        // put the MCU to sleep until an interrupt wakes it up
        sleep();

    }
}

// SW2 event-triggered interrupt
void sw2_isr()
{
    g_sw2_flag = 1;   // set flag in ISR
}
