#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

//        SCE, RST, D/C, MOSI,SCLK,LED
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;

void check_buttons();

int main()
{
    lcd.init();
    lcd.setContrast(0.5);
    pad.init();

    lcd.printString("Hello Gamepad!",0,0);
    lcd.refresh();
    pad.tone(1000.0,2.0);

    for (int i = 0; i < 1000; i++) {
        lcd.setContrast( pad.read_pot());
        lcd.setBrightness( pad.read_pot());
        wait_ms(10);
    }

    for (int i = 0; i < 10; i++) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

    for (float x = 0.0f; x <= 1.0f ; x+=0.1f) {
        pad.leds(x);
        wait(0.1);
    }

    for (int n = 1; n <= 6; n++) {
        pad.led(n,0.5);
        wait(0.5);
    }

    pad.leds_off();

    while(1) {
        pad.leds_off();
        lcd.clear();   
        lcd.setContrast( pad.read_pot());
        lcd.setBrightness( pad.read_pot());
        check_buttons();
        lcd.drawCircle(WIDTH/2,HEIGHT/2,20,FILL_TRANSPARENT);  // x,y,radius,transparent with outline
        Vector2D coord = pad.get_mapped_coord();
        float x = coord.x;
        float y = coord.y;

        if ( pad.check_event(Gamepad::JOY_PRESSED)) {
            lcd.drawCircle(WIDTH/2+int(20*x),HEIGHT/2-int(20*y),3,FILL_BLACK);
        } else {
            lcd.drawCircle(WIDTH/2+int(20*x),HEIGHT/2-int(20*y),3,FILL_TRANSPARENT);
        }

        lcd.refresh();
        wait(1.0f/5.0f);
    }
}

void check_buttons()
{
    if ( pad.check_event(Gamepad::A_PRESSED) ) {
        lcd.printChar('A',0,0);
        pad.led(1,0.5);
        pad.tone(1000.0,0.2);
        printf("A pressed\n");
    }
    if ( pad.check_event(Gamepad::B_PRESSED) ) {
        lcd.printChar('B',0,1);
        pad.led(2,0.5);
        pad.tone(1000.0,0.2);
        printf("B pressed\n");
    }
    if ( pad.check_event(Gamepad::X_PRESSED) ) {
        lcd.printChar('X',0,2);
        pad.led(3,0.5);
        pad.tone(1000.0,0.2);
        printf("X pressed\n");
    }
    if ( pad.check_event(Gamepad::Y_PRESSED) ) {
        lcd.printChar('Y',0,3);
        pad.led(4,0.5);
        pad.tone(1000.0,0.2);
        printf("Y pressed\n");
    }
    if ( pad.check_event(Gamepad::L_PRESSED) ) {
        lcd.printChar('L',78,0);
        pad.led(5,0.5);
        pad.tone(1000.0,0.2);
        printf("L pressed\n");
    }
    if ( pad.check_event(Gamepad::R_PRESSED) ) {
        lcd.printChar('R',78,1);
        pad.led(6,0.5);
        pad.tone(1000.0,0.2);
        printf("R pressed\n");
    }
    if ( pad.check_event(Gamepad::START_PRESSED) ) {
        lcd.printChar('S',78,2);
        pad.tone(1000.0,0.2);
        printf("Start pressed\n");
    }
    if ( pad.check_event(Gamepad::BACK_PRESSED)) {
        lcd.printChar('K',78,3);
        pad.tone(1000.0,0.2);
        printf("Back pressed\n");
    }

}