/*

2645_FSM_Puffin

Sample code from ELEC2645

Demonstrates how to implement a puffin crossing using a FSM

(c) Craig A. Evans, University of Leeds, Jan 2016

*/

#include "mbed.h"

// K64F on-board LEDs
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);

// LEDs to display traffic light output
// May need to change pins depending on which order you soldered the LEDs
// LSB                       MSB
// car - green,amber, red  pedestrian - green, red
BusOut output(PTC2,PTA2,PTA1,PTD3,PTC3); // LED order suggested in notes

// BusIn to read inputs simutaneously
// camera (button A) , pedestrian button (button B)
// LSB, MSB
BusIn input(PTB9,PTD0);

// struct for state
struct State {
    int output;  // output value
    float time;    // time in state
    int nextState[4];  // array of next states
};

State fsm[4] = {
    {0x13,5.0,{...,...,...,...}},  // 0 - cars stop, pedestrian walk               5 seconds
    {...,2.0,{2,2,2,2}},  // 1 - cars get ready to go, pedestrian stop    2 seconds
    {...,10.0,{...,...,...,...}}, // 2 - cars go, pedestrian stop                10 seconds
    {...,2.0,{0,0,0,0}}   // 3 - cars get ready to stop, pedestrian stop  2 seconds
};

int main()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;
    
    // turn on internal pull-downs for buttons A and B
    input.mode(PullDown);
    
    int state = 2;  // start with cars green

    while(1) {
        output = fsm[state].output;  // set ouput depending on current state
        wait(fsm[state].time);       // wait in that state for desired time           
        state = fsm[state].nextState[input];  // read input (BusIn) and update curent state
    }
}
