/* 

2645_FSM_Counter

Sample code from ELEC2645

Demonstrates how to implement a simple FSM counter

(c) Craig A. Evans, University of Leeds, Jan 2016

*/ 

#include "mbed.h"

// K64F on-board LEDs 
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);
// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

// LEDs on Gamepad (1 to 4) - active-low 0 = on and 1 = off
BusOut output(PTA1,PTA2,PTC2,PTC3);

// array of states in the FSM, each element is the output of the counter
// set the output in binary to make it easier, 0 is LED on, 1 is LED off
int fsm[4] = {0b0111,0b1011,0b1101,0b1110};

// set-up the on-board LEDs and switches
void init_K64F();

int main()
{
    init_K64F();
    // set inital state 
    int state = 0;
    
    while(1) {  // loop forever

        output = fsm[state];  // output current state

        // check which state we are in and see which the next state should be
        switch(state) {
            case 0:
                state = 1;
                break;
            case 1:
                state = 2;
                break;
            case 2:
                state = 3;
                break;
            case 3:
                state = 0;
                break;
            default:
                error("Invalid state");  //invalid state - call error routine
                // or could jump to starting state i.e. state = 0
                break;  
        }

        wait(0.5);  // small delay

    }
}

void init_K64F() 
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;   
    
    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}