#include "mbed.h"

DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);

void init_buttons();

int main()
{
    init_buttons();  // turn off internal pull-up/pull-down resistors

    while(1) {

        // check each button in turn and print message
        if ( button_A.read() == 1) {
            printf("Button A pressed\n");
        }
        if ( button_B.read() == 1) {
            printf("Button B pressed\n");
        }
        if ( button_C.read() == 1) {
            printf("Button C pressed\n");
        }
        if ( button_D.read() == 1) {
            printf("Button D pressed\n");
        }

        wait(0.1);  // small delay

    }
}

void init_buttons()
{
    // PCB has external pull-down resistors so turn the internal ones off
    // (default for DigitalIn)
    button_A.mode(PullNone);
    button_B.mode(PullNone);
    button_C.mode(PullNone);
    button_D.mode(PullNone);
}
