/* ELEC1620 Application Board Example

Example of using getc to receive data from the PC to control
the application board

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"
#include "ShiftReg.h"  // include ShiftReg library

ShiftReg shift;  // create ShiftReg object
Serial pc(USBTX,USBRX);  

int main()
{
    // values for 0 - 9 in hex
    int seven_seg_array [] = {
        0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x67
    };

    // write 0 to 7-seg to turn it off
    shift.write(0x00);

    while(1) {

        // readable tells us if a character is waiting to be read
        if ( pc.readable() ) {
            // if one is there, then read in using getc
            char c = pc.getc();    
            
            // check if it is a digit that has been received - note ' ' for char
            if (c >= '0' && c <= '9') {
                // the received char is in ASCII so convert to int by substracting
                // the ASCII value of '0'
                int value = c - '0';
                
                // make that value appear on the 7-seg display
                shift.write(seven_seg_array [value]);
                
            }
            
        }
        

    }
}
