/* ELEC1620 Application Board Example

TMP36

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"
#include "N5110.h"

// JP1 on board must be in 2-3 position
N5110 lcd(p8,p9,p10,p11,p13,p21);

// Temperature sensor connected to ADC pin
AnalogIn tmp36(p16);

int main() {
    
    lcd.init();  // need to initialise the LCD
    
    while(1) {
        
        // read in the ADC value and convert to voltage
        float voltage = 3.3f * tmp36.read();
        
        // T = 100V - 50
        // convert voltage to temperature
        float temperature = 100.0f*voltage - 50.0f;
        
        // we need an array of chars to store the message
        char buffer[14];  // max screen witdth is 14
        // print message to buffer
        sprintf(buffer,"T=%.2f C",temperature);
        // print to screen (x pixel, line number)
        lcd.printString(buffer,0,0);
        // update the LCD
        lcd.refresh(); 
        
        // small delay between readings
        wait(1.0);
        
    }
}


