/* ELEC1620 Application Board Example

RGB LED

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"

DigitalOut red_led(p24);
DigitalOut green_led(p23);
DigitalOut blue_led(p22);

void init_leds();

int main()
{

    init_leds();

    while(1) {

        // writing a 1 turns the LED off, 0 makes it turn on
        
        blue_led.write(1);  // blue off
        red_led.write(0);   // red on
        wait(0.5);
        
        red_led.write(1);   // red off
        green_led.write(0); // green on
        wait(0.5);
        
        green_led.write(1); // green off
        blue_led.write(0);  // blue on
        wait(0.5);


    }
}

void init_leds()
{
    // LEDs are common anode (active-low) so writing a 1 will turn them off
    red_led.write(1);
    green_led.write(1);
    blue_led.write(1);

    // this syntax is equivalent
    //red_led = 1;
    //green_led = 1;
    //blue_led = 1;
}

