/* ELEC1620 Application Board Example

RGB LED

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"

//              R , G , B
BusOut rgb_led(p24,p23,p22);
//             LSB     MSB

void init_leds();

int main()
{
    // turn off LEDs
    init_leds();

    while(1) {

        // loop through 3-bit values and set RGB colour
        for(int val = 0; val < 8 ; val++) {
            rgb_led.write(val);
            // rgb_led = val; // syntax equivalent
            wait(0.2);    
        }

    }
}

void init_leds()
{
    // LEDs are common anode (active-low) so writing a 1 will turn them off
    // We have a 3-bit bus for the RGB LED, so writing 7 (0b111) will turn
    // all 3 off 
    rgb_led.write(7);
    
    // this syntax is equivalent
    // rgb = 7;
    // rgb = 0b111;  // can also use binary literals since C++ compiler upgrade 
}

