#include "main.h"

// objects defined here with pin numbers
DigitalIn button_a(p29);
DigitalIn button_b(p28);
DigitalIn button_c(p27);
DigitalIn button_d(p26);

AnalogIn ldr(p15);
BusOut leds(LED4,LED3,LED2,LED1);
Tone speaker(p18);

BusOut rgb_led(p24,p23,p22);

AnalogIn tmp36(p16);

AnalogIn pot_0(p20);
AnalogIn pot_1(p19);
AnalogIn pot_2(p17);

N5110 lcd(p8,p9,p10,p11,p13,p21);
ShiftReg shift;

int seven_seg_array[] = {
    0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x67
};
// array that stores the colors R, G and B
int rgd_led_array[] = {
    0b011,0b101,0b110
};

int led_val = 0;

void init();
void test_7seg();
void test_buttons();
void test_leds();
void test_ldr();
void test_tmp();
void test_pots();

int main()
{
    // initialise peripherals
    init();

    // test the constant outputs
    test_7seg();
    leds = 0x0F;  // on-board LEDs
    speaker.play(1000.0,2.0);
        
    // loop forever
    while(1) {

        // clear LCD at beginning of each 'frame'
        lcd.clear();
        lcd.printString("Test",0,0);

        // test inputs and outputs that can change

        test_buttons();
        test_leds();
        test_ldr();
        test_tmp();
        test_pots();

        // print everything on the screen
        lcd.refresh();
        // small delay before next frame is drawn
        wait(1.0/4);
    }

}

void init()
{
    shift.write(0x00);

    lcd.init();

    speaker.init();

    // PCB has external pull-down resistors so turn the internal ones off
    // (default for DigitalIn)
    button_a.mode(PullNone);
    button_b.mode(PullNone);
    button_c.mode(PullNone);
    button_d.mode(PullNone);
}

void test_7seg()
{
    shift.write(0xFF);
}

void test_buttons()
{
    // check each button, and print character on screen
    if ( button_a.read() == 1) {
        lcd.printChar('A',0,1);
    }
    if ( button_b.read() == 1) {
        lcd.printChar('B',8,1);
    }
    if ( button_c.read() == 1) {
        lcd.printChar('C',16,1);
    }
    if ( button_d.read() == 1) {
        lcd.printChar('D',24,1);
    }
}

void test_leds()
{

    // set RGB to current val
    rgb_led = rgd_led_array[led_val];

    // increment the val (i.e. change colour combination)
    led_val++;

    // once we've got to end of array, go back to beginning
    if (led_val == 3) {
        led_val = 0;
    }

}

void test_ldr()
{
    float value = ldr.read();  // read in the LDR value in range 0.0 to 1.0
    char buffer[14];

    sprintf(buffer,"LDR=%.2f",value); // print formatted data to buffer
    lcd.printString(buffer,0,2);           // display on screen
}

void test_tmp()
{
    float value = 3.3*tmp36.read();  // read in the TMP36 value in range 0.0 to 1.0
    float temperature = 100.0f*value - 50.0f;
    char buffer[14];

    sprintf(buffer,"T=%.4f C",temperature); // print formatted data to buffer
    lcd.printString(buffer,0,3);           // display on screen
}

void test_pots()
{

    char buffer[14];

    float val = pot_0.read();
    sprintf(buffer,"%.2f",val); // print formatted data to buffer
    lcd.printString(buffer,0,5);           // display on screen
    lcd.setContrast(val);  // tune LCD contrast 

    val = pot_1.read();
    sprintf(buffer,"%.2f",val); // print formatted data to buffer
    lcd.printString(buffer,28,5);           // display on screen

    val = pot_2.read();
    sprintf(buffer,"%.2f",val); // print formatted data to buffer
    lcd.printString(buffer,56,5);           // display on screen
}