/* ELEC1620 Application Board Example

PWM

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"

PwmOut red_led(p24);
PwmOut green_led(p23);
PwmOut blue_led(p22);

int main()
{
    float frequency = 100.0f;  // 100 Hz
    red_led.period(1.0f/frequency);  // set the period of the waveform
    // all PWM channels share the same period so only need to set for one

    while(1) {

        // loop through 0 to 100% duty cycle in steps of 10% for each LED

        // each for loop has 10 iterations
        for (float dc1 = 0.0 ; dc1 <= 1.0 ; dc1 += 0.1) {
            // they are 'nested' and so we have
            for (float dc2 = 0.0 ; dc2 <= 1.0 ; dc2 += 0.1) {
                // 10 x 10 x 10 = 1000 iterations (colours) in total
                for (float dc3 = 0.0 ; dc3 <= 1.0 ; dc3 += 0.1) {

                    red_led.write(dc1);    // fade LED
                    green_led.write(dc2);  // fade LED
                    blue_led.write(dc3);   // fade LED

                    //red_led = dc1; // equivalent syntax

                    wait_ms(20);  // small delay
                }

            }
        }
    }
}
