/* ELEC1620 Application Board Example

LDR

(c) Dr Craig A. Evans, University of Leeds, Feb 2017

*/

#include "mbed.h"
#include "N5110.h"

// JP1 on board must be in 2-3 position
N5110 lcd(p8,p9,p10,p11,p13,p21);

// LDR connected to ADC pin
AnalogIn ldr(p15);

int main() {
    
    lcd.init();  // need to initialise the LCD
    
    while(1) {
        
        // clear the display at the start of every new frame
        lcd.clear();
        
        // lcd is 84 pixels wide x 48 pixels high
        
        //  x, y,  width, height, fill type
        lcd.drawRect(12,20,60,8,FILL_TRANSPARENT);
        
        float value = ldr.read();  // read in the LDR value in range 0.0 to 1.0
        
        int width = int(value*60.0f); // convert to an int in the range 0.0 to 60.0
        
        // draw a bar of the correct width
        lcd.drawRect(12,20,width,8,FILL_BLACK); 
        
        // update the LCD
        lcd.refresh(); 
        // small delay between readings
        wait(0.2);
        
    }
}


