/* ELEC1620 Application Board Example

LCD

(c) Dr Craig A. Evans, University of Leeds, March 2017

*/

#include "mbed.h"
#include "N5110.h"

// JP1 must be in 2/3 position
N5110 lcd(p8,p9,p10,p11,p13,p21);

const int run[12][10] =   {
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,0,0,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,1,1,0,1,0,0 },
    { 0,1,1,0,1,1,0,1,1,1 },
    { 1,0,0,0,1,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,0,1,1,0,0 },
    { 1,1,1,1,0,0,0,1,1,0 },
    { 0,0,0,0,0,0,1,1,0,0 },
    { 0,0,0,0,0,1,1,0,0,0 },
    { 0,0,0,0,1,1,0,0,0,0 },


};

int main()
{

    // need to initialise the lcd first, do this once outside of the loop
    lcd.init();
    
    int x = 0;  // starting position

    while(1) {

        // clear the display at the start of the loop
        lcd.clear();

        // print any text
        lcd.printString("Run!",0,0);

        // draw the required shapes
        lcd.drawRect(0,40,84,8,FILL_BLACK);
        lcd.drawCircle(70,10,5,FILL_TRANSPARENT);

        // draw the sprite at the correct place
        lcd.drawSprite(x,40-12,12,10,(int *)run);
        
        x+=2;  // increment x to move sprite across 2 pixels each loop
        
        if (x>83) {  // if gone off screen then move back to left
            x=0;    
        }

        lcd.refresh(); // refresh the LCD so the pixels appear
        wait_ms(1000/10);  // this gives a refresh rate of 10 frames per second
    }
}


