/* ELEC1620 Application Board Example

Example of the Tone library to interface with the DAC

(c) Dr Craig A. Evans, University of Leeds, March 2017

*/

#include "mbed.h"
#include "Tone.h"

Tone dac(p18);

// Super Mario Theme Tune
const int note_array[] = {
    NOTE_E7, NOTE_E7, 0, NOTE_E7,
    0, NOTE_C7, NOTE_E7, 0,
    NOTE_G7, 0, 0,  0,
    NOTE_G6, 0, 0, 0,

    NOTE_C7, 0, 0, NOTE_G6,
    0, 0, NOTE_E6, 0,
    0, NOTE_A6, 0, NOTE_B6,
    0, NOTE_AS6, NOTE_A6, 0,

    NOTE_G6, NOTE_E7, NOTE_G7,
    NOTE_A7, 0, NOTE_F7, NOTE_G7,
    0, NOTE_E7, 0,NOTE_C7,
    NOTE_D7, NOTE_B6, 0, 0,

    NOTE_C7, 0, 0, NOTE_G6,
    0, 0, NOTE_E6, 0,
    0, NOTE_A6, 0, NOTE_B6,
    0, NOTE_AS6, NOTE_A6, 0,

    NOTE_G6, NOTE_E7, NOTE_G7,
    NOTE_A7, 0, NOTE_F7, NOTE_G7,
    0, NOTE_E7, 0,NOTE_C7,
    NOTE_D7, NOTE_B6, 0, 0
};

// 8 corresponds to 1/8
const int duration_array[] = {
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,

    8,8,8,8,
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,

    6,6,6,
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,

    8,8,8,8,
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,

    6,6,6,
    8,8,8,8,
    8,8,8,8,
    8,8,8,8,
};

int main()
{
    dac.init();
    
    int n = sizeof(note_array)/sizeof(int);
    // tell it the number of notes, arrays, BPM and whether to repeat
    dac.play_melody(n,note_array,duration_array,120.0,true);

}
