
/*
* Force Controlled Vibration Analysis - 
* 
* 22.08.2019
* Theekshana
*/
 
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "qeihw.h"


//---------------------------=Communication Pins=-------------------------------
Serial pc(USBTX, USBRX);
DigitalOut led3(LED3);
DigitalOut led1(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");  // pintout for sd card

//--------------------------=Motor Driver Controller Pin =-----------------------------
DigitalOut  Reset_AB(p29);          // H bridge enable
DigitalOut  Reset_CD(p30);
DigitalOut  Reset_AB_s(p27);
DigitalOut  Reset_CD_s(p28);

PwmOut pwm_clk_s(p21);              // clockwise rotation pwm pin for Slave
PwmOut pwm_anticlk_s(p22);          
PwmOut pwm_clk(p23);                // clockwise rotation pwm pin for Master
PwmOut pwm_anticlk(p24); 


//--------------------------=Current Sensor MBED Pins=--------------------------
int Master_Direction=0;
int slave_Direction=0;

DigitalIn M_Dir(p10);
DigitalIn S_Dir(p9);
AnalogIn current_sensor_s_p(p15); // current sensor input for MASTER positive
AnalogIn current_sensor_s_n(p16);
AnalogIn current_sensor_m_p(p17); // current sensor input for MASTER positive
AnalogIn current_sensor_m_n(p18); // current sensor input for MASTER negative

float I_res_m = 0.0;
float  I1_act_m=0.0;
float I_msrd=0.0;
float G_Cfilter=30.0;

//--------------------------=Ethernet Variable=---------------------------------
Ethernet eth;
float I_sin = 0.0;
float I_DoB_prev = 0.0;
float I_sin_prev =0.0;



//--------------------------=Thread Variables=-----------------------------------
Ticker time_up;
float startTime=0.0;
float tempTime = 0.0;
float endTime=0.0;
Timer timer;
float preTime = 0.0;

//--------------------------=Velocity reading variables=-------------------------
char buf[0x600];
float recv_angle = 0.0;
float x_res = 0.0;
float dt = 0.000001*150.0;
float ve_sum = 0.0;
float dx_res = 0.0;
float G_filter_v = 150.0;
float duty = 0.0;

//--------------------------=DoB variables=--------------------------------------
float K_tn=0.135;
float J_n = 0.0000720;
float B = 0.000107;

float g_dis = 100.0;
float g_Tdis = 5.0;
float D_DoB = 0.0;
float D_BFilter = 0.0;
float D_AFilter = 0.0;
float I_DoB = 0.0;
float R_BFilter=0.0;

//--------------------------=RTOB Variables=-------------------------------------
float RT_BFilter=0.0;
float RT_AFilter = 0.0;
float RTOB = 0.0;

float K_pi = 40.0;                       // tested value for smooth oparation
float K_di = 0.0;
float K_ii = 0.0;
float I_error = 0.0;
float I_err_sum = 0.0;
float I_err_prev = 0.0;

float I_PID = 0.0;

//--------------------------=Force Controller Variables=-------------------------
float F_ref = 500.0;
float T_ref = 0.15;
float T_f = 0.025;
float K_pf = 10000.0;                       // tested value for smooth oparation
float K_df = 0.0;
float K_if = 0.0;
float F_error = 0.0;
float F_err_sum = 0.0;
float F_err_prev = 0.0;
float I_cmd = 0.0;
float F_PID = 0.0;
float I_ref = 0.5;

//-------------------------=slave current controller variables=-----------------
int count = 0;
float f = 20.0;
float K_pis =10.0;
float K_dis = 0.0;
float K_iis = 0.0;

float I_error_s = 0.0;
float I_ref_s = 0.0;
float I_err_sum_s = 0.0;
float I_PID_s = 0.0;
float I_err_prev_s = 0.0;
float duty_s = 0.0;

float I_res_s  = 0.0;
float I1_act_s = 0.0;
float I_msrd_s = 0.0;

//--------------------------=Fucion declaration=--------------------------------
void controlLoop();
void readVelocity();
void readCurrent();
void forceController();
void DoB();
void motorPWM_init();

void motorPWM();

void slaveCurrentRead();
void slaveCurrentController();
void motorpwm_s();

void thread_2(void const *argument);
void sd_card_write_test();
void sd_card_write();
void ethernet_init();

//FILE *fp = fopen("/sd/mydir/sdtest.txt","w");




//----------------------------------=Main Loop=---------------------------------
int main()
{
    ethernet_init();
    //sd_card_write_test();
    //FILE *fp = fopen("/sd/mydir/sdtest.txt","w");
    motorPWM_init();
    time_up.attach(&controlLoop, dt); 
  
     while(1)
    {
        pc.printf("%f\t %f\t %f\t \r\n", I_msrd,I_ref,RTOB);
        /*
    if (count>20000 and count<50000 and count!=count_prev ){
               led1 =1;
               //sd_card_write();
               count_prev = count; 
               //datacount++;              
               }
    else if(count>50000){
             led1=0;
             fclose(fp);  
               }
               
       */
    }
}

//--------------------------=Main Control Loop=---------------------------------
void controlLoop(){
    if (x_res>0.0)
    {
        T_f = -0.025;
    }
    else
    {
        T_f = 0.025;
    }
    
    count = count+1;
    I_ref_s = 0.15*sin(2*3.14159*dt*f*count);            // 2*3.14159*dt = 
    readVelocity(); 
    readCurrent();
    forceController();
   DoB();
    motorPWM();
    slaveCurrentRead();
    slaveCurrentController();
    motorpwm_s();
}


//--------------------------=Read Velocity=-------------------------------------
void readVelocity(){
    int size2 = eth.receive();
    if(size2 > 0)
    {
        eth.read(buf, size2);
        memcpy(&recv_angle, buf, sizeof(float));
        x_res = -1*recv_angle; 
    } 
    ve_sum += dx_res*dt;
    dx_res =G_filter_v*( x_res-ve_sum);
}

//--------------------------=Current Meassurement=------------------------------
void readCurrent()
{
    Master_Direction = M_Dir.read();
    //master clockwise
    if(Master_Direction == 0)
    {                                
        I_res_m = current_sensor_m_p.read(); 
        I1_act_m = -1.0*(I_res_m*4.71428);    //0.74787687701613 //0.717075441532258
         
    }else  { //master anticlockwise 
        I_res_m =  current_sensor_m_n.read();
        I1_act_m = (I_res_m*4.71428);   //0.713239227822580 
    }
    I_msrd += 30.0*(I1_act_m-I_msrd)*dt;
}



//--------------------------=Velocity Controller=-------------------------------
void forceController()
{
    //T_ref = F_ref*6.1/10000.0;
    F_error = T_ref - RTOB;
    F_err_sum += F_error*dt;
    F_PID = (K_pf*F_error);
    F_err_prev = F_error;
    I_cmd = F_PID*J_n/K_tn;
    I_ref = I_cmd +(I_DoB);  
    
}

//--------------------------=Distarbance Observer=------------------------------
void DoB()
{
    //D_BFilter=(I_msrd*K_tn) +  (dx_res*J_n*g_dis);
    D_BFilter=(I_msrd*K_tn) +  (dx_res*J_n*g_dis) ;
    D_AFilter += g_dis*(D_BFilter-D_AFilter)*dt;
    D_DoB = D_AFilter - (dx_res*J_n*g_dis);
    I_DoB = (D_DoB)/K_tn; 

    
//--------------------------=Reaction Force Observer=------------------------------  
    R_BFilter=(I_msrd*K_tn) +  (dx_res*J_n*g_Tdis);
    RT_BFilter = R_BFilter - (T_f+B*dx_res);
    RT_AFilter += g_Tdis*(RT_BFilter-RT_AFilter)*dt;
    RTOB =  RT_AFilter - (dx_res*J_n*g_Tdis);
}


//--------------------------=Motor PWM Initialization=--------------------------
void motorPWM_init()
{
    pwm_clk.period_us(10);
    pwm_clk_s.period_us(10);
    pwm_anticlk_s.period_us(10);
    pwm_anticlk.period_us(10);
    pwm_clk.write(0.0f);       
    pwm_anticlk.write(0.0f);
    pwm_clk_s.write(0.0f);       
    pwm_anticlk_s.write(0.0f);
    Reset_AB = 1;               
    Reset_CD = 1;
    Reset_AB_s =1;
    Reset_CD_s =1;
}

//--------------------------=Motor PWM Generation=------------------------------
void motorPWM()
{
    duty = I_ref/5.1;
     //duty = 1.62/5.1;
      
     if (duty> 0.0)
     {
        if (duty > 0.95)
        {
            duty = 0.95;
        }
        pwm_clk = 0.0;
        pwm_anticlk = duty;
    }else
    {
        if (duty< -0.95)
        {
            duty = -0.95;
        }
        pwm_anticlk = 0.0;
        pwm_clk = -1.0 * duty;
    }
}

//---------------------------=Slave motor=--------------------------------------
//---------------------------=Slave motor current reading=----------------------
void slaveCurrentRead()
{
    slave_Direction = S_Dir.read();
                                                    
    if(slave_Direction == 0)                
    {                                
        I_res_s = current_sensor_s_p.read();        
        I1_act_s = -1.0*((I_res_s*4.71428) );//0.74787687701613 //0.717075441532258
         
    }else  { //master anticlockwise 
        I_res_s =  current_sensor_s_n.read();
        I1_act_s = 1.0*((I_res_s*4.71428));   //0.713239227822580 
    }
    I_msrd_s += 30.0*(I1_act_s-I_msrd_s)*dt;       //G_Cfilter = 30.00
       
}

//-----------------------=slaveCurrentController=-------------------------------
void slaveCurrentController()
{    
    I_error_s = I_ref_s - I_msrd_s;
    I_err_sum_s += I_error_s*dt;
    I_PID_s = (K_pis*I_error_s);
    I_err_prev_s = I_error_s; 
}

//----------------------=Slave Motor run=---------------------------------------
void motorpwm_s(){
    duty_s = I_PID_s;
     if (duty_s> 0.0)
     {
        if (duty_s > 0.95)
        {
            duty_s = 0.95;
        }
        pwm_clk_s = 0.0;
        pwm_anticlk_s = duty_s;
    }

    else
    {
        if (duty_s< -0.95)
        {
            duty_s = -0.95;
        }
        pwm_anticlk_s = 0.0;
        pwm_clk_s = -1.0 * duty_s;
    }    
}


//--------------------------=Data writting to file=-----------------------------


//--------------------------=File print test=-----------------------------------
void sd_card_write_test()
{
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "count \t x_res\t  RTOB \n");
    fclose(fp); 
    

}

//--------------------------=File print=----------------------------------------
void sd_card_write()
{
    //sprintf (str, "%d\n",count);
    //FILE *fp = fopen("/sd/mydir/sdtest.txt","a");
    //setvbuf(fp, NULL, _IONBF, 0);
    //fwrite(&K_tn,1,sizeof(K_tn), fp);
    //xres = ceil(x_res*1000);
    //fprintf(fp,"%d\t %f\t %f\t \r\n",count,I_DoB,RTOB);    
    //fclose(fp);
}

//--------------------------=Ethernet Initialization=---------------------------

void ethernet_init()
{
    eth.set_link(Ethernet::HalfDuplex100);
    wait_ms(1000); // Needed after startup.
    if(eth.link())
    {
         for(int i=0;i<3;i++)
         { 
            led3=!led3;
            wait(1.0);
         }
    }
}
