#include "mbed.h"
#include "qeihw.h"
 
QEIHW qei_m(QEI_DIRINV_NONE, QEI_SIGNALMODE_QUAD, QEI_CAPMODE_2X, QEI_INVINX_NONE );
int dt_us=150;
   float send_m_angle = 0.0;
   float inc = 0;
   int32_t temp, position = 0;   

DigitalIn safety_14(p14);
DigitalIn safety_15(p13);
DigitalOut myled(LED1);
DigitalOut myled3(LED3);
DigitalIn safety_5(p5);
DigitalIn safety_6(p6);
DigitalIn safety_7(p7);
DigitalIn safety_8(p8);
DigitalIn safety_9(p9);
DigitalIn safety_10(p10);
DigitalIn safety_11(p15);
DigitalIn safety_12(p12);
DigitalIn safety_13(p11);
DigitalIn safety_16(p16);
DigitalIn safety_17(p17);
DigitalIn safety_18(p18);
DigitalIn safety_19(p19);
DigitalIn safety_20(p20);
DigitalIn safety_21(p21);
DigitalIn safety_22(p22);
DigitalIn safety_23(p23);
DigitalIn safety_24(p24);
DigitalIn safety_25(p25);
DigitalIn safety_26(p26);
DigitalIn safety_27(p27);
DigitalIn safety_28(p28);
DigitalIn safety_29(p29);
DigitalIn safety_30(p30);

Ethernet eth;
Ticker ticker;

// Encoder Constants
float const encoder_pulses_m = 10000.0;
#define PI 3.141592653


void send(void)
{
    inc++;
    position = qei_m.GetPosition();
    send_m_angle = position * 2.0 * PI / encoder_pulses_m;
    eth.write((char *)&send_m_angle, sizeof(send_m_angle));
    //eth.write((char *)&inc, sizeof(inc));
    myled3 = !myled3;
    eth.send(); 
    // wait_us(10);
    // return 0;    
} 

int main()
{
    eth.set_link(Ethernet::HalfDuplex100);
    wait_ms(1000); // Needed after startup.

    if(eth.link())
    {
        myled = 1;
    } else
    {
        myled = 0;
    }
    
    int32_t temp, position = 0;                      
    qei_m.SetDigiFilter(480UL);
    qei_m.SetMaxPosition(0xFFFFFFFF);
    
    ticker.attach_us(&send, dt_us);
//ticker.attach_us(&Control_body, dt_us);
/*    while(1) {
          inc++;
          position = qei_m.GetPosition();
          send_m_angle = position * 2.0 * PI / encoder_pulses_m;
          eth.write((char *)&send_m_angle, sizeof(send_m_angle));
          //eth.write((char *)&inc, sizeof(inc));
          myled3 = !myled3;
          eth.send(); 
          wait_us(10);
   }     */
}
