
#include "mbed.h"
Serial pc(USBTX, USBRX);           // tx, rx
SPI spi(p5, p6, p7);               // mosi, miso, sclk
DigitalOut cs(p8);                 //slave select or chip select
#define TIMES 20
#define HK_DATA_LEN 150//in bytes
#define LAST HK_DATA_LEN/TIMES 
Timer t;

//Observations:
//time taken to write 66 bytes to fifo with fifoaccessregister address sending with reading fifo_full once= 0.000218s
//time taken to write 66 bytes to fifo with reading fifo_full once = 0.000215
//time taken to write fifo_full once = 0.000009
//time taken to print timer value = 0.000002

//results from above observations:
//time taken to write 66 bytes to fifo with fifoaccessregister address = 0.000218-0.000011 = 0.000207
//time taken to write one byte to fifo with fifoaccessregister address = 0.000207/66 = 0.000003s


void writereg(uint8_t reg,uint8_t val)
{
    cs = 0;
    __disable_irq();
    spi.write(reg | 0x80);      
    spi.write(val);
    __enable_irq();
    cs = 1;
}
uint8_t readreg(uint8_t reg)
{
    int val;
    cs = 0;
    __disable_irq();
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    __enable_irq();
    cs = 1;
    return val;
}
 
int main() {
    wait(0.5);                           
    uint8_t fifo_full = 0x00,fifo_thresh;
    uint8_t hk[HK_DATA_LEN];             //starts from 0,1,2,3,4!!!
    //filling hk data
    for(int n=0; n<HK_DATA_LEN;n++)
    {
        if(n%10 == 0)
        hk[n] = 0xFF;
        else
        hk[n] = 0xAA;
    }
    
    int i = 0;                           //for loops
    int u = 0;                           //universal count for hk array
    int bar = 0;
    uint8_t rval=0x00;
    cs = 1;                              // Chip must be deselected

    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    
    //initialization
    
    //Common configuration registers
    writereg(0x01,0x04);       //sequencer off,standby mode
    writereg(0x02,0x08);       //packet, ook, no dc
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    writereg(0x07,0x6C);       
    writereg(0x08,0xc0);
    writereg(0x09,0x00);       //try 6C D0 0B for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915
    
    
    //Transmitter registers
    // RegPaLevel
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //irq1: modeready used
    //irq2: fifofull, fifothresh,packetsent used
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //set preamble
    writereg(0x2D,0x00);        //set preamble
    writereg(0x2E,0x80);//sync on with 1 byte of stnc
    writereg(0x2F,0x5E);//sync word 1
    writereg(0x37,0x08);//Fixed length, on dc-free, no crc,issue packetready even if crc fails, no address filter
    writereg(0x38,0x00);        //payload length = 0 ... unlimited payload mode
    writereg(0x3C,0x28);         //fifothresh = 40
        
    //Initialization complete
//~~
    pc.printf("press 't' to transmit\n");
    while(pc.getc() == 't'){
    pc.printf("in");  
    //Filling Data into FIFO ABOUT 66 BYTES                 //fread
    cs = 0;
    __disable_irq();
    spi.write(0x80);//fifo write access
    __enable_irq();
    for(i=0;i<66;i++)
    {
    __disable_irq();    
    spi.write(hk[i]);
    __enable_irq();
    }
    u=i;//check its 66
    cs = 1;
    
                                
    //check for fifofull
    while(fifo_full != 0x80){
    fifo_full = readreg(0x28);
    fifo_full = fifo_full & 0x80;
    }
    
    //Highpower settings
        writereg(0x11,0x7F);    //RegPalevel (20db)                //~
        writereg(0x13,0x0F);    //RegOCP
        writereg(0x5A,0x5D);    //RegTestPa1
        writereg(0x5C,0x7C);    //RegTestPa2
                                            
    //Set to Tx mode
    writereg(0x01,0x0C);

        //Check for fifoThresh
        fifo_thresh = 0x08;
        while(fifo_thresh != 0x00)
        {
            fifo_thresh = readreg(0x28);
            fifo_thresh = fifo_thresh & 0x20;   //5th bit
        } 
    
            while(u!=HK_DATA_LEN){
            
            if((HK_DATA_LEN - u) > TIMES)               //==????
            bar = TIMES;
            else
            bar = (HK_DATA_LEN - u)%TIMES;
            
            //writing again
            cs = 0;
            __disable_irq();
            spi.write(0x80);
            __enable_irq();
            for(i=0; i<bar;i++)
            {
            __disable_irq();
            spi.write(hk[u + i]);
            __enable_irq();
            }
            u = u + i;
            cs = 1;
            
            
            /*******/
            rval = readreg(0x28);
            rval = rval & 0x08;
            if(rval == 0x08)
            pc.printf("000\n",rval);
            /******/
            
            
            
            
            
            
                        
        //Check for fifoThresh
        fifo_thresh = 0x08;
        while(fifo_thresh != 0x00)
        {
            fifo_thresh = readreg(0x28);
            fifo_thresh = fifo_thresh & 0x20;   //5th bit
        }
    }
            
    
    rval = 0;
    //Check if sent
    while(rval != 0x08)
    {
        rval = readreg(0x28);
        rval = rval & 0x08;
        pc.printf("sending... \n"); 
    }
    
    rval = 0;
    pc.printf("packet sent!!! \n");
    pc.printf("%d",u);    
    //Switch back to Standby Mode
    writereg(0x01,0x04);
    pc.printf("press 't' to transmit");
    //wait() to be changed while implementation
    }

//~~
}