//CODE FOR TESTING POWER CONSUMPTION AND OUTPUT POWER OF RFM69HCW
//transmits 240 0xFFs continously.
 

#include "mbed.h"

Serial pc(USBTX, USBRX);          // tx, rx
SPI spi(D11, D12, D13);              // mosi, miso, sclk
DigitalOut cs(D10);                //slave select or chip select

#define TIMES 20
#define DATA 0x00

void writereg(uint8_t reg,uint8_t val)
{
    cs = 0;
    __disable_irq();
    spi.write(reg | 0x80);
    spi.write(val);
    __enable_irq();
    cs = 1;
}
uint8_t readreg(uint8_t reg)
{
    int val;
    cs = 0;
    __disable_irq();
    spi.write(reg & ~0x80);
    val = spi.write(0);
    __enable_irq();
    cs = 1;
    return val;
}

int main()
{
    wait(0.1);                     // wait for POR to complete
    cs=1;                          // chip must be deselected
    wait(0.1);
    spi.format(8,0);
    spi.frequency(10000000);       //10MHz SCLK

    int datalen;                         //for filling data into fifo for the first time
    int i = 0;                           //for loops
    int u = 0;                           //universal count for hk array
    int bar = 0;
    uint8_t rval=0x00;

    //initialization
    //Common configuration registers
    writereg(0x01,0x00);       //sequencer on,standby mode
    writereg(0x02,0x00);// |0x01);       //packet, ook, no dc   //default 0X08 for ook //for fsk 0x00
    //writereg(0x02,0x00);//fsk
    //GFSK
    //writereg(0x02,0x0A);
    //FdevMSB and FDevLSB default
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    writereg(0x07,0x6C);       
    writereg(0x08,0xC0);    
    writereg(0x09,0x00);       //try 6C C0 00 for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915
    
    //Transmitter registers
    // RegPaLevel
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //irq1: modeready used
    //irq2: fifofull, fifothresh,packetsent used
    
    //Packet Engine Registers
    writereg(0x2C,0xFF);        //set preamble
    writereg(0x2D,0xFF);        //set preamble
    writereg(0x2E,0x80);        //sync on for 0x80               ..........................
    writereg(0x2F,0x5E);        //sync word 1               .........................
    writereg(0x37,0x08);// 0x40);// | 0x10);        //packetconfig1                packet issue even if crc fails???..........................
    writereg(0x38,0x00);        //payload length = 0 ... unlimited payload mode
    writereg(0x3C,0x0A);         //fifothresh = 48      because we want it cleared once its 40!!!!

    pc.printf("Press t to transmit.....press s to stop\n");
    while(pc.getc()=='t') {

        //Filling Data into FIFO for the first time
        cs = 0;        
        spi.write(0x80);//fifo write access        
        for(i=0; i<TIMES; i++) {            
            spi.write(DATA);            
        }
        //u=i;//check its 64
        cs = 1;

        //Highpower settings
        writereg(0x11,0x7F);    //RegPalevel (20db)                //~
        writereg(0x13,0x0F);    //RegOCP
        writereg(0x5A,0x5D);    //RegTestPa1
        writereg(0x5C,0x7C);    //RegTestPa2

        //Check for fifoThresh
        while((readreg(0x28) & 0x20) != 0x20);  

        //Set to Tx mode
        writereg(0x01,0x0C);
        
        //Check for fifoThresh
        while((readreg(0x28) & 0x20) != 0x00);
        
      
        while(1) {
            bar = TIMES;
            //writing again
            cs = 0;
            spi.write(0x80);
            for(i=0; i<bar; i++)          
                spi.write(DATA);
            cs = 1;

            //Check for fifoThresh
            while((readreg(0x028) & 0x20) != 0x00);
            pc.printf("transmitting");
            
        }
          //wait for packet sent bit to fire
    while((readreg(0x28) & 0x08) != 0x08);
    pc.printf("packet sent!!! \n");
    }
}
