//time taken while writing data using array
//


#include "mbed.h"
Serial pc(USBTX, USBRX);           // tx, rx
SPI spi(p5, p6, p7);               // mosi, miso, sclk
DigitalOut cs(p8);                 //slave select or chip select
#define TIMES 1
Timer t;
//
//Most important : make a uint8_t array of HK data instead directly reading from the mbed memory while transmission
//
//Observations:
//time taken to write 66 bytes to fifo with fifoaccessregister address sending with reading fifo_full once= 0.000218s
//time taken to write 66 bytes to fifo with reading fifo_full once = 0.000214
//time taken to write fifo_full once = 0.000009
//time taken to print timer value = 0.000002

//results from above observations:
//time taken to write 66 bytes to fifo with fifoaccessregister address = 0.000218-0.000011 = 0.000207
//time taken to write one byte to fifo with fifoaccessregister address = 0.000207/66 = 0.000003s


void writereg(uint8_t reg,uint8_t val)
{
    cs = 0;
    __disable_irq();
    spi.write(reg | 0x80);      
    spi.write(val);
    __enable_irq();
    cs = 1;
}
uint8_t readreg(uint8_t reg)
{
    int val;
    cs = 0;
    __disable_irq();
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    __enable_irq();
    cs = 1;
    return val;
}
 
int main() {
    wait(0.5);                           //wait for POR to complete
    uint8_t fifo_full,fifo_thresh;
    int i = 0;                           //for loops
    uint8_t rval=0x00;
    cs = 1;                              // Chip must be deselected
    
    
    uint8_t hk[100];
    int h = 0;
    for(h=0;h<100;h++)
    hk[h]=0xAA;
    
    
    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    
    //initialization
    
    //Common configuration registers
    writereg(0x01,0x04);       //sequencer off,standby mode
    writereg(0x02,0x08);       //packet, ook, no dc
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    writereg(0x07,0x6C);       
    writereg(0x08,0xD0);
    writereg(0x09,0x0B); //try 6C D0 0B for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915
    
    
    //Transmitter registers
    // RegPaLevel
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //irq1: modeready used
    //irq2: fifofull, fifothresh,packetsent used
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //set preamble
    writereg(0x2D,0x00);        //set preamble
    writereg(0x2E,0x08);        //sync off
    writereg(0x37,0x00);        //packetconfig1 
    writereg(0x38,0x00);        //payload length = 0 ... unlimited payload mode
    writereg(0x3C,0x0);        //fifothresh = 30
        
    //Initialization complete
      
    //Filling Data into FIFO ABOUT 66 BYTES                 //fread
    cs = 0;
    
    __disable_irq();
    spi.write(0x80);//fifo write access
    __enable_irq();
    t.start();
    for(i=0;i<66;i++)
    {
    __disable_irq();    
    spi.write(hk[i]);////fread
    __enable_irq();
    }
   
    cs = 1;
    
                                
                                        //check for fifofull
                                        while(fifo_full != 0x80){
                                        fifo_full = readreg(0x28);
                                        fifo_full = fifo_full & 0x80;
                                        
                                        //pc.printf("waiting for fifo_full...before transmission\n");
                                        }
                                        pc.printf("time takkkkkkkkkken = %Lf\n",t.read());
                                        pc.printf("fifo_full....ready for transmission... \n");
    
    //Set to Tx mode
    writereg(0x01,0x8C);
    
    //Highpower settings
        writereg(0x11,0x7F);    //RegPalevel (20db)                //~
        writereg(0x13,0x0F);    //RegOCP
        writereg(0x5A,0x5D);    //RegTestPa1
        writereg(0x5C,0x7C);    //RegTestPa2

        //Check for fifoThresh
        fifo_thresh = 0x08;
        while(fifo_thresh != 0x00)
        {
            fifo_thresh = readreg(0x28);
            fifo_thresh = fifo_thresh & 0x20;   //5th bit
            pc.printf("u");
            
            rval = 0;
    rval = readreg(0x28);
    rval = rval & 0x08;
    if(rval==0x08)
    pc.printf("already sent ...@*@*&$*&%$*&@$*&@$&*%^$@*&(&@$%*&%*&E*^@&&(*&)#&* \n"); 
    
            
            
            
            
            
            
            
        }
    
        //while(EOF)....check here for EOF
        while(1){
        
            
            
            
            //writing again                         //fread
            int u;
            cs = 0;
            spi.write(0x80);
            for(u=0; u<TIMES;u++)
            {
            __disable_irq();
            spi.write(0xAA);
            __enable_irq();
            }
            cs = 1;
            
            
            
            
    
            /***************/
    //check for packetsent bit
    rval = 0;
    rval = readreg(0x28);
    rval = rval & 0x08;
    if(rval==0x00)
    pc.printf("already sent ...@*@*&$*&%$*&@$*&@$&*%^$@*&(&@$%*&%*&E*^@&&(*&)#&* \n"); 
    /**********/
            
            
            //Check for fifoThresh
        fifo_thresh = 0x08;
        while(fifo_thresh != 0x00)
        {
            fifo_thresh = readreg(0x28);
            fifo_thresh = fifo_thresh & 0x20;   //5th bit
            pc.printf("p");
        }
        fifo_thresh = readreg(0x01); 
        pc.printf("fifothresh = 0x%X",fifo_thresh);
        
            }
            
    
    
    //Check if sent
    while(rval != 0x08)
    {
        rval = readreg(0x28);
        rval = rval & 0x08;
        pc.printf("sending... \n"); 
    }
    
    rval = 0;
    pc.printf("sent!!! \n");
        
    //Switch back to Standby Mode
    writereg(0x01,0x84);
    wait(5);
    }
