/*Algorithm (Assumption : 15 bytes of hk data with each bit stuffed 16 times, therefore info.rate = 75 bits and signalling rate = 1200bps)  
   
I) Initialization
  -A short_beacon array of 15 bytes = 120 bits  (callsign + hk data) is initialized.
  -A byte-counter variable is used to keep a count of the no. of eff. bytes written to FIFO 
  -FIFO THRESH VALUE is set to  48 bytes
II) Wrting to FIFO
  1)First 64 bytes (32 eff. bits = 4 eff. bytes since each bit is repeated 16 times ) are written to FIFO, in following way :
      i) A byte is read from short_beacon.
      ii) Each bit from the byte is checked using pow() function.
      iii) If the bit is 1(or 0), then 0xFF( or 0x00) is written to FIFO two times, since we want each bit to be repeated 16 times.
      iv)process is continued till byte_counter reaches 4 bytes.
  2)fifo_level bit is checked  to check if the thresh of 48 bytes is crossed
      i) 48 bytes are enough to start transmission.   
III) Start Tx mode
  1) We wait for bytes upto thresh to be transmitted
  2) Again data is is filled in fifo with 16 bytes (1 eff. byte since each bit is repeated 16 times )
  3) The above process is continued till byte_counter reaches 15 bytes  
IV) Standby mode
  1) We wait for packetsent interrupt to fire
  2) Then the mode is switched back to Standby 


Misc points ( included in testing ):
-An interrupt function (interrupt_func) was defined to check the effect of an external interrupt on the beacon and spi communication. 
-A Timer was used to check the the time taken for transmission,
 time taken for initialising regs = 0.016397s
 time taken to transmit = 1.613444s (expected : 1.600000s with 1200 bps and 240 bytes packet length  ) 
 time taken to switch back to standby mode = 0.00166s
 total = 1.631501s
-peak power consumption = 130 mA * 3.3 V = 429 mW (matches with datasheet)
 (varies widely with data transmitted, above power measured when all bits transmitted are 1s)
-size of compiled and build file = 18,136 bytes ~ 17.7 KB 
-pc.printf()s added only for testing
-
 */
#include "mbed.h"
Serial pc(USBTX, USBRX);           // tx, rx
SPI spi(p5, p6, p7);               // mosi, miso, sclk
DigitalOut cs_bar(p8);                 //slave select or chip select
//InterruptIn button(p9);
#define TIMES 16      
//Timer t;

/*void interrupt_func()
{
    pc.printf("INTERRUPT_FUNC TRIGGERED\n  wait for 3 secs\n"); 
    wait(3);
    
}*/
void writereg(uint8_t reg,uint8_t val)
{
    cs_bar = 0;
    __disable_irq();
    spi.write(reg | 0x80);      
    spi.write(val);
    __enable_irq();
    cs_bar = 1;
}
uint8_t readreg(uint8_t reg)
{
    uint8_t val;
    cs_bar = 0;
    __disable_irq();
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    __enable_irq();
    cs_bar = 1;
    return val;
}
        
main() {
    
    //button.rise(&interrupt_func);         //interrupt enabled ( rising edge of pin 9)
    wait(0.01);                   //takes 10 ms for POR event
    uint8_t byte_counter = 0;
    
    struct Short_beacon{
        uint8_t Voltage[1];
        uint8_t AngularSpeed[2];
        uint8_t SubsystemStatus[1];
        uint8_t Temp[3];
        uint8_t ErrorFlag[1];
        }Shortbeacon = { {0xAB}, {0xCD, 0xFF} , {0xFF},{0xCC,0xCC,0xCC}, {0xAB} };
    
    //filling hk data
    uint8_t short_beacon[] = { 0xAB, 0x8A, 0xE2, 0xBB, 0xB8, 0xA2, 0x8E,Shortbeacon.Voltage[0],Shortbeacon.AngularSpeed[0], Shortbeacon.AngularSpeed[1],Shortbeacon.SubsystemStatus[0],Shortbeacon.Temp[0],Shortbeacon.Temp[1],Shortbeacon.Temp[2],Shortbeacon.ErrorFlag[0]};
    
    //mask......not used to save memory instead pow() function used for masking
    //uint8_t mask[] = {0x80, 0x40, 0x20,0x10,0x8,0x4,0x2,0x1};
    
    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    
    cs_bar = 1;                              // Chip must be deselected
    
    //initialization
    //Common configuration registers
    writereg(0x01,0x04);       //sequencer on,standby mode
    writereg(0x02,0x08);       //packet-mode used  , ook modultion , no dc-shaping
    writereg(0x03,0x68);       //1200bps datarate
    writereg(0x04,0x2B);       //1200bps datarate
    writereg(0x07,0x6C);       //Frequency MSB
    writereg(0x08,0xD0);       //Frequency MID
    writereg(0x09,0x0B);       //Frequency LSB        ....6C D0 0B for 435 MHZ    
    
    //Transmitter registers
    // RegPaLevel(default +13 dBm)
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //regirq1(0x27): modeready (8th bit) will be checked for interrupts
    //regIrq2(0x28): fifothresh (5th bit) ,packetsent(3rd bit) will be checked for interrupts
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //preamble length MSB = 0
    writereg(0x2D,0x00);        //preamble length LSB = 0
    
    //preamble header needed while testing with RFM69HCW receiver
    //writereg(0x2D,0x0A);      //preamble length LSB = 10 bytes
    
    writereg(0x2E,0x00);        //sync off        
    
    //sync header needed while testing with RFM69HCW receiver
    //writereg(0x2E,0x80);        //sync on        
    //writereg(0x2F,0x5E);        //sync word 1
    
    writereg(0x37,0x08);        //packetconfig1 : unlimited packet mode, no dc-free encoding, crc calculation disabled      
    writereg(0x38,0x00);        //payload length = 0 // due to unlimited payload mode
    writereg(0x3C,0xB0);        //fifo_thresh = 48 ...fifo_level interrupt gets cleared once level goes 48 or below 48 and set once it goes above 48 
     
    //Initialization complete
    
    //Initially 4 bytes are added
    //Filling Data into FIFO 64 BYTES (eff.32 bits = 4 bytes)
    cs_bar = 0; 
    spi.write(0x80);//fifo write access
    for(byte_counter=0 ; byte_counter<4; byte_counter++)
    {    
        for(int i=7; i>=0 ; i--)
        {
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,i))!=0)
            //if((short_beacon[byte_counter] & mask[i]) != 0)...........masking not used to save memory
            {
                spi.write(0xFF);
                spi.write(0xFF);          //writing twice since every bit is to be transmitted 16 times
            }
    else
            {
                spi.write(0x00);
                spi.write(0x00);
            }
        }
    }
    cs_bar = 1; 
                
    //Check for fifoThresh ( 5th bit of 0x28 register should be set once fifo-level is above fifothresh)  
    while((readreg(0x28) & 0x20) != 0x20);                         
    
    //Highpower settings
    writereg(0x11,0x7F);    //RegPalevel (20db)                //~
    writereg(0x13,0x0F);    //RegOCP
    writereg(0x5A,0x5D);    //RegTestPa1
    writereg(0x5C,0x7C);    //RegTestPa2
    
    //Set to Tx mode
    writereg(0x01,0x0C); 
    
    //t.start();
    
    //Check for fifoThresh
    while((readreg(0x28) & 0x20) != 0x00); //( 5th bit of 0x28 register should be set once fifo-level goes below fifothresh)  
                
    for(;byte_counter<15;byte_counter++)         //
    {
            
        //writing 1 eff. byte = 16 actual bytes( due to sttuffing) 
        cs_bar = 0;
        spi.write(0x80);   
        for(int i=7; i>=0 ;i--)
        {
            if((short_beacon[byte_counter] & (uint8_t) pow(2.0,i))!=0)
            //if((short_beacon[byte_counter] & mask[i]) != 0).........masking not used to save memory
        {
            spi.write(0xFF);
            spi.write(0xFF);
        }
        else
        {
            spi.write(0x00);
            spi.write(0x00);
        }
        }
        cs_bar = 1;
                       
        //Check for fifoThresh
        while((readreg(0x28) & 0x20) != 0x00);
    }
    //wait for packet sent bit to fire
    while((readreg(0x28) & 0x08) != 0x08);
    //t.stop();
    //pc.printf("packet sent!!! \n");                       
    
    //Switch back to Standby Mode
    writereg(0x01,0x04);
    
    //Lowpower settings
    writereg(0x11,0x9F);    //RegPalevel (13db)
    writereg(0x13,0x1A);    //RegOCP
    writereg(0x5A,0x55);    //RegTestPa1(setting PA_BOOST on RFIO)
    writereg(0x5C,0x70);    //RegTestPa2(setting PA_BOOST on RFIO)
    
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);
    
    //pc.printf("%f", t.read());
}