#include "FreescaleIAP.h"

int strt_add_thres = flash_size() - (11*SECTOR_SIZE);
uint32_t flasharray_thres[32] = {0};

void FCTN_CDMS_WR_FLASH(uint16_t , uint32_t);
int strt_add = flash_size() - (2*SECTOR_SIZE);
uint32_t flasharray[32];    //256+(3*1024)
uint32_t INITIAL_FLASH[32];
/*corrected*/
int *nativeflash = (int*)strt_add;

void FLASH_INI()
{
    uint32_t read[32]; 
    for(int i=0;i<32;i++)
        {  
            read[i] = nativeflash[i];
        }
            
    if(read[0] == -1)
        for(int j=0;j<32;j++)
            {   
                FCTN_CDMS_WR_FLASH(j,INITIAL_FLASH[j]); 
            } 
    else
       {
        for(int j=0;j<32;j++)
            {   
                read[j] = nativeflash[j];
            }
            EPS_V_A_EN_STATUS = read[0];
            BAE_SW_STATUS   = read[1]; 
            CDMS_SD_SW_STATUS = read[2];
            PL_BEE_SW_STATUS = read[3];
            PL_EPS_LATCH_SW_EN = read[4];
            RTC_INIT_STATUS = read[5];
            CDMS_RTC_DISABLE = read[6];
            CDMS_RESET_COUNTER = read[7];
            TIME_LATEST_CDSMS_RESET = read[8];
            COM_TC_BYTES_LIMIT = read[9];
            COM_RX_CURRENT_MAX = read[10];
            COM_RX_DISABLE_TIMEOUT = read[11];
            COM_PA_TMP_HIGH = read[12];
            COM_PA_RECOVERY_TIMEOUT = read[13];
            COM_SESSION_TIMEOUT = read[14];
            COM_RSSI_MIN = read[15];
            SD_LIB_BLK_CURRENT = read[16];
        }
    
}

/*Writing to the Flash*/
void FCTN_CDMS_WR_FLASH(uint16_t j,uint32_t datablock)  //j-position to write address  ; fdata - flash data to be written
{
    for(int i=0;i<17;i++)
    {
        flasharray[i]=nativeflash[i];
    }
    flasharray[j]=datablock;
    erase_sector(strt_add);
    program_flash(strt_add, (char*)flasharray,32);
}
/*End*/

/*===================================================MMS Functions=================================================*/

void FCTN_CDMS_WR_S_FLASH(uint16_t mid,uint32_t datablock);

void FCTN_CDMS_WR_S_FLASH(uint16_t mid,uint32_t datablock)
{
    if(mid == 0x0100)
    {
        FCTN_CDMS_WR_FLASH(11,(datablock>>16) & 0x000000FF);
        FCTN_CDMS_WR_FLASH(13,(datablock>>8) & 0x000000FF);
        FCTN_CDMS_WR_FLASH(14,datablock & 0x000000FF);
    }
    else if(mid == 0x0101)
    {
        FCTN_CDMS_WR_FLASH(12,(datablock>>16) & 0x000000FF);
        FCTN_CDMS_WR_FLASH(10,(datablock>>8) & 0x000000FF);
        FCTN_CDMS_WR_FLASH(15,datablock & 0x000000FF);
    }
    else if(mid == 0x0102)
    {
        FCTN_CDMS_WR_FLASH(9,datablock & 0x0000FFFF);
    }
    else if(mid == 0x0103)
    {
        FCTN_CDMS_WR_FLASH(6,datablock & 0x00000001);
    } 
}