//F11 to exit full screen mode
/*---------------------------------------------------------------------------
                            Testing PL_MAIN
----------------------------------------------------------------------------*/


/* Testing as per the flow chart  */
/* columns of the array schedule1[][] correspond to Year,Month,Day,Hours,Minutes,Seconds,SID and EXEC_STATUS in integer formats*/
Base_tm* FCTN_CDMS_RLY_TMTC(Base_tc *tc_ptr);

extern uint8_t schedule1[32][8]=
                        {
                            {0,1,1,0,0,15,3,3},
                            {0,1,1,0,0,45,2,3},
                            {0,1,1,0,1,0,1,3},
                            {0,1,1,0,1,25,0,3},     
                            {0,1,1,0,1,50,3,3},
                            {0,1,1,0,2,10,2,3},
                            {0,1,1,0,1,40,2,3},
                            {0,1,1,0,1,10,2,3},
                            {0,1,1,0,3,40,2,0},
                            {0,1,1,0,4,10,2,3},
                            
                            {0,1,1,0,4,40,0,1},
                            {0,1,1,0,5,10,3,3},
                            {0,1,1,0,5,40,3,3},
                            {0,1,1,0,6,10,2,3},
                            {0,1,1,0,6,40,1,0},
                            {0,1,1,0,7,10,2,3},
                            {0,1,1,0,7,40,3,3},
                            {0,1,1,0,8,10,0,3},
                            {0,1,1,0,8,40,1,3},
                            {0,1,1,0,9,10,1,2},                           

                            {0,1,1,0,9,40,2,3},
                            {0,1,1,0,10,10,3,1},
                            {0,1,1,0,10,40,3,3},                         
                            {0,1,1,0,11,10,2,1},
                            {0,0,0,0,11,40,0,0},
                            {0,1,1,0,12,10,0,0},
                            {0,1,1,0,12,40,0,0},
                            {0,1,1,0,13, 0,0,0},
                            {0,1,1,0,0, 0,0,0},
                            {0,1,1,0,0, 0,0,0},

                            {0,1,1,0,0, 0,0,0},
                            {0,1,1,0,0, 0,0,0},
                        };

void convert(Base_tc* test_tc)
{    
    for(uint8_t k=3;k<=127;k+=4)
    {
        /*-----------1st byte of a block----------*/
        test_tc->TC_string[k] &= 0x00;
        //setting Year (2 bits)
        //test_tc->TC_string[k] &= (~0xC0);
        test_tc->TC_string[k] |= ((schedule1[(k-3)/4][0] & 0x03)<<6);

        //setting Month (4 bits)
        //test_tc->TC_string[k] &= (~0x3C);
        test_tc->TC_string[k] |= ((schedule1[(k-3)/4][1] & 0x0F)<<2);

        //setting first two bits(MSB) of Day
        //test_tc->TC_string[k] &= (~0x03);
        test_tc->TC_string[k] |= ((schedule1[(k-3)/4][2] & 0x18)>>3);
        /*------------end of 1st byte-------------*/

        /*-----------2nd byte of a block----------*/
        test_tc->TC_string[k+1] &= 0x00000000;
        //setting remaining 3 bits of Day
        //test_tc->TC_string[k+1] &= (~0xE0);
        test_tc->TC_string[k+1] |= ((schedule1[(k-3)/4][2] & 0x07)<<5);

        //setting Hours (5 bits)
        //test_tc->TC_string[k+1] &= (~0x1F);
        test_tc->TC_string[k+1] |= ((schedule1[(k-3)/4][3] & 0x1F));
        /*------------end of 2nd byte-------------*/

        /*-----------3rd byte of a block----------*/
        test_tc->TC_string[k+2] &= 0x00000000;
        //setting Minutes (6 bits)
        //test_tc->TC_string[k+2] &= (~0xFC);
        test_tc->TC_string[k+2] |= ((schedule1[(k-3)/4][4] & 0x3F)<<2);

        //setting first 2 bits(MSB) of Seconds
        //test_tc->TC_string[k+2] &= (~0x03);
        test_tc->TC_string[k+2] |= ((schedule1[(k-3)/4][5] & 0x30)>>4);
        /*------------end of 3rd byte-------------*/        

        /*-----------4th byte of a block----------*/
        test_tc->TC_string[k+3] &= 0x00;
        //setting remaining 4 bits of Seconds
        //test_tc->TC_string[k+3] &= (~0xF0);
        test_tc->TC_string[k+3] |= ((schedule1[(k-3)/4][5] & 0x0F)<<4);

        //setting STATE_ID (2 bits)
        //test_tc->TC_string[k+3] &= (~0x0C);
        test_tc->TC_string[k+3] |= ((schedule1[(k-3)/4][6] & 0x03)<<2);

        //setting EXEC_STATUS (2 bits)
        //test_tc->TC_string[k+3] &= (~0x03);
        test_tc->TC_string[k+3] |= ((schedule1[(k-3)/4][7] & 0x03));
        /*------------end of 4th byte-------------*/                
    }    
}
/*void test_schedule_1(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x71;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_2(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x72;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_3(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x73;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_4(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x74;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_5(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x75;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_6(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x76;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}

void test_schedule_F(Base_tm *test_tm_ptr)
{
    Base_tc *test_tc = new Long_tc;
    test_tc->next_TC = NULL;
    test_tc->TC_string[0] = 0x01;
    test_tc->TC_string[1] = 0xB2;
    test_tc->TC_string[2] = 0x7F;
    convert(test_tc);
    test_tc->TC_string[131] = 0x00;
    test_tc->TC_string[132] = 0x00;
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);
}*/
#define test_schedule_1(test_tm_ptr) {\
    Base_tc *test_tc = NULL;\
    if(!(test_tc  = new Long_tc))\
    {\
       gPC.printf("\n\rError: out of memory");\
       return;\
    }\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x71;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_2(test_tm_ptr) {\
    Base_tc *test_tc = new Long_tc;\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x72;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_3(test_tm_ptr) {\
    Base_tc *test_tc = new Long_tc;\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x73;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_4(test_tm_ptr) {\
    Base_tc *test_tc = new Long_tc;\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x74;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_5(test_tm_ptr) {\
    Base_tc *test_tc = new Long_tc;\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x75;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_6(test_tm_ptr) {\
    Base_tc *test_tc = new Long_tc;\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x76;\
    convert(test_tc);\
    test_tc->TC_string[131] = 0x00;\
    test_tc->TC_string[132] = 0x00;\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
#define test_schedule_F(test_tm_ptr) {\
    Base_tc *test_tc = NULL;\
    if(!(test_tc  = new Long_tc))\
    {\
       gPC.printf("\n\rError: out of memory");\
       return;\
    }\
    test_tc->next_TC = NULL;\
    test_tc->TC_string[0] = 0x01;\
    test_tc->TC_string[1] = 0xB2;\
    test_tc->TC_string[2] = 0x7F;\
    for(uint8_t i=3;i<133;i++)\
    {\
        test_tc->TC_string[i] = 0;\
    }\
    uint16_t crc16 = crc16_gen(test_tc->TC_string,133);\
    test_tc->TC_string[133] = (uint8_t)(crc16 & 0xFF00)>>8;\
    test_tc->TC_string[134] = (uint8_t)(crc16 & 0x00FF);\
    test_tm_ptr =  FCTN_CDMS_RLY_TMTC(test_tc);\
    delete test_tc;\
}
void send_verify_0xF(Base_tm* test_tm_ptr)
{
    uint32_t temp_blk[4] = {0};
    uint8_t j=0,tm_data_err_count=0;
    Base_tm* temp_ptr;
    test_schedule_F(test_tm_ptr);
    gPC.printf("\n\r----------------------------------------------------------------------------------");
    gPC.printf("\n\rTC_Schedule_Report(0xF):\n");
    temp_ptr=test_tm_ptr;
    while(temp_ptr!=NULL)
    {
        /*gPC.printf("\n\rTM[0] = %02X",temp_ptr->TM_string[0]);
        gPC.printf("\tTM[1] = %02X",temp_ptr->TM_string[1]);
        gPC.printf("\tTM[2] = %02X",temp_ptr->TM_string[2]);
        gPC.printf("\tTM[3] = %02X",temp_ptr->TM_string[3]);*/
        for(uint8_t i=0;i<=112;i+=16)
        {
            temp_blk[0] &= 0x00000000;
            temp_blk[0] |= (((uint32_t)(temp_ptr->TM_string[i+4]))&0x000000FF)<<24;
            temp_blk[0] |= (((uint32_t)(temp_ptr->TM_string[i+5]))&0x000000FF)<<16;
            temp_blk[0] |= (((uint32_t)(temp_ptr->TM_string[i+6]))&0x000000FF)<<8;
            temp_blk[0] |= (((uint32_t)(temp_ptr->TM_string[i+7]))&0x000000FF);

            temp_blk[1] &= 0x00000000;
            temp_blk[1] |= (((uint32_t)(temp_ptr->TM_string[i+8]))&0x000000FF)<<24;
            temp_blk[1] |= (((uint32_t)(temp_ptr->TM_string[i+9]))&0x000000FF)<<16;
            temp_blk[1] |= (((uint32_t)(temp_ptr->TM_string[i+10]))&0x000000FF)<<8;
            temp_blk[1] |= (((uint32_t)(temp_ptr->TM_string[i+11]))&0x000000FF);

            temp_blk[2] &= 0x00000000;
            temp_blk[2] |= (((uint32_t)(temp_ptr->TM_string[i+12]))&0x000000FF)<<24;
            temp_blk[2] |= (((uint32_t)(temp_ptr->TM_string[i+13]))&0x000000FF)<<16;
            temp_blk[2] |= (((uint32_t)(temp_ptr->TM_string[i+14]))&0x000000FF)<<8;
            temp_blk[2] |= (((uint32_t)(temp_ptr->TM_string[i+15]))&0x000000FF);
            
            temp_blk[3] &= 0x00000000;
            temp_blk[3] |= (((uint32_t)(temp_ptr->TM_string[i+16]))&0x000000FF)<<24;
            temp_blk[3] |= (((uint32_t)(temp_ptr->TM_string[i+17]))&0x000000FF)<<16;
            temp_blk[3] |= (((uint32_t)(temp_ptr->TM_string[i+18]))&0x000000FF)<<8;
            temp_blk[3] |= (((uint32_t)(temp_ptr->TM_string[i+19]))&0x000000FF);

            if(temp_blk[0]!=pl_block[(i/4)+j])
                tm_data_err_count++;
            if(temp_blk[1]!=pl_block[(i/4)+j+1])
                tm_data_err_count++;
            if(temp_blk[2]!=pl_block[(i/4)+j+2])
                tm_data_err_count++;
            if(temp_blk[3]!=pl_block[(i/4)+j+3])
                tm_data_err_count++;
            //gPC.printf("\n\r%03d-0x%08X\t%03d-0x%08X",(i/4)+j,temp_blk[0],(i/4)+1+j,temp_blk[1]);
            //gPC.printf("\t%03d-0x%08X\t%03d-0x%08X\n",(i/4)+2+j,temp_blk[2],(i/4)+3+j,temp_blk[3]);             
        }
        j+=32;
        //gPC.printf("\n");
        temp_ptr = temp_ptr->next_TM;
    }
    if(tm_data_err_count!=0)
    {
        gPC.printf("\n\rTM Data(0xF) not matching pl_block!!!");
        gPC.printf("\n\rNumber of mismatches = %d",tm_data_err_count);
    }
    else if(tm_data_err_count==0)
    {
        gPC.printf("\n\rNo errors in TM Data(0xF)");
    }
    gPC.printf("\n\r----------------------------------------------------------------------------------");
    Base_tm *temp;\
    temp = test_tm_ptr;\
    while(test_tm_ptr!=NULL)\
    {\
        temp = temp->next_TM;\
        delete test_tm_ptr;\
        test_tm_ptr = temp;\
    }\
}
void verify_extracted(uint8_t c)
{
    uint8_t wrong_extracted=0;
    uint8_t temp_extracted[8] = {0};
    for(uint8_t z=(32*(c-1));z<(32*c);z++)
    {        
        temp_extracted[0] = (uint8_t)((pl_block[z]&0xC0000000)>>30);
        temp_extracted[1] = (uint8_t)((pl_block[z]&0x3C000000)>>26);
        temp_extracted[2] = (uint8_t)((pl_block[z]&0x03E00000)>>21);
        temp_extracted[3] = (uint8_t)((pl_block[z]&0x001F0000)>>16);
        temp_extracted[4] = (uint8_t)((pl_block[z]&0x0000FC00)>>10);
        temp_extracted[5] = (uint8_t)((pl_block[z]&0x000003F0)>>4);
        temp_extracted[6] = (uint8_t)((pl_block[z]&0x0000000C)>>2);
        temp_extracted[7] = (uint8_t)((pl_block[z]&0x00000003));
        
        for(uint8_t y=0;y<8;y++)
        {
            if(temp_extracted[y]!=schedule1[z-(32*(c-1))][y])
                wrong_extracted++;
        }
    }
    if(wrong_extracted!=0)
    {
        gPC.printf("\n\rExtracted values do not match input values!!!");
        gPC.printf("\n\rNumber of wrong extracted values = %d",wrong_extracted);
        wrong_extracted = 0;
    }
    else if(wrong_extracted==0)
        gPC.printf("\n\rExtracted values are correct(0x%d)",c);        
}
void test_pl_main()
{
    uint32_t temp_pl_block[192] = {0};
    uint8_t wrong_modify=0,z;
    Base_tm* test_tm_ptr;    
    for(z=0;z<192;z++)
        pl_block[z] = 0xFFFFFFFF;
   // testing 0xF
    send_verify_0xF(test_tm_ptr);
    for(z=0;z<192;z++)  
        temp_pl_block[z] = pl_block[z];
        
    //testing TC = 0x1,0x2...0x6
    int w =1;
    for(uint8_t v=1;w<1000;w++)
    {        
        /*switch(v)
        {
            case 1: test_schedule_1(test_tm_ptr);
                    break;
            case 2: test_schedule_2(test_tm_ptr);
                    break;
            case 3: test_schedule_3(test_tm_ptr);
                    break;
            case 4: test_schedule_4(test_tm_ptr);
                    break;
            case 5: test_schedule_5(test_tm_ptr);
                    break;
            case 6: test_schedule_6(test_tm_ptr);
                    break;
        }*/
        gPC.printf("\n\rIndex:%d",w);
        if(v==1)
        {
            test_schedule_1(test_tm_ptr);
        }
        else if(v==2)
        {
            test_schedule_2(test_tm_ptr);
        }
        else if(v==3)
        {
            test_schedule_3(test_tm_ptr);
        }
        else if(v==4)        
        {
            test_schedule_4(test_tm_ptr);
        }
        else if(v==5)
        {
            test_schedule_5(test_tm_ptr);
        }
        else if(v==6)
        {
            test_schedule_6(test_tm_ptr);
        }
        for(z=0;z<192;z++)
        {
            if((z>=((v-1)*32)) && (z<=((v*32)-1)))
                z++;
            else
            {
                if(temp_pl_block[z]!=pl_block[z])
                    wrong_modify++;
            }
        }
        if(wrong_modify!=0)
        {
            gPC.printf("\n\rWrong values of pl_block modified by TC = 0x%d",v);
            gPC.printf("\n\rNumber of wrong modifications = %d",wrong_modify);
            wrong_modify = 0;
        }
        else if(wrong_modify==0)
        {
            gPC.printf("\n\rTC(0x%d) updated pl_block correctly",v);
            for(uint8_t i=0;i<=188;i+=4)
            {
                //gPC.printf("\n\r%03d-0x%08X\t%03d-0x%08X",(i),pl_block[i],(i)+1,pl_block[(i)+1]);
                //gPC.printf("\t%03d-0x%08X\t%03d-0x%08X\n",(i)+2,pl_block[(i)+2],(i)+3,pl_block[(i)+3]);
            }
        }
        send_verify_0xF(test_tm_ptr);
        verify_extracted(v);
        for(z=0;z<192;z++)
            temp_pl_block[z] = pl_block[z];
        //wait(1);
    }
    gPC.printf("\n\rTesting TC_TM block processing complete");
}