
// TESTING PUSH PULL IN MAIN CPP


#include "mbed.h"

#define DEBUG 1

#include "SimpleDMA.h"
#include "dmaSPIslave.h"
#include "rtos.h"
#include "mbed_debug.h"

#include "Structures.h"
#include "pinconfig.h"
#include "DefinitionsAndGlobals.h"
#include "crc.h"
#include "i2c.h"
#include "COM_SND_TM_functions.h"
#include "COM_SND_TM.h"
#include "cdms_rtc.h"
#include "cdms_sd.h"
#include "common_functions.h"
#include "RESET_functions.h"
#include "CDMS_HK.h"
#include "OBSRS.h"
#include "adf.h"
#include "COM_RCV_TC.h"
//#include "Flash.h"
#include "FMS_all.h"
#include "CDMS_PL.h"
#include "COM_MNG_TMTC.h"
#include "COM_POWER_ON_TX.h"
#include "COM_POWER_OFF_TX.h"
#include "Compression.h"
#include "ThreadsAndFunctions.h"
#include "TEST_PL.h"

#define PL_TC(tm_ptr){\
    Base_tc *beacon_tc = new Long_tc;\
    beacon_tc->next_TC = NULL;\
    PUTshort_or_long(beacon_tc,LONG_TC_CODE);\
    PUTcrc_pass(beacon_tc,0x1);\
    PUTexec_status(beacon_tc,0);\
    beacon_tc->TC_string[0] = 0x01;\
    beacon_tc->TC_string[1] = 0x60;\
    beacon_tc->TC_string[2] = 0x81;\
    beacon_tc->TC_string[3] = 0x21;\
    beacon_tc->TC_string[4] = 0x00;\
    beacon_tc->TC_string[5] = 0;\
    beacon_tc->TC_string[6] = 0;\
    beacon_tc->TC_string[7] = 0;\
    beacon_tc->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(beacon_tc->TC_string, 9);\
    beacon_tc->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    beacon_tc->TC_string[10] = (crc16 & 0x00FF);\
    for(int i = 11; i<135;i++) beacon_tc->TC_string[i] = 0;\
    tm_ptr =  FCTN_CDMS_RLY_TMTC(beacon_tc);\
}
#define OBSRS_TC(tm_ptr){\
    Base_tc *beacon_tc = new Short_tc;\
    beacon_tc->next_TC = NULL;\
    PUTshort_or_long(beacon_tc,SHORT_TC_CODE);\
    PUTcrc_pass(beacon_tc,0x1);\
    PUTexec_status(beacon_tc,0);\
    beacon_tc->TC_string[0] = 0x01;\
    beacon_tc->TC_string[1] = 0x20;\
    beacon_tc->TC_string[2] = 0xf2;\
    beacon_tc->TC_string[3] = 0x00;\
    beacon_tc->TC_string[4] = 0x00;\
    beacon_tc->TC_string[5] = 0;\
    beacon_tc->TC_string[6] = 2;\
    beacon_tc->TC_string[7] = 0;\
    beacon_tc->TC_string[8] = 2;\
    uint16_t crc16 = crc16_gen(beacon_tc->TC_string, 9);\
    beacon_tc->TC_string[9]  = (crc16 & 0xFF00)>>8;\
    beacon_tc->TC_string[10] = (crc16 & 0x00FF);\
    Base_tm *tm_ptr_head = NULL;\
                            get_call_sign(tm_ptr_head);\
                            Base_tm *put_tm_here = NULL;\
                            /*execute_obsrs(current_TC, put_tm_here)*/\
                            /*read_TC(current_TC);*/\
                            execute_OBSRS_TC(beacon_tc);\
                            gPC.puts("enter_adf\r\n");\
                            transmit_adf;\
                            gPC.puts("exit_adf\r\n");\
}
//void set_sig(){gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);}
int main()
{
    
    CDMS_I2C_GPIO = 0; 
    PL_I2C_GPIO = 0; 
    
    //gLEDR = 1;
    
    // ******************INITIALISATIONS START******************
    // COM RX
    
    RX1M.baud(1200);
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;
    gRX_HEAD_DATA_NODE->next_node = NULL;
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;
    gRX_COUNT = 0;
//    gRX_CURRENT_PTR = gRX_CURRENT_DATA_NODE->values;
    RX1M.attach(&rx_read, Serial::RxIrq);
    
    // DEBUG
    //gPC.puts("welcome to mng_tm_tc\r\n");
    gPC.baud(9600);//changed for bypassing COM
    
    // COMMON SPI
    spi.format(8,0);
    spi.frequency(1000000);

    // SD CARD
    cs_sd = 1;
    gCS_RTC = 1;
    gCS_ADF = 1;
    
    FCTN_CDMS_INIT_RTC();/* rtc initialization*/
    FCTN_CDMS_SD_INIT();/* sd card initialization*/
    
    
    uint8_t test[512] = {0};
    disk_write(test,7000); //to be used only just before launch
    
    #if DEBUG
    gPC.puts("welcome to mng_tmtc\r\n");
    #endif
    
    
    
    // COM_MNG_TMTC THREAD
    gCOM_MNG_TMTC_THREAD = new Thread(COM_MNG_TMTC_FUN);
    gCOM_MNG_TMTC_THREAD->set_priority(osPriorityHigh);
    #if DEBUG
    gPC.puts("allocating threads\r\n");
    #endif
    gSCIENCE_THREAD = new Thread(SCIENCE_FUN);
   // gPC.puts("step one complete\r\n");
    gSCIENCE_THREAD->set_priority(osPriorityAboveNormal);
    #if DEBUG
    gPC.puts("competed allocating threads\r\n");
    #endif
    
    
    master.frequency(400000);
    PL_wo_dma = new RtosTimer(payload_isr_fun_dma, osTimerPeriodic,(void * )NULL);
    //PL_wo_dma->start(6000);//
    gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);
    
    
    
    /*while(1){
    gPC.printf("PL_TC sending\r\n");
    
    Base_tm *tm_ptr = new Long_tm;
    PL_TC(tm_ptr);
    wait(1);
    }
    gPC.printf("PL_TC sent");
    */
    // *******************INITIALISATIONS END********************
    
    FCTN_CDMS_HK_MAIN((void *)NULL);
    //RtosTimer gCDMS_HK_TIMER(FCTN_CDMS_HK_MAIN, osTimerPeriodic);
    //gCDMS_HK_TIMER.start(5000);
    
    /*starting the thread with signal*/
    //set_sig();
    //payload_isr_fun();
    
    /*Calculating Stack used*/
    
    int state;
    /*while (true) { 
    Thread::wait(500); 
    state = gSCIENCE_THREAD->get_state(); 
    //gPC.printf("Thread state %d\r\n", state); 
    if(state == Thread::Inactive) 
    {delete gSCIENCE_THREAD;
    break;}
    }*/
    
    
    
    while(true){
        Thread::wait(osWaitForever);
        //state = gCOM_MNG_TMTC_THREAD->get_state() + '0';
         gLEDG = !gLEDG;
        //gPC.putc(state); 
    }
}