

void FCTN_CDMS_HK_MAIN();
void FCTN_CDMS_HK();
void VERIFY_COMRX();
void VERIFY_RTC();
void CDMS_HK_SD();
void HANDLE_HW_FAULTS();
void HANDLE_HW_FAULT_SD();
void HANDLE_HW_FAULT_BAE();
void HANDLE_HW_FAULT_PL();
void FUNC_CDMS_GPIO_STATUS();
void minMaxHkData();
void COLLECT_CDMS_RAM();

AnalogIn TempInput(PIN27);          // Input from Current Multiplexer
AnalogIn CDMS_temp_sensor(PIN53);
AnalogIn COMRX_RSSI_volatge(PIN70);


DigitalOut SelectLinec3 (PIN79); // MSB of Select Lines
DigitalOut SelectLinec2 (PIN78);
DigitalOut SelectLinec1 (PIN77);
DigitalOut SelectLinec0 (PIN76); // LSB of Select Lines

Convolution CDMS_HEALTH;
Convolution BAE_HEALTH;
unsigned char CDMS_HK_FRAME[134] = {0};
char BAE_HK[134] = {0};
uint8_t convoluted_CDMS_HK[270];
uint8_t interleave_CDMS_HK[288];
uint8_t CDMS_HEALTH_FINAL[512] = {0};
uint8_t convoluted_BAE_HK[270];
uint8_t interleave_BAE_HK[288];
uint8_t BAE_HEALTH_FINAL[512] = {0};
unsigned char BAE_HK_FRAME[134] = {0};



void FCTN_CDMS_HK_MAIN(void const *args)
{
    while(1)
    {
    gPC.printf("Entering HK thread");
    gHK_THREAD->signal_wait(HK_SIGNAL);
    gMutex.lock();
    gPC.printf("HK thread signal set");
    CDMS_HK_MAIN_STATUS = 0x01;
    CDMS_HK_MAIN_COUNTER++;

    FCTN_CDMS_HK();
    RSSI_volatge = COMRX_RSSI_volatge.read() * 3.3;
    VERIFY_COMRX();
    VERIFY_RTC();
    HANDLE_HW_FAULTS();
    FUNC_CDMS_GPIO_STATUS(); //yet to be done
    gPC.printf("Checking RTCoun");
    uint8_t CDMS_quant[19];
    for(int i=0; i<16; i++) {
        CDMS_quant[i]= (uint8_t)quant_data.temp_quant[i];
    }
    CDMS_quant[16]= (uint8_t)RSSI_volatge;
    CDMS_quant[17]= (uint8_t)quant_data.CDMS_temp_quant;
    minMaxHkData();
    gPC.printf("here1");
    uint64_t time = FCTN_CDMS_RD_RTC();             //Reading Time from RTC
    gPC.printf("0x%08X \n",time);
    time = time>>7;
    uint32_t HK_time = (uint32_t)time;
    for(int i = 0; i<4; i++)
        CDMS_HEALTH_DATA[i] = HK_time >> i;
    gPC.printf("here2");
    // Here: Have to FIT flash data.
    for(int i = 0; i<19; i++)                       //Collecting Data from Temp sensors
        CDMS_HEALTH_DATA[i+24] = CDMS_quant[i];

    COLLECT_CDMS_RAM();                             //Reading RAM parameters

    CDMS_HEALTH_DATA[126] = GPIO_STATUS;            //Reading GPIO Pins
    CDMS_HEALTH_DATA[127] = GPIO_STATUS >> 8;
    FCTN_SD_MNGR();                                 //Adding FSC & TMID to TM frame
    CDMS_HK_FRAME[0] = 0x20;
    CDMS_HK_FRAME[1] = FSC_CURRENT[4]+1;
    CDMS_HK_FRAME[2] = (FSC_CURRENT[4]+1) >> 8;
    CDMS_HK_FRAME[3] = (FSC_CURRENT[4]+1) >> 16;
    gPC.printf("here3");
    for(int i = 0; i<128; i++)                       /*Adding actual CDMS Health data to TM frame*/
        CDMS_HK_FRAME[4+i] = CDMS_HEALTH_DATA[i];

    uint16_t crc = crc16_gen(CDMS_HK_FRAME,132);      /*Adding CRC to TM frame*/
    CDMS_HK_FRAME[133] = crc;
    CDMS_HK_FRAME[132] = crc >> 8;
    
    exor(CDMS_HK_FRAME);
    CDMS_HEALTH.convolutionEncode(CDMS_HK_FRAME , convoluted_CDMS_HK);
    CDMS_HEALTH.convolutionEncode(CDMS_HK_FRAME + 67, convoluted_CDMS_HK + 135);
    interleave(convoluted_CDMS_HK ,  interleave_CDMS_HK);
    interleave(convoluted_CDMS_HK +135, interleave_CDMS_HK + 144);
    for(int i=0; i<288; i++)
        CDMS_HEALTH_FINAL[i] = interleave_CDMS_HK[i];

    //SD_WRITE(CDMS_HEALTH_FINAL,FSC_CURRENT[4]+1,4);
    gPC.printf("\rCompleted CDMS HK\n");

    /*---------------------------------- BAE HK --------------------------------------------*/


    BAE_HK_I2C = FCTN_I2C_READ(BAE_HK,134);
    gPC.printf("\rEntering BAE HK\n");
    if(BAE_HK_I2C == 0) {
        crc = crc16_gen((unsigned char *)BAE_HK,132);
        if(crc == ((uint16_t)BAE_HK[132] << 8) | (uint16_t)BAE_HK[133]){
            TIME_LATEST_I2C_BAE = FCTN_CDMS_RD_RTC() >> 7;
            for(int i = 0; i<15; i++)
                gPC.printf("\r 0x%02X\n",BAE_HK[i]);
            for(int i = 0; i<4; i++)
            BAE_HK[i] = HK_time >> i;
            BAE_HK_FRAME[0] = 0x28;
            BAE_HK_FRAME[1] = FSC_CURRENT[5]+1;
            BAE_HK_FRAME[2] = (FSC_CURRENT[5]+1) >> 8;
            BAE_HK_FRAME[3] = (FSC_CURRENT[5]+1) >> 16;
            for(int i = 0; i<128; i++)                       /*Adding actual CDMS Health data to TM frame*/
                BAE_HK_FRAME[4+i] = BAE_HK[i];
            crc = crc16_gen(BAE_HK_FRAME,132);               /*Adding CRC to TM frame*/
            BAE_HK_FRAME[133] = crc;
            BAE_HK_FRAME[132] = crc >> 8;
            exor(BAE_HK_FRAME);
            BAE_HEALTH.convolutionEncode(BAE_HK_FRAME , convoluted_BAE_HK);
            BAE_HEALTH.convolutionEncode(BAE_HK_FRAME + 67, convoluted_BAE_HK + 135);
            interleave(convoluted_BAE_HK ,  interleave_BAE_HK);
            interleave(convoluted_BAE_HK +135, interleave_BAE_HK + 144);
            for(int i=0; i<288; i++)
                BAE_HEALTH_FINAL[i] = interleave_BAE_HK[i];
            //SD_WRITE(BAE_HEALTH_FINAL,FSC_CURRENT[5]+1,5);
        }
        
    } else {
        gPC.printf("\rBAE HK data not recieved through I2C\n");
        for(int i = 0; i<134; i++)
            BAE_HK[i] = 0;
    }
    gPC.printf("\rCompleted BAE HK\n");

    /*----------------------------------Beacon message--------------------------------------*/
    unsigned char SC_HK_LBM_0[135];
    SC_HK_LBM_0[0] = 0;       // Sending long beacon msg as telecommand with Packet sequence count 0x00
    // Add HK bits

    // Add SC bits
    crc = crc16_gen(SC_HK_LBM_0,133);
    SC_HK_LBM_0[132] = crc;
    SC_HK_LBM_0[133] = crc >> 8;
    FCTN_I2C_WRITE((char *)SC_HK_LBM_0,135);
    gPC.printf("\rCompleted Beacon\n");
    gMutex.unlock();
    }
}

int quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=255)y=255;
    return y;
}

char saveMin(char x,char y)
{
    return (y<x)?y:x;
}

char saveMax(char x,char y)
{
    return (y>x)?y:x;
}

void minMaxHkData()
{
    if(firstCount==true) {
        for (int i = 0; i < 16; ++i) {
            min_max_data.temp_min[i] = quant_data.temp_quant[i];
            min_max_data.temp_max[i] = quant_data.temp_quant[i];
        }

        min_max_data.CDMS_temp_min=quant_data.CDMS_temp_quant;
        min_max_data.CDMS_temp_max=quant_data.CDMS_temp_quant;
    } else {
        for (int i = 0; i < 16; ++i) {
            min_max_data.temp_min[i] = saveMin(min_max_data.temp_min[i],quant_data.temp_quant[i]);
            min_max_data.temp_max[i] = saveMax(min_max_data.temp_max[i],quant_data.temp_quant[i]);
        }

        min_max_data.CDMS_temp_min = saveMin(min_max_data.CDMS_temp_min,quant_data.CDMS_temp_quant);
        min_max_data.CDMS_temp_max = saveMax(min_max_data.CDMS_temp_max,quant_data.CDMS_temp_quant);
    }
    firstCount=false;
}

void FCTN_CDMS_HK()
{

    int Iteration=0;

    SelectLinec0=0;
    SelectLinec1=0;
    SelectLinec2=0;
    SelectLinec3=0;

    for(Iteration=0; Iteration<16; Iteration++) {

        actual_data.temp_actual[Iteration]=TempInput.read();

        SelectLinec0=!(SelectLinec0);
        if(Iteration%2==1)
            SelectLinec1=!(SelectLinec1);
        if(Iteration%4==3)
            SelectLinec2=!(SelectLinec2);
        if(Iteration%8==7)
            SelectLinec3=!(SelectLinec3);
    }

    actual_data.CDMS_temp_actual=(-90.7*3.3*CDMS_temp_sensor.read())+190.1543;

    for(Iteration=0; Iteration<16; Iteration++) {

        if(Iteration<14) {

            actual_data.temp_actual[Iteration]=actual_data.temp_actual[Iteration]*3.3;
            int resistance;

            resistance=24000*actual_data.temp_actual[Iteration]/(3.3-actual_data.temp_actual[Iteration]);
            if(actual_data.temp_actual[Iteration]>1.47) {
                actual_data.temp_actual[Iteration]=3694/log(24.032242*resistance);
            } else {

                actual_data.temp_actual[Iteration]=3365.4/log(7.60573*resistance);
            }
        } else
            actual_data.temp_actual[Iteration]=(-90.7*3.3*actual_data.temp_actual[Iteration])+190.1543;
    }

    for(Iteration=0; Iteration<16; Iteration++) {

        if(Iteration<14) {

            quant_data.temp_quant[Iteration]=quantiz(tstart_thermistor,tstep_thermistor,actual_data.temp_actual[Iteration]);
        } else
            quant_data.temp_quant[Iteration]=quantiz(tstart,tstep,actual_data.temp_actual[Iteration]);
    }

    quant_data.CDMS_temp_quant=quantiz(tstart,tstep,actual_data.CDMS_temp_actual);

    minMaxHkData();
}

void FUNC_CDMS_GPIO_STATUS()       //Polls the status of Input GPIO PINS
{
    //V_A_PGOOD //TRZ EN
    GPIO_STATUS=(V_A_PGOOD)?(GPIO_STATUS)||((uint16_t)(0x1<<15)):(GPIO_STATUS)&(~((uint16_t)(0x1<<15)));
    //V_B_PGOOD_1 //3V3BPGOOD //$
    GPIO_STATUS=(V_B_PGOOD_1)?(GPIO_STATUS)||((uint16_t)(0x1<<14)):(GPIO_STATUS)&(~((uint16_t)(0x1<<14)));
    //V_B_PGOOD_2 //3V3BEN //$
    GPIO_STATUS=(V_B_PGOOD_2)?(GPIO_STATUS)||((uint16_t)(0x1<<13)):(GPIO_STATUS)&(~((uint16_t)(0x1<<13)));
    //V_C_PGOOD //3V3CPGOOD //$
    GPIO_STATUS=(V_C_PGOOD)?(GPIO_STATUS)||((uint16_t)(0x1<<12)):(GPIO_STATUS)&(~((uint16_t)(0x1<<12)));
    //COMRX_OC_FAULT //$
    GPIO_STATUS=(COMRX_OC_FAULT)?(GPIO_STATUS)||((uint16_t)(0x1<<11)):(GPIO_STATUS)&(~((uint16_t)(0x1<<11)));
    // COMTX_OC_FAULT //$
    GPIO_STATUS=(COMTX_OC_FAULT)?(GPIO_STATUS)||((uint16_t)(0x1<<10)):(GPIO_STATUS)&(~((uint16_t)(0x1<<10)));
    //BAE_OC_FAULT //$
    GPIO_STATUS=(BAE_OC_FAULT)?(GPIO_STATUS)||((uint16_t)(0x1<<9)):(GPIO_STATUS)&(~((uint16_t)(0x1<<9)));
    //PL_GPIO_1_STATUS //$
    GPIO_STATUS=(PL_GPIO_1_STATUS)?(GPIO_STATUS)||((uint16_t)(0x1<<8)):(GPIO_STATUS)&(~((uint16_t)(0x1<<8)));
    //PL_GPIO_2_STATUS //$
    GPIO_STATUS=(PL_GPIO_2_STATUS)?(GPIO_STATUS)||((uint16_t)(0x1<<7)):(GPIO_STATUS)&(~((uint16_t)(0x1<<7)));
    //PL_GPIO_3_STATUS //$
    GPIO_STATUS=(PL_GPIO_3_STATUS)?(GPIO_STATUS)||((uint16_t)(0x1<<6)):(GPIO_STATUS)&(~((uint16_t)(0x1<<6)));
    //PL_BEE_SW_OC_FAULT //to be verified
    GPIO_STATUS=(PL_BEE_SW_OC_FAULT)?(GPIO_STATUS)||((uint16_t)(0x1<<5)):(GPIO_STATUS)&(~((uint16_t)(0x1<<5)));
    //PL_EPS_LATCH_SW_OC_FAULT // to be verified
    GPIO_STATUS=(PL_EPS_LATCH_SW_OC_FAULT)?(GPIO_STATUS)||((uint16_t)(0x1<<4)):(GPIO_STATUS)&(~((uint16_t)(0x1<<4)));
    
}

void VERIFY_COMRX()
{
    //COMRX_OC_FAULT //$
    if(PIN68==0 && RSSI_volatge > 0.4) {
        COMRX_STATUS = COMRX_ALIVE;
    } else {
        RESET_COMRX();
        COMRX_RESET_COUNTER++;
        if(PIN68==0 && RSSI_volatge > 0.4)
            COMRX_STATUS = COMRX_ALIVE;
        else
            COMRX_STATUS = COMRX_DEAD;
    }
}

void VERIFY_RTC()
{

    if(RTC_STATUS == 0x00) {
        SPI_mutex.lock();
        gCS_RTC=1;
        gCS_RTC=0;
        spi.write(0x0F);
        if(spi.write(0x00) & 0x04 == 0x04) {
            
            RTC_STATUS = 0x00;
            RESET_RTC();
            RTC_FAULTCOUNT++;
        }
        gCS_RTC=1;
        SPI_mutex.unlock();
    }
}

void HANDLE_HW_FAULTS()
{
    HANDLE_HW_FAULT_SD();
    HANDLE_HW_FAULT_BAE();
    HANDLE_HW_FAULT_PL();
}

void HANDLE_HW_FAULT_SD()
{
    if(SD_STATUS != DEVICE_DISABLED) {
        if(SD_STATUS == DEVICE_OC_FAULT)
            SD_SW_EN_DS = 0; //powering on SD

        if(SD_OC_FAULT == 0) {
            SD_SW_EN_DS = 1; //switching off SD card

            SD_FAULTCOUNT++;
            SD_STATUS = (SD_FAULTCOUNT == 3) ? DEVICE_DISABLED :DEVICE_OC_FAULT;
        } else {
            SD_STATUS = DEVICE_POWERED;
            SD_FAULTCOUNT = 0;
        }
    }
}

void HANDLE_HW_FAULT_BAE()
{
    if(BAE_STATUS != DEVICE_DISABLED) {
        if(BAE_STATUS == DEVICE_OC_FAULT)
            BAE_SW_EN_DS = 0; //Power ON BAE

        if(BAE_OC_FAULT == 0) { // If OC Fault
            BAE_SW_EN_DS = 1; //Switch OFF BAE
            BAE_FAULTCOUNT++;
            BAE_STATUS = (BAE_FAULTCOUNT == 3)?DEVICE_DISABLED:DEVICE_OC_FAULT;
        } else {
            BAE_STATUS = DEVICE_POWERED;
            BAE_FAULTCOUNT = 0;
        }
    }
}

void HANDLE_HW_FAULT_PL()
{
    if(PL_STATUS != DEVICE_DISABLED) {
        if(PL_STATUS == DEVICE_OC_FAULT){
            PYLD_DFF_CLK = 0;
            PYLD_DFF = 1;           // Switching ON PL
            wait_us(1);
            PYLD_DFF_CLK = 1;
            wait_us(1);
            PYLD_DFF_CLK = 0;
            wait_us(1);         
        }
        if(PL_BEE_SW_OC_FAULT == 0) { // if OC Fault
            PYLD_DFF_CLK = 0;     
            PYLD_DFF = 0;             //Switching OFF PL
            wait_us(1);
            PYLD_DFF_CLK = 1;
            wait_us(1);
            PYLD_DFF_CLK = 0;
            wait_us(1);
            PL_FAULTCOUNT++;
            PL_STATUS = (PL_FAULTCOUNT == 3)?DEVICE_DISABLED:DEVICE_OC_FAULT;
        } else {
            if(PL_STATUS == DEVICE_OC_FAULT){
                PYLD_DFF_CLK = 0;     
                PYLD_DFF = 0;             //Switching OFF PL
                wait_us(1);
                PYLD_DFF_CLK = 1;
                wait_us(1);
                PYLD_DFF_CLK = 0;
                wait_us(1);
            }
            PL_STATUS = DEVICE_ENABLED;
            PL_FAULTCOUNT = 0;
        }
    }
}

void COLLECT_CDMS_RAM()
{
    /*--------------------Current FSC's---------------------*/
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+43] = FSC_LAST[5] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+47] = FSC_CURRENT[5] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+51] = FSC_LAST[4] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+55] = FSC_CURRENT[4] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+59] = FSC_LAST[3] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+63] = FSC_CURRENT[3] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+67] = FSC_LAST[2] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+71] = FSC_CURRENT[2] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+75] = FSC_LAST[1] >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+79] = FSC_CURRENT[1] >> (i*8);
    /*---------------------Latest Time----------------------*/
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+83] = TIME_LATEST_SPI_SPEED >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+87] = TIME_LATEST_SD_RD >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+91] = TIME_LATEST_SD_WR >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+95] = TIME_LATEST_I2C_SPEED >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+99] = TIME_LATEST_I2C_BAE >> (i*8);
    for(int i=0; i<4; i++)
        CDMS_HEALTH_DATA[i+103] = TIME_LATEST_RTC >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+107] = COMRX_RESET_COUNTER >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+107] = PL_RCV_SC_DATA_COUNTER >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+111] = PL_MAIN_COUNTER >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+113] = CDMS_HK_MAIN_COUNTER >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+115] = CDMS_I2C_ERR_BAE_COUNTER >> (i*8);
    for(int i=0; i<2; i++)
        CDMS_HEALTH_DATA[i+117] = CDMS_I2C_ERR_SPEED_COUNTER >> (i*8);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | CDMS_STANDBY_PL << 7;
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | ((CDMS_INIT_STATUS << 6) & 0x40);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | ((CDMS_HK_MAIN_STATUS << 5) & 0x20);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | ((CDMS_HK_STATUS << 3) & 0x18);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | ((COMRX_STATUS << 2) & 0x04);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] | ((CDMS_RTC_BL << 1) & 0x02);
    CDMS_HEALTH_DATA[120] = CDMS_HEALTH_DATA[120] & 0xFE;

    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | PL_RCV_SC_DATA_STATUS << 7;
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((COM_SESSION << 6) & 0x40);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((COM_RX << 5) & 0x20);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((RF_SW_STATUS << 4) & 0x10);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((COM_TX << 3) & 0x08);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((COM_TX_STATUS << 2) & 0x04);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | ((COM_MNG_TMTC << 1) & 0x02);
    CDMS_HEALTH_DATA[121] = CDMS_HEALTH_DATA[121] | (CDMS_STANDBY_HK & 0x01);

    CDMS_HEALTH_DATA[122] = CDMS_HEALTH_DATA[122] | PL_INIT_STATUS << 7;
    CDMS_HEALTH_DATA[122] = CDMS_HEALTH_DATA[122] | ((PL_MAIN_STATUS << 6) & 0x40);
    CDMS_HEALTH_DATA[122] = CDMS_HEALTH_DATA[122] | ((PL_LOW_POWER << 5) & 0x20);
    CDMS_HEALTH_DATA[122] = CDMS_HEALTH_DATA[122] | ((PL_STATE << 3) & 0x18);
    CDMS_HEALTH_DATA[122] = CDMS_HEALTH_DATA[122] | (PL_STATUS & 0x07);
}