#include "FreescaleIAP.h"

int strt_add = flash_size() - (2*SECTOR_SIZE);
uint32_t flasharray[5];    //256+(3*1024)
uint32_t INITIAL_FLASH[5];
/*corrected*/
int *nativeflash = (int*)strt_add;

void FLASH_INI()
{
    uint32_t read[5]; 
    for(int i=0;i<5;i++)
        {  
            read[i] = nativeflash[i];
        }
            
    if(read[0] == -1)
        for(int j=0;j<5;j++)
            {   
                FCTN_CDMS_WR_FLASH(j,INITIAL_FLASH[j]); 
            } 
    else
       {
        for(int j=0;j<5;j++)
            {   
                read[j] = nativeflash[j];
            }
            EPS_V_A_EN_STATUS = read[0] >> 31;
            BAE_SW_STATUS   = (read[0] << 1) >> 30; 
            CDMS_SD_SW_STATUS = (read[0] << 3) >> 30;
            PL_BEE_SW_STATUS = (read[0] << 5) >> 30;
            PL_EPS_LATCH_SW_EN = (read[0] << 7) >> 31;
            RTC_INIT_STATUS = (read[0] << 8) >> 30;
            CDMS_RTC_DISABLE = (read[0] << 10) >> 31;
            CDMS_RESET_COUNTER = read[0];
            TIME_LATEST_CDSMS_RESET = read[1];
            COM_TC_BYTES_LIMIT = read[2] >> 16;
            COM_RX_CURRENT_MAX = (read[2] << 16) >> 24;
            COM_RX_DISABLE_TIMEOUT = read[2];
            COM_PA_TMP_HIGH = read[3] >> 24;
            COM_PA_RECOVERY_TIMEOUT = (read[3] << 8) >> 24;
            COM_SESSION_TIMEOUT = (read[3] << 16) << 24;
            COM_RSSI_MIN = read[3];
            SD_LIB_BLK_CURRENT = read[4] >> 16;
        }
    
}

/*Writing to the Flash*/
void FCTN_CDMS_WR_FLASH(uint16_t j,uint32_t datablock)  //j-position to write address  ; fdata - flash data to be written
{
    for(int i=0;i<5;i++)
    {
        flasharray[i]=nativeflash[i];
    }
    flasharray[j]=datablock;
    erase_sector(strt_add);
    program_flash(strt_add, (char*)flasharray,32);
}
/*End*/
