
/*===================================================FMS Functions=================================================*/
//Run processes
void P_PL_INIT();
void P_PL_MAIN();
void P_COM_INIT();
void P_CDMS_HK_MAIN();
void P_PL_RCV_SC_DATA();
void P_CDMS_INIT_SD();

// Switch ON/OFF functions
void CDMS_SD_SW_ON();
void CDMS_SD_SW_OFF();
void CDMS_RTC_ON();
void CDMS_RTC_OFF();
void SW_ON_BAE();
void SW_OFF_BAE();
void SW_ON_PL_BEE();
void SW_OFF_PL_BEE();
void SW_ON_PL_EPS();
void SW_OFF_PL_EPS();
void SW_ON_V_A_EN();
void SW_OFF_V_A_EN();

// RST functions
void RST_SD();
void SW_RST_BAE();
void SW_RST_PL_BEE();
void RST_BAE();
void RST_PL_BEE();
void CDMS_RESET();
void SYS_PWR_RESET();  // Have to be decided with EPS team.
void EPS_V_A_EN();
void EPS_V_C_EN();

void RST_HK_COUNTER();
uint8_t CDMS_RD_SD_HK(uint8_t *);
void CDMS_RD_RTC(uint64_t *);
void CDMS_CALIB_RTC();
void TOTAL_RESET_WITH_CDMS();


void P_PL_INIT()
{
    
}

void P_PL_MAIN()
{
   FCTN_CDMS_PL_MAIN((void *)NULL);
}

void P_COM_INIT()
{
    P_COM_INIT;
}

void P_CDMS_HK_MAIN()
{
    FCTN_CDMS_HK_MAIN((void *)NULL);
}

void P_PL_RCV_SC_DATA()
{
    
}

void P_CDMS_INIT_SD()
{
    FCTN_CDMS_SD_INIT();
}

void CDMS_SD_SW_ON()
{
    SD_SW_EN_DS = 0;
}

void CDMS_SD_SW_OFF()
{
    SD_SW_EN_DS = 1;
}

void CDMS_RTC_ON()
{
    //FCTN_CDMS_INIT_RTC();
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x00);//disabling stop bit in the seconds register
    SPI_mutex.unlock();
}

void CDMS_RTC_OFF()
{
    SPI_mutex.lock();
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x80);//enabling stop bit in the seconds register
    SPI_mutex.unlock();
}

void SW_ON_BAE()
{
    BAE_SW_EN_DS = 0;
}

void SW_OFF_BAE()
{
    BAE_SW_EN_DS = 1;
}

void SW_ON_PL_BEE()
{
    PYLD_DFF_CLK = 0;\
    PYLD_DFF = 1;\
    wait_us(1);\
    PYLD_DFF_CLK = 1;\
    wait_us(1);\
    PYLD_DFF_CLK = 0;\
    wait_us(1);\
}

void SW_OFF_PL_BEE()
{
    PYLD_DFF_CLK = 0;
    PYLD_DFF = 0;
    wait_us(1);
    PYLD_DFF_CLK = 1;
    wait_us(1);
    PYLD_DFF_CLK = 0;
    wait_us(1);
}

void SW_ON_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;\
    PYLD_EPS_DFF_PWR = 1;\
    wait_us(1);\
    PYLD_EPS_DFF_PWR_CLK = 1;\
    wait_us(1);\
    PYLD_EPS_DFF_PWR_CLK = 0;\
    wait_us(1);\
}

void SW_OFF_PL_EPS()
{
    PYLD_EPS_DFF_PWR_CLK = 0;\
    PYLD_EPS_DFF_PWR = 0;\
    wait_us(1);\
    PYLD_EPS_DFF_PWR_CLK = 1;\
    wait_us(1);\
    PYLD_EPS_DFF_PWR_CLK = 0;\
    wait_us(1);\
}

void SW_ON_V_A_EN()
{
    V_A_EN = 1;
}

void SW_OFF_V_A_EN()
{
    V_A_EN = 0;
}

void RST_SD()
{
    SD_SW_EN_DS = 1;
    wait_ms(10);
    SD_SW_EN_DS = 0;
}

void SW_RST_BAE()
{
    BAE_SW_EN_DS = 1;
    wait_ms(10);
    BAE_SW_EN_DS = 0;
}

void SW_RST_PL_BEE()
{
    PYLD_DFF = 1;
    wait_ms(10);
    PYLD_DFF = 0;
}

void RST_BAE()
{
    RESET_TO_BAE = 1;
    wait_ms(10);
    RESET_TO_BAE = 0;
}

void RST_PL_BEE()
{
    RESET_TO_PYLD = 1;
    wait_ms(10);
    RESET_TO_PYLD = 0;
}

void CDMS_INTERNAL_RESET()
{
    NVIC_SystemReset();
}

void SYS_PWR_RESET()  // Have to be decided with EPS team.
{
    /*sys_pwr_rst = 0;
    wait_ms(10);
    sys_pwr_rst = 1;*/
}

void EPS_V_A_EN()     // This is a reset function
{
    V_A_EN = 0;
    wait_ms(10);
    V_A_EN = 1;
}

void EPS_V_C_EN()     // This is a reset function
{
    COM_RX_CNTRL = 0;
    wait_ms(10);
    COM_RX_CNTRL = 1;
}

void RST_HK_COUNTER()
{
    firstCount = true;
}

uint8_t CDMS_RD_SD_HK(uint8_t *sd_statusbits)
{
    uint8_t p;
    uint8_t ACK;
    if(SD_SW_EN_DS != DEVICE_POWERED)
    {
        ACK = 0x89;
        SD_RD_ERROR = 1;
        //Generate TM
    }
    else
    {
        p = disk_read_statusbits(sd_statusbits);
        if(p == 0)
            ACK = 0xA0;
        else
            ACK = 0x89;
    }
    return ACK;
}

void CDMS_RD_RTC(uint64_t *time)
{
    *time = FCTN_CDMS_RD_RTC();
}

void CDMS_CALIB_RTC()
{
    
}

void CDMS_RESET()
{
    NVIC_SystemReset();    
}

/*
//void CDMS_INTERNAL_RESET()
{
    
}
*/


/*===================================================MMS Functions=================================================*/

void WRITE_TO_FLASH(uint8_t *);

void WRITE_TO_FLASH(uint8_t *flash)
{
    uint32_t FLASH[5];
    FLASH[0] = ((uint32_t)flash[0] << 24) | ((uint32_t)flash[1] << 16) | ((uint32_t)flash[2] << 8) | ((uint32_t)flash[3]); 
    FLASH[1] = ((uint32_t)flash[4] << 24) | ((uint32_t)flash[5] << 16) | ((uint32_t)flash[6] << 8) | ((uint32_t)flash[7]);
    FLASH[2] = ((uint32_t)flash[8] << 24) | ((uint32_t)flash[9] << 16) | ((uint32_t)flash[10] << 8) | ((uint32_t)flash[11]);
    FLASH[3] = ((uint32_t)flash[12] << 24) | ((uint32_t)flash[13] << 16) | ((uint32_t)flash[14] << 8) | ((uint32_t)flash[15]);
    FLASH[4] = ((uint32_t)flash[16] << 24) | ((uint32_t)flash[17] << 16) | ((uint32_t)flash[18] << 8) | ((uint32_t)flash[19]);
    erase_sector(strt_add);
    program_flash(strt_add, (char*)FLASH,160);
}
