//without reset feature , with state checks.

#ifndef ADF_H    // To make sure you don't declare the function more than once by including the header multiple times.
#define ADF_H

InterruptIn IRQ(ADF_IRQ);
//Ticker ticker;
#include "OBSRS.h" 
bool loop_on;
bool ADF_off;
bool buffer_state;
bool finish_write_data;
uint8_t signal = 0x00;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xFB,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,/*PA Level Byte*/0x57/*PA Parameters*/,0x08/*GMSK_modulation*/,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x20,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0xE0,0x00,0x10,0x04,0x00,0x00,0x00,0x00,0x00};
bool data_irq_err=0;
bool data_err= false;
unsigned char temp_byte=0x00;
unsigned char data_err1[112];
unsigned char data_err_cnt=0;
unsigned int byte_count =0;
#define DATA_ERR_THRS 20
bool rolling_buffer_settings_error=true;
bool bbram_write_success=true;
int bbram_err_cnt=0;
int rbp_err_cnt=0;
bool reset_flag=false;
#define RBP_THRS 4
bool quit_configuration=false;
bool power_reset_flag=false;
unsigned int power_reset_count=0;
bool Configuration_done=false;
#define HW_THRS 2
bool hw_reset_flag = false;
uint8_t firstbyte;
uint8_t secondbyte;
unsigned char buffer_112[112];
//ADF temperature reading
#define temp_correction_value 0

#define TRANSMIT_LEN_1 0xFF
#define TRANSMIT_LEN_2 0xFF
/***/
Timer T;
 
#define START_ADDRESS 0x020;
#define MISO_PIN PTE3
/**************Defining Counter Limits**************/
#define THRS 20
#define STATE_ERR_THRS 20
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/
#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB
/**STATES**/
//=======================
#define PHY_OFF 0xB1
#define PHY_ON 0xB2
#define PHY_TX 0xB4
#define BUSY 0x00
//===================================================

#define POWER_RESET_THRS 2
#define HW_RESET_THRS 2

unsigned int Adf_data_counter=0;
unsigned char status =0;
unsigned int cmd_err_cnt=0;
unsigned int data_length;
unsigned int state_err_cnt=0;
unsigned int miso_err_cnt=0;
unsigned int hw_reset_err_cnt=0;
unsigned int counter =0;
bool temp_return = 0;
bool bcn_flag=0;
bool bbram_flag=0;
bool last_buffer =0;
bool stop_transmission=false;

#define reset_flags {\
finish_write_data = false;\
buffer_state = true;\
last_buffer = false;\
loop_on = true;\
ADF_off = false;\
buffer_state = true;\
loop_on = true;\
ADF_off = false;\
/*sent_tmfrom_SDcard = false;*/\
Adf_data_counter=0;\
status =0;\
cmd_err_cnt=0;\
data_length;\
state_err_cnt=0;\
miso_err_cnt=0;\
hw_reset_err_cnt=0;\
counter =0;\
bcn_flag=0;\
bbram_flag=0;\
stop_transmission=false;\
    }


int err_arr[64];
bool bbram_err=false;
int err_idx=-1;
int err[64];
#define bbram_check gCS_ADF=0;\
    for(int i=0;i<64;i++){\
        err_arr[i]=0;\
        }\
    for(int i=0;i<64;i++){\
        err[i]=0;\
        }\
    bbram_err=false;\
    gCS_ADF=0;\
    spi.write(0x39);\
    spi.write(0x00);\
    spi.write(0xFF);\
    for(int i=0;i<64;i++){\
        err_arr[i]=spi.write(0xFF);\
        if(err_arr[i]!=bbram_buffer[i+2]){\
            err[i]=1;\
            bbram_err=true;\
            }\
    }\
    gCS_ADF=1;\
    if(!bbram_err)\
        /*gPC.printf("BBRAM verified \r\n")*/;\
    else\
        gPC.printf("BBRAM error \r\n");\
 

bool tx_loop=1;

#define PRNT_ONCE {\
    gPC.printf("%d %d lol_ what?\r\n",segment_len,EOS_len);\
    }
 
#define bbram_write {\
    gCS_ADF=0;\
    spi.write(0xB0);\
    wait_us(300);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    for(int i=0;i<66;i++){\
        spi.write(bbram_buffer[i]);\
    }\
    gCS_ADF=1;\
}
//------------------------------------------------------------------------
// state checking functions
//bool assrt_phy_off( int, int, int);
//bool assrt_phy_on( int,int,int);
//bool assrt_phy_tx(int,int,int);

#define check_status {\
    unsigned char stat=0;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    stat = spi.write(0xFF);\
    gCS_ADF=1;\
    status = stat;\
}
/***********************/
/**********Restart ADF**************/

/**************************/

/*CMD_VAR*/
bool cmd_bit=true;
bool cmd_err_flag=false;
unsigned char command = 0x00;
void CMD(uint8_t command) {
    cmd_err_cnt=0;
    cmd_err_flag=false;
    while(cmd_err_cnt<3) {
        check_status;
        cmd_bit=status&0x20;
        if(cmd_bit) {
            gCS_ADF=0;
            spi.write(command);
            gCS_ADF=1;
            break;
        } else {
            wait_us(5);
            cmd_err_cnt++;
        }
    }
    if(cmd_err_cnt==3) {
        cmd_err_flag=true;
    }
}

// all three arguments are int
#define assrt_phy_off {\
    int state_err_cnt = 0;\
    CMD(CMD_PHY_OFF);\
    if(cmd_err_flag){\
        temp_return=1;\
        }\
    else{\
        for(int i = 0 ; i < 40 ;i++){\
            CMD(CMD_PHY_OFF);\
            check_status;\
            if(status == PHY_OFF){\
                temp_return = 0;\
            break;\
            }\
            else if(state_err_cnt>THRS){\
                temp_return = 1;\
            break;\
            }\
            else {\
                wait_ms(1);\
            }\
        }\
    }\
}

bool dummy_digitalOut_1=0;
#define power_reset{\
    dummy_digitalOut_1=0;\
    wait_ms(10);\
    dummy_digitalOut_1=1;\
    power_reset_flag=false;\
    power_reset_count++;\
    wait_ms(10);\
    }\

void get_temp_and_txcurr(){
/*ADF Temperature reading*/;
                gCS_ADF=0;
                spi.write(0x1B);
                spi.write(0x24);
                spi.write(0x10);
                gCS_ADF=1;
                gCS_ADF=0;
                spi.write(0x1B);
                spi.write(0x25);
                spi.write(0x02);
                gCS_ADF=1;
                gCS_ADF=0;
                spi.write(0x1B);
                spi.write(0x59);
                spi.write(0x08);
                gCS_ADF=1;

                gCS_ADF=0;
                spi.write(0x3B);
                spi.write(0x27);
                spi.write(0xFF);
                secondbyte = spi.write(0xFF);
                gCS_ADF=1;
                gCS_ADF=0;
                spi.write(0x3B);
                spi.write(0x28);
                spi.write(0xFF);
                firstbyte = spi.write(0xFF);
                gCS_ADF=1;
                gCS_ADF=0;
                spi.write(0x3B);
                spi.write(0x27);
                spi.write(0xFF);
                secondbyte = spi.write(0xFF);
                gCS_ADF=1;
                
                COM_ADF_TMP = firstbyte & 0x03;
                COM_ADF_TMP |= secondbyte & 0xfc;
                COM_ADF_TMP = 0.9474*(COM_ADF_TMP - 28) +28.2;
                
                gPC.printf("\n\rCOM_ADF_TMP : %d \n",COM_ADF_TMP);
                /*uint8_t txcurr = (3.3*COM_TX_OC_FAULT)/(0.05)*100;*///    ID_current
                
                
                
    }
    
void get_com_oc_sw_status()
{
    COM_OC_SET = 1;
    if (COM_TX_OC_FAULT){\
         com_oc_sw_status = 0x1;\
    }\
    else{\
        com_oc_sw_status = 0;\
    }\
} 

bool hardware_reset(int bcn_call)
{
     if(hw_reset_err_cnt>HW_RESET_THRS){
        power_reset_flag=true;
        power_reset;
        return 0;
    }
    
    for(int i= 0; i < 2 ; i++) {
        gCS_ADF=0;
        spi.write(CMD_HW_RESET);
        gCS_ADF=1;
        wait_ms(2);// Typically 1 ms
        int count=0;
        temp_return = 0;
        while(count<10 && miso_err_cnt<10) {
            if(MISO_PIN) {
//                assrt_phy_off;
/*asseert_phyoff Starts**/
{\
    int state_err_cnt = 0;\
    CMD(CMD_PHY_OFF);\
    if(cmd_err_flag){\
        temp_return=1;\
        }\
    else{\
        for(int i = 0 ; i < 40 ;i++){\
            CMD(CMD_PHY_OFF);\
            check_status;\
            if(status == PHY_OFF){\
                temp_return = 0;\
            break;\
            }\
            else if(state_err_cnt>THRS){\
                temp_return = 1;\
            break;\
            }\
            else {\
                wait_ms(1);\
            }\
        }\
    }\
}\
/*Assert_phy_off_ends*/





                if(!temp_return){
                    return 0;
                }
                count++;
            } else {
                wait_us(50);
                miso_err_cnt++;
            }
        }
    }
    return 1;
}
//for reseting the transmission call assert function after b5 and b1. after b1 assert_phi_on and after b5 assert_phi_tx.
//----------------------------------------------------------------------------
unsigned char temp;
bool reg_err;
int reg_err_cnt;
#define REG_ERR_THRS 5
#define reg_check(addr1,addr2,reg_val){\
 gCS_ADF=0;\
        reg_err=false;\
        spi.write(addr1);\
        spi.write(addr2);\
        spi.write(0xFF);\
        temp = spi.write(0xFF);\
        if(temp==reg_val)\
            reg_err = false;\
        else\
            reg_err=true;\
    gCS_ADF=1;\
}

#define initiate {\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    reg_err=true;\
    for(reg_err_cnt=0;reg_err_cnt<REG_ERR_THRS && reg_err;reg_err_cnt++){\
        gCS_ADF=0;\
        spi.write(0x08);\
        spi.write(0x14);\
        spi.write(TRANSMIT_LEN_1);\
        gCS_ADF=1;\
        reg_check(0x28,0x14,TRANSMIT_LEN_1);\
    }\
    if(reg_err)\
        gPC.printf("Reg_err_ignored %x \r\n",(int)temp);\
    else\
        /*gPC.printf("reg written successful %x \r\n",(int)temp)*/;\
    reg_err=true;\
    for(reg_err_cnt=0;reg_err_cnt<REG_ERR_THRS && reg_err;reg_err_cnt++){\
        gCS_ADF=0;\
        spi.write(0x08);\
        spi.write(0x15);\
        spi.write(TRANSMIT_LEN_2);\
        gCS_ADF=1;\
        reg_check(0x28,0x15,TRANSMIT_LEN_2);\
    }\
    if(reg_err)\
        gPC.printf("Reg_err_ignored %x \r\n",(int)temp);\
    else\
        gPC.printf("reg written successful %x \r\n",(int)temp);\
}

#define write_data {\
    counter++;\
    if(counter==584){\
        finish_write_data=true;\
        restart_adf_flag=true;\
        counter=0;\
        }\
    gCS_ADF=0;\
        spi.write(0x0B);\
        spi.write(0x36);\
        spi.write(0xFF);\
    gCS_ADF=1;\
    data_err_cnt=0;\
    data_err=true;\
    while(data_err && (data_err_cnt<DATA_ERR_THRS)){\
        gCS_ADF=0;\
        if(buffer_state){\
            spi.write(0x18);\
            spi.write(0x20);\
            for(unsigned char i=0; i<112;i++){\
                    spi.write(buffer_112[i]);\
                    /*gPC.printf("0x%X,",spi.write(buffer_112[i]));*/\
            }\
        }\
        else{\
            spi.write(0x18);\
            spi.write(0x90);\
            for(unsigned char i=0; i<112;i++){\
                    spi.write(buffer_112[i]);\
                /*gPC.printf("0x%X,",spi.write(buffer_112[i]));*/\
            }\
        }\
        gCS_ADF=1;\
        wait_us(5);\
        data_err=false;\
        gCS_ADF=0;\
        spi.write(0x38);\
        if(buffer_state){\
            spi.write(0x20);\
            }\
        else{\
            spi.write(0x90);\
            }\
        spi.write(0xFF);\
        for(unsigned char i=0; i<112;i++){\
            temp_byte=spi.write(0xFF);\
            if(buffer_112[i]!=temp_byte){\
                data_err1[i]=1;\
                data_err=true;\
                }\
        }\
    gCS_ADF=1;\
    /*SPI_mutex.unlock();*/\
    if(data_err==false){\
    buffer_state = !buffer_state;\
    }\
    data_err_cnt++;\
    if(last_buffer){\
        finish_write_data = true;\
           /*gPC.puts("adf_off\r\n");*/\
        }\
    }\
}

#define check {\
    check_status;\
    /*gPC.printf("I 0x%X\r\n",(int)status);*/\
    if(IRQ){\
        get_com_oc_sw_status();\
        /*gPC.printf("det\r\n");*/\
        if(!ADF_off) {\
            if(finish_write_data || restart_adf_flag) {\
                write_data;\
                ADF_off=true;\
                T.stop();\
                T.reset();\
                T.start();\
                /*ADF Temperature reading*/;\
                get_temp_and_txcurr();\
            } else {\
                T.stop();\
                T.reset();\
                T.start();\
                write_data;\
                if(sent_tmfrom_SDcard)\
                send_tm_from_SD_card_fun(buffer_112,last_buffer);\
                else snd_tm.transmit_data(buffer_112,&last_buffer);\
            }\
        } else {\
            wait_ms(20);\
            gCS_ADF=0;\
            spi.write(0xB1);\
            gCS_ADF=1;\
            gPC.puts("transmission done\r\n");\
            /*gPC.printf("Time taken by last write_data %f msecs\n", T.read_ms())*/;\
            T.stop();\
            T.reset();\
            loop_on=false;\
            if(restart_adf_flag)\
            {\
                restart_adf_flag=false;\
                ADF_off=false;\
                send_data;\
                loop_on=true;\
                CMD(CMD_PHY_TX);\
                wait_us(2000);\
                }\
        }\
    }\
    else{\
        if(T.read_us()>98000){\
                data_irq_err=true;\
                CMD(CMD_PHY_ON);\
                gPC.printf("Data_error_detected");\
                T.stop();\
                T.reset();\
                }\        
        }\
}

#define send_data {\
    gCS_ADF=0;\
    spi.write(0xBB);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun(buffer_112,last_buffer);\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun(buffer_112,last_buffer);\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun(buffer_112,last_buffer);\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    gCS_ADF=0;\
    spi.write(0xB1);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xB5);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
}
  
#define initial_adf_check {\
    bool Configuration_Done=false;\
    quit_configuration=false;\
    bool reset_flag1 = 0;\
    bool flag = false;\
    while((hw_reset_err_cnt<HW_THRS)&&(quit_configuration==false)){\
        while((bbram_err_cnt<2)&&(quit_configuration==false)){\
            /*assrt_phy_off;*/\
            /*Assrt_phy_off Begin*/\
            {\
    int state_err_cnt = 0;\
    CMD(CMD_PHY_OFF);\
    if(cmd_err_flag){\
        temp_return=1;\
        }\
    else{\
        for(int i = 0 ; i < 40 ;i++){\
            CMD(CMD_PHY_OFF);\
            check_status;\
            if(status == PHY_OFF){\
                temp_return = 0;\
            break;\
            }\
            else if(state_err_cnt>THRS){\
                temp_return = 1;\
            break;\
            }\
            else {\
                wait_ms(1);\
            }\
        }\
    }\
}\
            /*Assrt_phy_off end*/\
            reset_flag1=temp_return;\
            if(!reset_flag1){\
                bbram_write;\
                while((rbp_err_cnt<RBP_THRS)&&(quit_configuration==false)){\
                    bbram_check;\
                    if(bbram_err==0){\
                        bbram_write_success=true;\
                        bbram_err_cnt=0;\
                        initiate;\
                        if(reg_err){\
                            rbp_err_cnt++;\
                            }\
                        else{\
                            rbp_err_cnt=0;\
                            /*gPC.printf("NO Reg err\r\n")*/;\
                            CMD(CMD_CONFIG_DEV);\
                            if(cmd_err_flag){\
                                reset_flag=1;\
                                gPC.printf("CMD ERR\r\n");\
                            }\
                            else{\
                                reset_flag=0;\
                                /*gPC.printf("NO CMD ERR CONFIG_DONE\r\n")*/;\
                                quit_configuration=true;\
                            }\
                        }\
                    }\
                    else{\
                        bbram_write_success=false;\
                        bbram_err_cnt++;\
                        break;\
                    }\
                }\
            }\
            else{\
                break;\
            }\
        }\
        if(reset_flag1){\
            hardware_reset(0);\
            hw_reset_err_cnt++;\
            gPC.puts("Resetting hardware\r\n");\
        }\
    }\
    if(hw_reset_err_cnt==HW_THRS){\
        power_reset_flag=1;\
        power_reset_count++;\
        }\
    else{\
        Configuration_Done=true;\
        gPC.printf("Configuration_Done\n");\
        }\
}

#define configure_adf {\
    reset_flags;\
    initial_adf_check;\
    gPC.puts("Config_part done\r\n");\
}
 
void transmit_adf(){
while(power_reset_count<POWER_RESET_THRS){ 
    restart_adf_flag=false;
    bool tx_err=false;
    configure_adf;
    send_data;
    /*PA MCR level*/;
        gCS_ADF=0;
        spi.write(0x1B);
        spi.write(0x07);
        spi.write(0x35);
        gCS_ADF=1;
    CMD(CMD_PHY_TX);
    wait_us(2000);
    T.start();
    while(loop_on){
        wait_us(20);
        check;
        if(data_irq_err||tx_err){
            hw_reset_err_cnt++;
            hw_reset_flag=true;
        break;
        }
    }
    if(hw_reset_flag==true){
        hardware_reset(0);
        }
    else{
        break;
    }
    gPC.puts("after while looprn");
}
}

#endif