int pl_next_index=-1;   
uint8_t pl_main_flag=0;
uint8_t PL_PREV_STATE=0x00;
uint8_t POWER_LEVEL = 3;                                //Would be present in HK data extracted 
uint32_t pl_block[192]={0};
uint32_t pl_time;
uint32_t TIME_LATEST_PL=0;
uint8_t i;
//extern uint8_t PL_BEE_SW_STATUS=0;

//Serial pc(USBTX,USBRX);

#define PL_MAIN_STATUS              0x01
#define PL_LOW_POWER                0x02
#define STATE_OFF                   0x00
#define STATE_STANDBY               0x04
#define STATE_HIBERNATE             0x08
#define STATE_SCIENCE               0x0C            //also used as mask for PL_STATE
#define PL_OFF                      0x00
#define PL_STANDBY                  0x10
#define PL_HIBERNATE                0x20
#define PL_SCIENCE                  0x30
#define PL_SUCCESS_I2C              0x40
#define PL_ERR_I2C                  0x50
#define PL_INVALID_STATE            0x60
#define PL_DISABLED                 0x70            //also used as mask for PL_STATUS
#define EXECUTED                    0x00000001
#define RETRY                       0x00000002
#define UNEXECUTED                  0x00000003      //also used as mask for EXEC_STATUS


Base_tm* FCTN_CDMS_RLY_TMTC(Base_tc *tc_ptr);

// waiting 1us for setup time,hold time and propagation delay
#define SET_PL_BEE_OFF {\
    PYLD_DFF_CLK = 0;\
    PYLD_DFF = 0;\
    wait_us(1);\
    PYLD_DFF_CLK = 1;\
    wait_us(1);\
    PYLD_DFF_CLK = 0;\
    wait_us(1);\
}
#define SET_PL_BEE_ON {\
    PYLD_DFF_CLK = 0;\
    PYLD_DFF = 1;\
    wait_us(1);\
    PYLD_DFF_CLK = 1;\
    wait_us(1);\
    PYLD_DFF_CLK = 0;\
    wait_us(1);\
}

//TC_string[0] should not be 0x00

#define SET_PL_BEE_STANDBY(tm_ptr_standby) {\
    Base_tc *pl_tc_standby = new Short_tc;\
    pl_tc_standby->next_TC = NULL;\
    PUTshort_or_long(pl_tc_standby,0);\
    PUTcrc_pass(pl_tc_standby,0x1);\
    PUTexec_status(pl_tc_standby,0);\
    pl_tc_standby->TC_string[0] = 0x01;\
    pl_tc_standby->TC_string[1] = 0xE1;\
    pl_tc_standby->TC_string[2] = 0x81;\
    pl_tc_standby->TC_string[3] = 0x02;\
    pl_tc_standby->TC_string[4] = 0;\
    pl_tc_standby->TC_string[5] = 0;\
    pl_tc_standby->TC_string[6] = 0;\
    pl_tc_standby->TC_string[7] = 0;\
    pl_tc_standby->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(pl_tc_standby->TC_string, 9);\
    pl_tc_standby->TC_string[9]  = (uint8_t)(crc16 & 0xFF00)>>8;\
    pl_tc_standby->TC_string[10] = (uint8_t)(crc16 & 0x00FF);\
    tm_ptr_standby =  FCTN_CDMS_RLY_TMTC(pl_tc_standby);\
    VERIFY_TM(tm_ptr_standby);\
    delete pl_tc_standby;\
    Base_tm *temp;\
    temp = tm_ptr_standby;\
    while(tm_ptr_standby!=NULL)\
    {\
        temp = temp->next_TM;\
        delete tm_ptr_standby;\
        tm_ptr_standby = temp;\
    }\
}

//TC_string[0] should not be 0x00

#define SET_PL_BEE_HIBERNATE(tm_ptr_hibernate) {\
    Base_tc *pl_tc_hibernate = new Short_tc;\
    pl_tc_hibernate->next_TC = NULL;\
    PUTshort_or_long(pl_tc_hibernate,0);\
    PUTcrc_pass(pl_tc_hibernate,0x1);\
    PUTexec_status(pl_tc_hibernate,0);\
    pl_tc_hibernate->TC_string[0] = 0x01;\
    pl_tc_hibernate->TC_string[1] = 0xE1;\
    pl_tc_hibernate->TC_string[2] = 0x81;\
    pl_tc_hibernate->TC_string[3] = 0x03;\
    pl_tc_hibernate->TC_string[4] = 0;\
    pl_tc_hibernate->TC_string[5] = 0;\
    pl_tc_hibernate->TC_string[6] = 0;\
    pl_tc_hibernate->TC_string[7] = 0;\
    pl_tc_hibernate->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(pl_tc_hibernate->TC_string, 9);\
    pl_tc_hibernate->TC_string[9]  = (uint8_t)(crc16 & 0xFF00)>>8;\
    pl_tc_hibernate->TC_string[10] = (uint8_t)(crc16 & 0x00FF);\
    tm_ptr_hibernate =  FCTN_CDMS_RLY_TMTC(pl_tc_hibernate);\
    VERIFY_TM(tm_ptr_hibernate);\
    delete pl_tc_hibernate;\
    Base_tm *temp;\
    temp = tm_ptr_hibernate;\
    while(tm_ptr_hibernate!=NULL)\
    {\
        temp = temp->next_TM;\
        delete tm_ptr_hibernate;\
        tm_ptr_hibernate = temp;\
    }\
}

//TC_string[0] should not be 0x00
/*
PUTshort_or_long(pl_tc_science,0);\
    PUTcrc_pass(pl_tc_science,0x1);\
    PUTexec_status(pl_tc_science,0);\*/
    
#define SET_PL_BEE_SCIENCE(tm_ptr_science) {\
    Base_tc *pl_tc_science = new Short_tc;\
    pl_tc_science->next_TC = NULL;\
    pl_tc_science->TC_string[0] = 0x01;\
    pl_tc_science->TC_string[1] = 0xE1;\
    pl_tc_science->TC_string[2] = 0x81;\
    pl_tc_science->TC_string[3] = 0x04;\
    pl_tc_science->TC_string[4] = 0;\
    pl_tc_science->TC_string[5] = 0;\
    pl_tc_science->TC_string[6] = 0;\
    pl_tc_science->TC_string[7] = 0;\
    pl_tc_science->TC_string[8] = 0;\
    uint16_t crc16 = crc16_gen(pl_tc_science->TC_string, 9);\
    pl_tc_science->TC_string[9]  = (uint8_t)(crc16 & 0xFF00)>>8;\
    pl_tc_science->TC_string[10] = (uint8_t)(crc16 & 0x00FF);\
    tm_ptr_science =  FCTN_CDMS_RLY_TMTC(pl_tc_science);\
    VERIFY_TM(tm_ptr_science);\
    delete pl_tc_science;\
    Base_tm *temp;\
    temp = tm_ptr_science;\
    while(tm_ptr_science!=NULL)\
    {\
        temp = temp->next_TM;\
        delete tm_ptr_science;\
        tm_ptr_science = temp;\
    }\
}
void print_processed_block(uint8_t index)
{
    gPC.printf("\n\n\rBlock after processing:");
    gPC.printf("\n\rTime of block:");
    gPC.printf("\n\rYear :%d",((((pl_block[index]&0xFFFFFFF0)>>4) & 0x0C000000)>>26)+2016);
    gPC.printf("\tMonth  :%d",((((pl_block[index]&0xFFFFFFF0)>>4) & 0x03C00000)>>22));
    gPC.printf("\tDay    :%d",((((pl_block[index]&0xFFFFFFF0)>>4) & 0x003E0000)>>17));
    gPC.printf("\n\rHours  :%d",((((pl_block[index]&0xFFFFFFF0)>>4) & 0x0001F000)>>12));
    gPC.printf("\tMin    :%d",((((pl_block[index]&0xFFFFFFF0)>>4) & 0x00000FC0)>>6));
    gPC.printf("\tSec    :%d",(((pl_block[index]&0xFFFFFFF0)>>4) & 0x0000003F));
    gPC.printf("\n\rSID    :%d",(pl_block[index] & 0x0000000C)>>2);
    gPC.printf("\tExecution Status :%d",pl_block[index] & UNEXECUTED);
}
void print_exit(uint8_t* temp)
{    
    uint8_t temp2[3];
    temp2[0] = (pl_main_flag&STATE_SCIENCE)>>2;
    temp2[1] = (pl_main_flag&PL_DISABLED)>>4;
    temp2[2] = (PL_PREV_STATE & STATE_SCIENCE)>>2;
    gPC.printf("\n\rAt exit");
    char state[][17] = {"STATE_OFF","STATE_STANDBY","STATE_HIBERNATE","STATE_SCIENCE"};
    char status[][17] = {"PL_OFF","PL_STANDBY","PL_HIBERNATE","PL_SCIENCE","PL_SUCCESS_I2C","PL_ERR_I2C","PL_INVALID_STATE","PL_DISABLED"};
    //gPC.printf("\n\rPL_state:%s -> %s",state[(uint8_t)temp[0]],state[(uint8_t)temp2[0]]);
    //gPC.printf("\n\rPL_status:%s -> %s",status[(uint8_t)temp[1]],status[(uint8_t)temp2[1]]);
    //gPC.printf("\n\rPL_PREV_state:%s -> %s",state[(uint8_t)temp[2]],state[(uint8_t)temp2[2]]);
}
void VERIFY_TM(Base_tm *tm_ptr)
{
    uint8_t temp = tm_ptr->TM_string[2];            //Obatining ACK_CODE
    if(GETshort_or_long_tm(tm_ptr)==1)              //short TM
    {
        gPC.printf("\n\rSHORT TM received");
        uint16_t crc16 = crc16_gen(tm_ptr->TM_string, 11);        
        if(tm_ptr->TM_string[12]==((uint8_t)(crc16 & 0x00FF)) && tm_ptr->TM_string[11]==((uint8_t)((crc16 & 0xFF00)>>8)))        
        {            
            if(temp!=0x00 && temp!=0x01 && temp!=0x02 && temp!=0x03 && temp!=0x84 && temp!=0x85)
            {
                gPC.printf("\n\rTime_Latest_PL Updated");
                TIME_LATEST_PL = pl_time;                  //update latest time when I2C communication was successful
            }
            if(temp==0xA0 || temp==0xC0)
            {
                gPC.printf("\n\rACK_CODE Success");
                if(temp==0xA0)
                    gPC.printf("\n\rACK_CODE = 0x%02X",temp);
                else
                    gPC.printf("\n\rACK_CODE = 0x%02X",temp);
                pl_main_flag  = pl_main_flag & (~PL_DISABLED);
                pl_main_flag |= PL_SUCCESS_I2C;
                PL_STATUS = 0x04;
                pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
                pl_block[pl_next_index-1] |= EXECUTED;
            }
            else
            {
                gPC.printf("\n\rACK_CODE failure (0x%02X)",temp);
                //gPC.printf("\n\rACK_CODE = 0x%02X",temp);
                pl_main_flag  = pl_main_flag & (~PL_DISABLED);
                pl_main_flag |= PL_ERR_I2C;
                PL_STATUS = 0x05;
                pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
                pl_block[pl_next_index-1] |= RETRY;   
            }
        }
        else
        {
            gPC.printf("\n\rShort_TM CRC failed");
            pl_main_flag  = pl_main_flag & (~PL_DISABLED);
            pl_main_flag |= PL_ERR_I2C;
            PL_STATUS = 0x05;
            pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
            pl_block[pl_next_index-1] |= RETRY;
        }
    }
    else if(GETshort_or_long_tm(tm_ptr)==0)                  //LONG TM
    {
        gPC.printf("\n\rLONG TM received");
        uint16_t crc16 = crc16_gen(tm_ptr->TM_string,132);        
        if(tm_ptr->TM_string[133]==((uint8_t)(crc16 & 0x00FF)) && tm_ptr->TM_string[132]==((uint8_t)((crc16 & 0xFF00)>>8)))        
        {
            if(temp!=0x00 && temp!=0x01 && temp!=0x02 && temp!=0x03 && temp!=0x84 && temp!=0x85)
            {
                gPC.printf("\n\rTime_Latest_PL Updated");
                TIME_LATEST_PL = pl_time;                  //update latest time when I2C communication was successful
            }
            if(temp==0xA0 || temp==0xC0)
            {
                gPC.printf("\n\rACK_CODE Success");
                if(temp==0xA0)
                    gPC.printf("\n\rACK_CODE = 0x%02X",temp);
                else
                    gPC.printf("\n\rACK_CODE = 0x%02X",temp);
                pl_main_flag  = pl_main_flag & (~PL_DISABLED);
                pl_main_flag |= PL_SUCCESS_I2C;
                PL_STATUS = 0x04;
                pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
                pl_block[pl_next_index-1] |= EXECUTED;
            }
            else
            {
                gPC.printf("\n\rACK_CODE failure (0x%02X)",temp);
                pl_main_flag  = pl_main_flag & (~PL_DISABLED);
                pl_main_flag |= PL_ERR_I2C;
                PL_STATUS = 0x05;
                pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
                pl_block[pl_next_index-1] |= RETRY;   
            }   
        }
        else
        {
            gPC.printf("\n\rLong_TM CRC failed");
            pl_main_flag  = pl_main_flag & (~PL_DISABLED);
            pl_main_flag |= PL_ERR_I2C;
            PL_STATUS = 0x05;     
            pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
            pl_block[pl_next_index-1] |= RETRY;   
        }
    }    
}
void test1(uint8_t t)
{
    //Output should be PL_STATUS = PL_DISABLED
    if(t!=0)
    {
        gPC.printf("\n\rTesting OC protection");
        PL_STATUS = 2;   //OC protection
    }
}
void test2(uint8_t t)
{
    //output should be same as test1()
    if(t!=0)    
    {
        gPC.printf("\n\rTesting Deviced Disabled case");
        PL_STATUS = 3;   //Device DISABLED 
    }
}
void test3(uint8_t t)
{
    if(t!=0)
    {
        gPC.printf("\n\rTesting RTC failed case");
        pl_time = 0;            //RTC failed
    }
}
/*void test4(uint8_t t)
{
    if(t!=0)
    {
        gPC.printf("\n\rTesting No future blocks available");
        schedule1[0] = {0,0,0,0,0,0,0,0};
    }
}*/
void FCTN_CDMS_PL_MAIN(void const *args)
{
    if(EN_PL == 0x00)
    return;
    uint8_t temp[3];
    pl_main_flag|=PL_MAIN_STATUS;                       //Setting PL_MAIN_STATUS
    PL_MAIN_status = 1;
    PL_MAIN_COUNTER++;                                  
    pl_main_flag&=~(PL_LOW_POWER);                      //Clearing PL_LOW_POWER
    PL_LOW_power = 0;
    temp[0] = (pl_main_flag&STATE_SCIENCE)>>2;
    temp[1] = (pl_main_flag&PL_DISABLED)>>4;
    temp[2] = (PL_PREV_STATE & STATE_SCIENCE)>>2;
    //test2(1);

    if(PL_STATUS==2 || PL_STATUS==3)
    {
        gPC.printf("\n\rDevice Disabled or OC Fault");
        pl_main_flag  = pl_main_flag & (~PL_DISABLED);
        pl_main_flag |= PL_DISABLED;                        //setting PL_STATUS as PL_DISABLED
        PL_STATUS = 0x07;
        pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);    //Clearing pl_main status
        PL_MAIN_status = 0;
        print_exit(temp);
        return;
    }
    PL_PREV_STATE = (pl_main_flag & STATE_SCIENCE);         //saving current pl_state
    uint64_t temp_time;
    temp_time=FCTN_CDMS_RD_RTC();
    pl_time = (uint32_t)((temp_time>>7) & 0x000000000FFFFFFF);

    //call test3() here
    //test3(1);

    //gPC.printf("\n\rprev_state    :%d",(PL_PREV_STATE)>>4);
    /*gPC.printf("\n\n\rtTime_RTC:");
    gPC.printf("\n\rYear :%d\t",((pl_time & 0x0C000000)>>26)+2016);
    gPC.printf("Month :%d\t",((pl_time & 0x03C00000)>>22));
    gPC.printf("Day :%d",((pl_time & 0x003E0000)>>17));
    gPC.printf("\n\rHours :%d",((pl_time & 0x0001F000)>>12));
    gPC.printf("\tMin :%d",((pl_time & 0x00000FC0)>>6));
    gPC.printf("\t\tSec :%d",(pl_time & 0x0000003F));*/
    if(pl_time!=0)                             //RTC read successful 
    {
        // run the loop until end of schedule is reached or month and day are both zeros or future block is found
        gPC.printf("\n\rRTC read success");
        for(i=0;(i<192)&&(((uint16_t)((pl_block[i] & 0x3FE00000)>>21))!=0);i++)     
        {   
            if(((pl_block[i]>>4) & 0x0FFFFFFF)>pl_time)     //Checking for future blocks       
            {
                pl_next_index=i;
                gPC.printf("\n\rFuture block found at index = %d",pl_next_index);
                break;
            }
        }
    }
    if((pl_next_index==-1) || pl_time==0)           //RTC read failed or Future block not found
    {       
        if(PL_PREV_STATE==STATE_SCIENCE)
        {
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= STATE_HIBERNATE;
            PL_STATE = 0x02;
        } 
        else
        {                        
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= PL_PREV_STATE;
        }        
        if(pl_time==0)
        {
            gPC.printf("\n\rRTC read failed");
        }
        if(pl_next_index==-1)
        {
            //gPC.printf("\n\rFuture block not found");
            gPC.printf("\n\rpl_next_index = %d",pl_next_index);
        }
        //gPC.printf("\n\rNew pl_state  = %d",(pl_main_flag&(~STATE_SCIENCE))>>2);
    }           
    
    //Processing the PL schedule
    if(((pl_block[pl_next_index-1] & UNEXECUTED)==3)||((pl_block[pl_next_index-1] & UNEXECUTED)==2))
    {        
        if(((pl_block[pl_next_index-1] & UNEXECUTED)==3))
            gPC.printf("\n\rElapsed blocked not executed");
        else
            gPC.printf("\n\rElapsed block marked for retry");

        gPC.printf("\n\r Retrieving pl_state from schedule");
        if((pl_block[pl_next_index-1] & 0x0000000C)==0)                
        {            
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= STATE_OFF;
            PL_STATE = 0x00;
        }
        if((pl_block[pl_next_index-1] & 0x0000000C)==4)
        {
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= STATE_STANDBY;
            PL_STATE = 0x01;
        }
        if((pl_block[pl_next_index-1] & 0x0000000C)==8)
        {
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= STATE_HIBERNATE;
            PL_STATE = 0x02;
        }
        if((pl_block[pl_next_index-1] & 0x0000000C)==12)
        {
            pl_main_flag  = pl_main_flag & (~STATE_SCIENCE);
            pl_main_flag |= STATE_SCIENCE;
            PL_STATE = 0x03;
        }
    }
    else if((pl_block[pl_next_index-1] & UNEXECUTED)==1)
    {
        gPC.printf("\n\rElapsed block is executed");
        pl_main_flag = pl_main_flag & (~PL_MAIN_STATUS);                  //Clearing pl_main status
        PL_MAIN_status = 0;
        print_exit(temp);
        return;   
    }      
    else if((pl_block[pl_next_index-1] & UNEXECUTED)==0)  
    {
        gPC.printf("\n\rEmpty Schedule Block");        
        pl_main_flag = pl_main_flag & (~PL_MAIN_STATUS);                  //Clearing pl_main status
        PL_MAIN_status = 0;
        print_exit(temp);
        return;
    }
    switch(pl_main_flag & STATE_SCIENCE)                                  //Checking PL_STATE
    {
        case STATE_OFF: 
        {
            gPC.printf("\n\rEntered PL_OFF case");
            if(PL_STATUS!=0) 
            {
                gPC.printf("\n\rCommanding PL_BEE to go to Standby State");
                Base_tm *tm_ptr_standby;
                SET_PL_BEE_STANDBY(tm_ptr_standby);                             //No ack needed now
                gPC.printf("\n\rPowering OFF PL_BEE");
                SET_PL_BEE_OFF;
                PL_STATUS=0;    
            }           
            pl_main_flag  = pl_main_flag & (~PL_DISABLED);
            pl_main_flag |= PL_OFF;
            PL_STATUS = 0x00;
            pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
            pl_block[pl_next_index-1] |= EXECUTED;                              
            pl_main_flag = pl_main_flag & (~PL_MAIN_STATUS);                    //Clearing PL_MAIN_STATUS
            PL_MAIN_status = 0;
            print_processed_block(pl_next_index-1);
            print_exit(temp);
            return;
        }
        case STATE_STANDBY: 
        {            
            gPC.printf("\n\rEntered PL_STANDBY case");
            if(PL_STATUS==0) 
            {
                gPC.printf("\n\rPowering on PL_BEE");
                SET_PL_BEE_ON;
                PL_STATUS=1;
            }
            gPC.printf("\n\rCommanding PL_BEE to go to Standby State");  
            Base_tm *tm_ptr_standby;
            SET_PL_BEE_STANDBY(tm_ptr_standby);
            if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
            {
                pl_main_flag = pl_main_flag & (~PL_DISABLED);
                pl_main_flag |= PL_STANDBY; 
                PL_STATUS = 0x01;
            }        
            pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS 
            PL_MAIN_status = 0;
            print_processed_block(pl_next_index-1);
            print_exit(temp);
            return;                                                   
                                                                            //////DELETE THE TM AND TC LATER
        }
        case STATE_HIBERNATE: 
        {
            gPC.printf("\n\rEntered PL_HIBERNATE case");
            if(POWER_LEVEL==2 || POWER_LEVEL==3 || POWER_LEVEL==0)
            {                
                if(PL_STATUS==0) 
                {
                    gPC.printf("Powering on PL_BEE\r\n");                    
                    SET_PL_BEE_ON;
                    PL_STATUS=1;
                }
                gPC.printf("\n\rCommanding PL_BEE to go to Hibernate State");  
                Base_tm *tm_ptr_hibernate;
                SET_PL_BEE_HIBERNATE(tm_ptr_hibernate);
                if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
                {
                    pl_main_flag = pl_main_flag & (~PL_DISABLED);
                    pl_main_flag |= PL_HIBERNATE;
                    PL_STATUS = 0x02;
                }
            }
            else 
            {
                pl_main_flag |= PL_LOW_POWER;
                PL_LOW_power = 1;
                if(PL_STATUS==0) 
                {
                    gPC.printf("\n\rPowering on PL_BEE");
                    SET_PL_BEE_ON;
                    PL_STATUS=1;
                }
                gPC.printf("\n\rCommanding PL_BEE to go to Standby State");
                Base_tm *tm_ptr_standby;
                SET_PL_BEE_STANDBY(tm_ptr_standby);
                if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
                {
                    pl_main_flag = pl_main_flag & (~PL_DISABLED);
                    pl_main_flag |= PL_STANDBY; 
                    PL_STATUS = 0x01;
                }        
                pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS 
                PL_MAIN_status = 0;
                print_processed_block(pl_next_index-1);
                print_exit(temp);
                return;
                                                                                //////DELETE THE TM AND TC LATER
            }            
            pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS
            PL_MAIN_status = 0;
            print_processed_block(pl_next_index-1);
            print_exit(temp);
            return;
                                                                            //////DELETE THE TM LATER
        }
        case STATE_SCIENCE:
        {
            gPC.printf("\n\rEntered PL_SCIENCE case");
            if(POWER_LEVEL==3 || POWER_LEVEL==0)                            //POWER_LEVEL = 0 = NA
            {
                gPC.printf("\n\rPOWER_LEVEL = 3 or NA");
                if(PL_STATUS==0)
                {
                    gPC.printf("\n\rPowering on PL_BEE");
                    SET_PL_BEE_ON;
                    PL_STATUS=1;
                }
                gPC.printf("\n\rCommanding PL_BEE to go to Science State");  
                Base_tm *tm_ptr_science;
                SET_PL_BEE_SCIENCE(tm_ptr_science);
                if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
                {
                    pl_main_flag = pl_main_flag & (~PL_DISABLED);
                    pl_main_flag |= PL_SCIENCE; 
                    PL_STATUS = 0x03;
                }
                pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS
                PL_MAIN_status = 0;
                print_processed_block(pl_next_index-1);
                print_exit(temp);
                return;
            }
            else
            {   
                gPC.printf("\n\rPower level = 2,3 or NA");
                pl_main_flag |= PL_LOW_POWER;
                PL_LOW_power = 1;
                if(POWER_LEVEL==2 || POWER_LEVEL==3 || POWER_LEVEL==0)
                {                
                    if(PL_STATUS==0) 
                    {
                        gPC.printf("\n\rPowering on PL_BEE");
                        SET_PL_BEE_ON;
                        PL_STATUS=1;
                    }
                    gPC.printf("\n\rCommanding PL_BEE to go to Hibernate State");  
                    Base_tm *tm_ptr_hibernate;
                    SET_PL_BEE_HIBERNATE(tm_ptr_hibernate);
                    if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
                    {
                        pl_main_flag = pl_main_flag & (~PL_DISABLED);
                        pl_main_flag |= PL_HIBERNATE; 
                        PL_STATUS = 0x02;
                    }
                }
                else 
                {
                    pl_main_flag |= PL_LOW_POWER;
                    PL_LOW_power = 1;
                    if(PL_STATUS==0) 
                    {
                        gPC.printf("\n\rPowering on PL_BEE");
                        SET_PL_BEE_ON;
                        PL_STATUS=1;
                    }
                    gPC.printf("\n\rCommanding PL_BEE to go to Standby State");  
                    Base_tm *tm_ptr_standby;
                    SET_PL_BEE_STANDBY(tm_ptr_standby);
                    if((pl_main_flag & PL_DISABLED)==PL_SUCCESS_I2C)
                    {
                        pl_main_flag = pl_main_flag & (~PL_DISABLED);
                        pl_main_flag |= PL_STANDBY; 
                        PL_STATUS = 0x01;
                    }        
                    pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS 
                    PL_MAIN_status = 0;
                    print_processed_block(pl_next_index-1);
                    print_exit(temp);
                    return;                                               
                                                                                    //////DELETE THE TM AND TC LATER
                }            
                pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS
                PL_MAIN_status = 0;
                print_processed_block(pl_next_index-1);
                print_exit(temp);
                return;
                                                                                //////DELETE THE TM LATER
            }
        }
        default:
        {
            gPC.printf("\n\rInvalid PL_STATE in block at index = %d",pl_next_index-1);
            pl_main_flag  = pl_main_flag & (~PL_DISABLED);
            pl_main_flag |= PL_INVALID_STATE;
            PL_STATUS = 0x06;
            pl_block[pl_next_index-1] &= (~UNEXECUTED);                         //changing exec_status                    
            pl_block[pl_next_index-1] |= EXECUTED;
            pl_main_flag  = pl_main_flag & (~PL_MAIN_STATUS);               //Clearing PL_MAIN_STATUS
            PL_MAIN_status = 0;
            print_processed_block(pl_next_index-1);
            print_exit(temp);
            return;
        }
    }    
}