void FCTN_CDMS_INIT_RTC()
{
    SPI_mutex.lock();
    gCS_RTC=1;
    spi.format(8,0);
    spi.frequency(1000000);
    //clearing the halt bit 
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8C);
    spi.write(0x00);
     
    //clearing the OF bit 
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x8F);
    spi.write(0x00);
     
    //century bits
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x80|0x03);
    spi.write(0x00);
 
    //Kick starting the oscillator 
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81); //register address with write flag
    spi.write(0x80);//enabling stop bit in the seconds register
 
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x81);
    spi.write(0x00);//disabling the stop bit to restart the oscillator 
 
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x80); 
    spi.write(0x01); // set milliseconds value to 00
    gCS_RTC=1;
 
    gCS_RTC=0;
    spi.write(0x81); 
    spi.write(0x01); //set seconds value to 00
    gCS_RTC=1;
 
    gCS_RTC=0;
    spi.write(0x82); 
    spi.write(0x01);//set minutes value to 00
    gCS_RTC=1;
 
    gCS_RTC=0;
    spi.write(0x83); 
    spi.write(0x23); //set the hours to 01
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x84); 
    spi.write(0x01); //set day of the week to 01
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x85); 
    spi.write(0x31); //set date of the month to 01
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x86); 
    spi.write(0x12); //set month to 01
    gCS_RTC=1;
    
    gCS_RTC=0;
    spi.write(0x87); 
    spi.write(0x01); //set year to 00(2000)
    gCS_RTC=1;
    gPC.puts("\n\r rtc initalised \n");
    SPI_mutex.unlock();
}
 
uint64_t FCTN_CDMS_RD_RTC()
{    
    SPI_mutex.lock();
    uint8_t response;
    //gPC.printf("\n\r Entered rtc\n");
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x00); //reading milliseconds register
    response = spi.write(0x00); // read the value by sending dummy byte
    uint8_t centiseconds =  (uint8_t(response&0xF0)>>4)*10+uint8_t(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x01); //reading seconds register
    response =spi.write(0x01);
    uint8_t seconds =  ((response&0x70)>>4)*10+(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x02); //reading minutes register
    response =spi.write(0x01);
    uint8_t minutes =  ((response&0xF0)>>4)*10+(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x03); //reading hours register
    response=spi.write(0x01);
    uint8_t hours =  ((response&0x30)>>4)*10+(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x04); //reading day's  register
    uint8_t day =spi.write(0x01);
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x05); //reading date register
    response =spi.write(0x01);
    uint8_t date =  ((response&0x30)>>4)*10+(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x06); //reading month registe
    response =spi.write(0x01);
    uint8_t month =  ((response&0x10)>>4)*10+(response&0x0F)*1;
    
    gCS_RTC=1;
    gCS_RTC=0;
    spi.write(0x07); //reading year's registe
    response =spi.write(0x01);
    uint8_t year =  ((response&0xF0)>>4)*10+(response&0x0F)*1;
    gCS_RTC=1;
    //sprintf(Time_stamp,"%02d%02d%02d%02d%02d%02d%02d%02d",year, month, date, day, hours, minutes, seconds, milliseconds );
    uint8_t Time_stamp[8] = {year, month, date, day, hours, minutes, seconds, centiseconds};
    for(int i= 0; i<8;i++);
        //printf("%d\t",Time_stamp[i]);
    //printf("read\r\n");
    uint64_t time;
    time = 0;
    time = time|(((uint64_t)(centiseconds&0x7F)));
    time = time|(((uint64_t)(seconds&0x3F))<<7);
    time = time|(((uint64_t)(minutes&0x3F))<<13);
    time = time|(((uint64_t)(hours&0x1F))<<19);
    time = time|(((uint64_t)(day&0x1F))<<24);
    time = time|(((uint64_t)(month&0x07))<<29);
    time = time|(((uint64_t)(year&0x03))<<33);
    time = (time&0x00000007FFFFFFFF);
    //gPC.printf("\n\r%x%x", (int)(time >> 32), (int)(time));
    //gPC.printf("\n\r0x%016llx\n\r", time);
   return time;
   SPI_mutex.unlock();
}