//without reset feature , with state checks.
DigitalIn IRQ(ADF_IRQ);
//Ticker ticker;
 
bool loop_on;
bool ADF_off;
bool buffer_state;
bool finish_write_data;
uint8_t signal = 0x00;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};
 
//int initialise_card();
//int disk_initialize();
 
#define bbram_write {\
     SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xB0);\
    wait_us(300);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    for(int i=0;i<66;i++){\
        spi.write(bbram_buffer[i]);\
    }\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
}
//------------------------------------------------------------------------
// state checking functions
//bool assrt_phy_off( int, int, int);
//bool assrt_phy_on( int,int,int);
//bool assrt_phy_tx(int,int,int);
 
#define START_ADDRESS 0x020;
#define MISO_PIN PTE3
/**************Defining Counter Limits**************/
#define THRS 20
#define STATE_ERR_THRS 20
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/
#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB
 
#define check_status {\
    unsigned char stat=0;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    stat = spi.write(0xFF);\
    gCS_ADF=1;\
    status = stat;\
}
 
// all three arguments are int
#define assrt_phy_off(return_this) {\
    int cmd_err_cnt = 0;\
    int spi_err_cnt = 0;\
    int state_err_cnt = 0;\
    for(int i = 0 ; i < 40 ;i++){\
        check_status;\
        if(status == 0xB1){\
            return_this = 0;\
            break;\
        }\
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){\
            return_this = 1;\
            break;\
        }\
        else if(state_err_cnt>STATE_ERR_THRS){\
            return_this = 1;\
            break;\
        }\
        else if( (status & 0xA0) == 0xA0 ){\
            gCS_ADF=0;\
            spi.write(CMD_PHY_OFF);\
            gCS_ADF=1;\
            wait_us(PHY_OFF_EXEC_TIME);\
            state_err_cnt++;\
        }\
        else if(status&0x80==0x00){\
            wait_ms(5);\
            spi_err_cnt++;\
        }\
        else {\
            wait_ms(1);\
            cmd_err_cnt++;\
        }\
    }\
}
 
 
#define initial_adf_check {\
    spi.write(CMD_PHY_OFF);\
    int tempReturn = 0;\
    bool flag = false;\
    while( hw_reset_err_cnt < 2 ){\
        assrt_phy_off( tempReturn);\
        if( !tempReturn ){\
            bbram_write;\
            bbram_flag=1;\
            flag = true;\
            break;\
        }\
        else{\
            hardware_reset(0);\
            hw_reset_err_cnt++;\
            gPC.puts("Resetting hardware\r\n");\
        }\
    }\
    if( flag == false ){\
        gPC.puts("Seems to be SPI problem\r\n");\
    }\
    assrt_phy_off(tempReturn);\
    if(!bbram_flag){\
        bcn_flag=1;\
     }\
}
 
unsigned char status =0;
unsigned int cmd_err_cnt=0;
unsigned int state_err_cnt=0;
unsigned int miso_err_cnt=0;
unsigned int hw_reset_err_cnt=0;
bool bcn_flag=0;
bool bbram_flag=0;
 
bool hardware_reset(int bcn_call){
    for(int i= 0; i < 20 ; i++){
        gCS_ADF=0;
        spi.write(CMD_HW_RESET);
        gCS_ADF=1;
        wait_ms(2);// Typically 1 ms
        int count=0;
        int temp_return = 0;
        while(count<10 && miso_err_cnt<10){      
            if(MISO_PIN){
                assrt_phy_off(temp_return);
                if(!temp_return){
                    return 0;
                }
                count++;
            }
            else{
                wait_us(50);
                miso_err_cnt++;
            }
        }
    }
    return 1;
}
 
//for reseting the transmission call assert function after b5 and b1. after b1 assert_phi_on and after b5 assert_phi_tx. 
//----------------------------------------------------------------------------
 
# define initiate {\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x14);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x15);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x24);\
    spi.write(0x20);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x37);\
    spi.write(0xE0);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x36);\
    spi.write(0x70);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x39);\
    spi.write(0x10);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xBB);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
}
 
#define write_data {\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0x0B);\
    spi.write(0x36);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    if(buffer_state){\
        spi.write(0x18);\
        spi.write(0x20);\
        for(unsigned char i=0; i<112;i++){\
            if(bypass_adf)\
                gPC.putc(buffer_112[i]);\
            else\
                spi.write(buffer_112[i]);\
            /*gPC.printf("0x%X,",spi.write(buffer_112[i]));*/\
        }\
    }\
    else{\
        spi.write(0x18);\
        spi.write(0x90);\
        for(unsigned char i=0; i<112;i++){\
            if(bypass_adf)\
                gPC.putc(buffer_112[i]);\
            else\
                spi.write(buffer_112[i]);\
            /*gPC.printf("0x%X,",spi.write(buffer_112[i]));*/\
        }\
    }\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
    buffer_state = !buffer_state;\
    if(last_buffer){\
        finish_write_data = true;\
        /*gPC.puts("adf_off\r\n");*/\
    }\
}
 
/* 
void check(){   
    if(IRQ){
        gCOM_MNG_TMTC_THREAD->signal_set(signal);
    }
}*/
  
 
#define send_data {\
if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card_fun();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xB1);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xB5);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
    /*ticker.attach_us(&check,32000);*/\
}
 
#define configure_adf {\
    finish_write_data = false;\
    buffer_state = true;\
    last_buffer = false;\
    loop_on = true;\
    ADF_off = false;\
    initial_adf_check;\
    gPC.puts("initial adf check\r\n");\
    initiate;\
    gPC.puts("adf configured\r\n");\
    /*gLEDR = !gLEDR;*/\
}
 
#define transmit_adf {\
    configure_adf;\
    if(sent_tmfrom_SDcard)\
    signal = COM_MNG_TMTC_SIGNAL_ADF_SD;\
    else signal = COM_MNG_TMTC_SIGNAL_ADF_NSD;\
    send_data;\
    while(loop_on){\
        wait_ms(COM_TX_TICKER_LIMIT);\
        if(IRQ || bypass_adf){\
            if(finish_write_data){\
                if(ADF_off){\
                    SPI_mutex.lock();\ 
                    gCS_ADF=0;\
                    spi.write(0xB1);\
                    gCS_ADF=1;\
                    SPI_mutex.unlock();\
                    loop_on = false;\
                    gPC.puts("Transmission done\r\n");\
                    gLEDR = 1;\
                }\
                else{\
                    ADF_off = true;\
                }\
            }else{\ 
                gLEDG = !gLEDG;\  
                write_data;\
                if(sent_tmfrom_SDcard)\
                send_tm_from_SD_card_fun();\
                else snd_tm.transmit_data(buffer_112,&last_buffer);\ 
            }\
        }\
    }\
    /*gPC.puts("after while loop\r\n");*/\
}

