unsigned int read_2byte(uint8_t* ptr){
    unsigned int output = (unsigned int) *(ptr+1);
    output += ( (unsigned int)(*ptr) ) << 8;
    return output;
}
    
unsigned int read_4byte(uint8_t* ptr){
    unsigned int output = (unsigned int) *(ptr+3);
    output += (unsigned int)*(ptr+2)<<8;
    output += (unsigned int)*(ptr+1)<<16;
    output += (unsigned int)*(ptr)<<24;
    return output;
}

int adjust(int size, unsigned int data, uint8_t* ptr , int space){
    space = space&0x0f;
    if(space == 8)  *ptr = 0;
    data = data&((1<<size)-1);
    if(space >= size){
        *ptr += data<<(space-size);
        if(space - size == 0){
            return 0x18;
        }else{
            return space-size;
        }
    }else{
        ptr[0] += data>>(size-space);
        ptr[1] = (data<<(8-(size-space)))&0xff ;
        return 0x10 + 8-(size - space);
    }
}


int compress (int data, int x, int y){  //to be compressed with scheme (msb x)*4^y ;
    for(int i = 0 ; i < 1<<y ; i++){
        if(data <= ( (1<<x)-1) * (1<<(2*i)) ){
            return ( ((data>>i*2)<<y) + i);
        }
    }
    if ( data > ( (1<<x)-1) * (1<<(2*((1<<y)-1))) ){
//      cout <<"compression exception"<<endl;
        return 0;
    }
}



//variable declerations
uint8_t srp_mode , at , pzf , ezf ,sfp[65] ,scp[55];; //tells which mode is calibrated or plot 0 for calibrated and 1 for scatterered, below threshold , proton zero flux, electron zero flux.
unsigned int sfp_bin[52] , scp_bin[52];         //storing the bin values.
unsigned int sfp_threshold_m0[52] = {8128,8128,8128,8128,8128,8128,8128,8128,960,960,960,960,960,960,960,960,960,960,960,960,4032,4032,4032,4032,8128,8128,8128,8128,4032,4032,124,124,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,252,252,252,252,252}; 
unsigned int scp_threshold_m0[52] = {245760,245760,245760,245760,245760,245760,245760,245760,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,114688,114688,114688,114688,245760,245760,245760,245760,114688,114688,4032,4032,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,1984,8128,4032,4032,4032,4032};
unsigned int scp_threshold_m0_1[9]={114688,245760,245760,245760,245760,114688,114688,65472,65472} ; //for mode 0..ie callibrated mode
unsigned int sfp_threshold_m1[2] ={252,8128},scp_threshold_m1[2]={7680,245760};
uint8_t frames[3][134] = {0};
uint8_t position_tm_frame[3] = {8,11,5} , position_tm_starting[3] = {8,11,5}; //{sc,sf-bt,sf-at}
uint8_t id;   //sf = 0,sc-at = 1,sc-bt = 2;
uint8_t TM_interleave_data[512] , TM_convoluted_data[270] = {0};
int proton_scp_sum,electron_scp_sum,length, temp_crc,attitude = 0,debug_cntr = 0, size,space;
uint32_t FSC_science;   
uint8_t *ptr ,* pointer;
long long int sci_time = 0x221000000;       //call some function and get the time or get in the starting, what ever akshay says
int test_cntr = 0;

    Convolution ConvObj;
    void convolution (uint8_t * ptr){
        ConvObj.convolutionEncode(ptr, TM_convoluted_data);
        ConvObj.convolutionEncode(ptr + 67, TM_convoluted_data + 135);
    }

//give the pointer of 6 second data to this function
void srp(uint8_t * head){
    //sci_time = FCTN_CDMS_RD_RTC();
    sci_time = 0;
    gPC.puts("enter srp");
    
    
    
    //Call FCTN_SD_MNGR for latest fsc
    FCTN_SD_MNGR();
    uint8_t sd_stat;
    
    for (int i = 0; i < 52 ; i++){
        scp_bin[i] = 0;
    }
    ptr = head + 3;
    srp_mode = head[2]&0x1;
    at = 0;     //above threshold is false
    for(int counter = 0 ; counter < 60 ; counter++){
        //gPC.puts("Y");
//        gPC.printf("counter = %d\n",counter);
//        cout<<"counter = "<<counter<<endl;
        pzf = 1;    ezf = 1;
        if(srp_mode == 0){      //calibrated mode
            for(int i=0; i<48 ; i++){
                sfp_bin[i] = read_2byte(ptr + i*2);
                scp_bin[i] += sfp_bin[i];
                if(sfp_bin[i]>sfp_threshold_m0[i]){
                    at = 1;
                }
                if(i<17){
                    if(sfp_bin[i] > 0)
                        pzf = 0;
                }
                else if (i>17 && i < 23){
                    if(sfp_bin[i]>0)
                        ezf = 0;
                }
            }
            for(int i=0; i<4; i++){
                sfp_bin[i+48] = read_4byte( (ptr+96) + 4*i );
                scp_bin[i+48] += sfp_bin[i+48];
                if(sfp_bin[i+48]>sfp_threshold_m0[i+48])
                    at = 1;
            }
        }
        else if(srp_mode == 1){ //scattered mode
            for(int i = 0; i <32; i++){
                sfp_bin[i] = read_2byte(ptr+2*i);
                scp_bin[i] += sfp_bin[i];
                if(sfp_bin[i] > sfp_threshold_m1[0])
                    at = 1;
            }
            for(int i = 0; i < 4 ; i++){
                sfp_bin[i+32] = read_4byte( (ptr+64) + 4*i );
                scp_bin[i+32] += sfp_bin[i+32];
                if(sfp_bin[i+32] > sfp_threshold_m1[1])
                    at = 1;
            }
        }
        ptr = ptr + 112;
        for(int i = 0; i<65; i++)
            sfp[i] = 0;
        if(srp_mode == 0){      //calibrated mode
            if(at == 0){
                pointer = sfp; debug_cntr = 0;
                space = adjust(4, attitude,pointer,8);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, pzf,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, ezf,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                for(int i = 0 ; i < 8 ; i++){
                    space = adjust(1, ((compress(sfp_bin[24+i],7,2))&0x100)>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i <12 ; i++){
                    space = adjust(6, (compress(sfp_bin[32+i],4,2)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0; i < 4; i++){
                    space = adjust(8, (compress(sfp_bin[44+i],6,2)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],7,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],7,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(8, ((compress(sfp_bin[17],6,2))&0xff) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, ((compress(sfp_bin[23],6,2))&0xff) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                if(pzf == 0){
                    for(int i = 0; i<2 ; i++){
                        space = adjust(6, ((compress(sfp_bin[i],5,1))&0xff) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                    }
                    for(int i = 0; i<15 ; i++){
                        space = adjust(5, ((compress(sfp_bin[i+2],4,1))&0xff) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
                if(ezf == 0){
                    for(int i = 0; i <5 ;i++){
                        space = adjust(7, ((compress(sfp_bin[18+i],6,1))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    }
                }
            }//below thershold ends here.
        
        //gPC.puts("below_thresh\r\n");
        
            if(at == 1){
                pointer = sfp + 6; debug_cntr = 6;space = 8;
                sfp[0] = (sci_time>>27)&0xff;   sfp[1] = (sci_time>>19)&0xff;   sfp[2] = (sci_time>>11)&0xff;   sfp[3] = (sci_time>>3)&0xff;
                sfp[4] = ((sci_time&0x07)<<5) + ((attitude&0x0f)<<1) + (counter>>5);    
                sfp[5] = ((counter&0x0f)<<3) + (srp_mode<<2);   
                sfp[5] += (pzf<<1) + ezf ;
                for(int i = 0 ; i < 8 ; i++){
                    space = adjust(1, (compress(sfp_bin[24+i],7,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, ((compress(sfp_bin[24+i],7,2))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i <12 ; i++){
                    space = adjust(6, ((compress(sfp_bin[32+i],3,3))&0xff) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i < 4 ; i++){
                    space = adjust(2, (compress(sfp_bin[44+i],8,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[44+i],8,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[48+i],6,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[48+i],6,3) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(2, (compress(sfp_bin[17],8,2))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[17],8,2) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(2, (compress(sfp_bin[23],8,2))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, compress(sfp_bin[23],8,2) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                
                if(pzf == 0){
//                  cout<<"proton bins ";
                    for(int i = 0; i<17 ; i++){
                        space = adjust(2, ((compress(sfp_bin[i],8,2))>>8) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
//                      printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
                if(ezf == 0){
//                  cout<<"electron bins ";
                    for(int i = 0; i<5 ; i++){
                        space = adjust(2, ((compress(sfp_bin[18+i],8,2))>>8) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                        space = adjust(8, compress(sfp_bin[18+i],8,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
//                      printf("%02X ",compress(sfp_bin[i],8,2));
                    }
                }
//              cout<<debug_cntr<<" "<<(space&0xf)<<endl;
//              cout<<"packet ";
//              for(int i = 0; i< 64; i++){
//                  cout<<bitset<8>(sfp[i]);
//              }
//              cout<<"ends"<<endl;
            }//above threshold ends here.
        }else if(srp_mode == 1){    //scattered mode
            if(at == 0){
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(4, attitude,pointer,8);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<32; i++){
                    space = adjust(7, compress(sfp_bin[i],6,1) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[32+i],7,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[32+i],7,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(at == 1){
                pointer = sfp; debug_cntr = 0;  space = 8;
                space = adjust(3, sci_time>>32 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>24 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>16 ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time>>8 ,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, sci_time ,pointer,space); pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(4, attitude,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, counter,pointer,space);   pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(1, srp_mode,pointer,space);  pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<32; i++){
                    space = adjust(2, (compress(sfp_bin[i],8,2))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[i],8,2) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0 ; i < 4 ; i++){
                    space = adjust(1, (compress(sfp_bin[32+i],6,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, compress(sfp_bin[32+i],6,3) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }   
        
        //gPC.puts("sci fine pack\r\n");
        //science fine packet is complete here.
        //lets try to make frame now******************************************************************************************************************************
        if(srp_mode == 0){
            if(at == 0){
                id = 1;     length = 241;
                if(pzf == 0)
                    length += 87;
                if(ezf == 0)
                    length += 35;
            }else{
                id = 2;     length = 288;
                if(pzf == 0)
                    length += 170;
                if(ezf == 0)
                    length += 50;
            }
        }
        else if(srp_mode == 1){
            if(at == 0){
                id = 1;     length = 272;
            }else{
                id = 2;     length = 408;
            }
        }
        length = (length%8==0)?(length/8):(length/8)+1;
        for(int j=0 ; j<length ;j++){
//          printf("%02X",sfp[j]);
            frames[id][position_tm_frame[id]] = sfp[j];
            position_tm_frame[id]++;
            if(position_tm_frame[id] == 132){   //space full in the frame bro
                pointer = frames[id];
                if(id == 1){    //below thereshold
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,3,pointer,space);
                    FSC_science = FSC_CURRENT[3]+1;
                    //gPC.printf("SID = 3, FSC = %02X\r\n", FSC_CURRENT[3]+1);
                    frames[id][1] = (FSC_science>>24)&0xff;
                    frames[id][2] = (FSC_science>>16)&0xff;
                    frames[id][3] = (FSC_science>>8)&0xff;
                    frames[id][4] = FSC_science&0xff;
                    frames[id][6] = (sci_time>>32)&0xff;
                    frames[id][7] = (sci_time>>24)&0xff;
                    frames[id][8] = (sci_time>>16)&0xff;
                    frames[id][9] = (sci_time>>8)&0xff;
                    frames[id][10] = (sci_time)&0xff;
                }else if(id == 2){
                    space = adjust(1,0,pointer,8);
                    space = adjust(4,2,pointer,space);
                    FSC_science = FSC_CURRENT[2]+1;
                    //gPC.printf("SID = 2, FSC = %02X\r\n", FSC_science);
                    frames[id][1] = (FSC_science>>16)&0xff;
                    frames[id][2] = (FSC_science>>8)&0xff;
                    frames[id][3] = FSC_science&0xff;
                }
                temp_crc = crc16_gen(frames[id],132);
                frames[id][132] = temp_crc>>8;
                frames[id][133] = temp_crc & 0xff;
                //if(test_cntr++ == 0){
                    /*gPC.puts("frame start\r\n");
                    for(int i = 0; i<134; i++){
                        gPC.printf("%02X",frames[id][i]);
                    }    
                    gPC.puts("frame ends\r\n");*/
                //}
                   
                
                exor(frames[id]);
                convolution(frames[id]);
                interleave(TM_convoluted_data,TM_interleave_data);
                interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);
                
                if(id == 1){
                    sd_stat = SD_WRITE(TM_interleave_data,FSC_CURRENT[3]+1,3);
                   }
                else if (id == 2){
                    sd_stat = SD_WRITE(TM_interleave_data,FSC_CURRENT[2]+1,2);
                  }
                if(sd_stat)
                {
                    //gPC.puts("sd write failure");
                    break;
                    }
                position_tm_frame[id] = position_tm_starting[id];
                frames[id][6-id] = (length-1) - j;      // first head pointer.
                
            }
        }
        
    }//for loop bracket which runs 60 times
    
    //---------------below is scp --------------**************************************************************************************************
    at = 0;     pzf = 1;    ezf = 1;
    srp_mode = head[2]&0x1;
    uint8_t compression_option = (head[2]>>1)&0x3;    //--------------------------------------------------------------------------------------
    if(srp_mode ==0){
        if(compression_option == 0){
            for(int i=0; i<52 ;i++){
                if(scp_bin[i] > scp_threshold_m0[i]){
                    at = 1;
                    break;
                }
            }
        }
        else if(compression_option == 1){
            if(scp_bin[44] > scp_threshold_m0_1[0]) at=1;
            for(int i=0; i<4 ;i++){
                if(scp_bin[48+i] > scp_threshold_m0_1[i+1]){
                    at = 1;
                    break;
                }
            }
            if(scp_bin[17] > scp_threshold_m0_1[5]) at=1;
            if(scp_bin[23] > scp_threshold_m0_1[6]) at=1;
            
            proton_scp_sum = 0; electron_scp_sum = 0;
            for(int i=0;i<17;i++){
                proton_scp_sum += scp_bin[i];
            }
            for(int i=0; i<5; i++){
                electron_scp_sum += scp_bin[18+i];
            }
            if(proton_scp_sum > scp_threshold_m0_1[7]) at=1;
            if(electron_scp_sum > scp_threshold_m0_1[8]) at=1;
        }
    }else if(srp_mode ==1){
        for(int i=0; i<32; i++){
            if(scp_bin[i] > scp_threshold_m1[0]){
                at = 1;
                break;
            }
        }
        for(int i=32; i<36; i++){
            if(scp_bin[i] > scp_threshold_m1[1]){
                at = 1;
                break;
            }
        }
    }
    
    for(int i=0; i<17 ;i++){
        if(scp_bin[i]>0)
            pzf = 0;
    }
    for(int i=18; i<23 ;i++){
        if(scp_bin[i]>0)
            ezf = 0;
    }
    
    gPC.puts("scp\r\n");
    
    pointer = scp;      debug_cntr = 0;     space = 8;
    uint8_t packet_pp = 1;    //where to get this packet present bit----------------------------------------------------------------------------------
    int sfp_at_counter; //----------------------------------------------------------------------------------------------------------------------------------
    space = adjust(1, packet_pp,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(5, (sci_time>>8)&0x1f,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, (sci_time)&0xff,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(4, (attitude)&0xf,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(2, compression_option,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(1,srp_mode,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(1,srp_mode,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, sfp_at_counter>>16,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, sfp_at_counter>>8,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
    space = adjust(8, sfp_at_counter,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
    if(srp_mode == 0 && compression_option == 0){       //normal callibrated mode
        space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0 ){
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(sfp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress(sfp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(6,compress(scp_bin[44+i],3,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(7,compress(scp_bin[48+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(6,compress(scp_bin[17],3,3) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(6,compress(scp_bin[23],3,3),pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            if(pzf == 0){
                for(int i = 0; i<2 ;i++){
                    space = adjust(8,compress(scp_bin[i],6,2) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                for(int i = 0; i<15 ;i++){
                    space = adjust(7,compress(scp_bin[i+2],5,2) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                space = adjust(1,compress(scp_bin[18],7,2)>>8 ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[18],7,2) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<4; i++){
                    space = adjust(8,compress(scp_bin[19+i],6,2) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }// below threshold ends here
        if(at == 1){
            for(int i = 0; i<8 ;i++){
                space = adjust(7,compress(scp_bin[24+i],4,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<12 ;i++){
                space = adjust(5,compress(scp_bin[32+i],2,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0; i<4 ;i++){
                space = adjust(1,compress(scp_bin[44+i],6,3)>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[44+i],6,3) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i=0; i<4 ;i++){
                space = adjust(2,compress(scp_bin[48+i],6,4)>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8,compress(scp_bin[48+i],6,4) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1,compress(scp_bin[17],6,3)>>8 ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[17],6,3),pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1,compress(scp_bin[23],6,3)>>8,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8,compress(scp_bin[23],6,3),pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            if(pzf == 0){
                for(int i = 0; i<17 ; i++){
                    space = adjust(8, (compress(scp_bin[i],5,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                }
            }
            if(ezf == 0){
                for(int i = 0; i<5 ; i++){
                    space = adjust(8, (compress(scp_bin[18+i],5,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
            }
        }   //above thresholds ends
    }   //srp_mode == 0 ends
    if(srp_mode == 1){
        if(at == 0){
            for(int i=0; i<32; i++){
                space = adjust(6, ((compress(scp_bin[i],4,2))&0xff) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(7, (compress(scp_bin[32+i],4,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
        if(at == 1){
            for(int i=0; i<32; i++){
                space = adjust(6, (compress(scp_bin[i],3,3))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            for(int i = 0 ; i < 4 ; i++){
                space = adjust(4, (compress(scp_bin[32+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[32+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }// scp mode 1 end
    if( srp_mode == 0 && compression_option == 1 ){ //scp data conservation mode
        space = adjust(1, pzf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        space = adjust(1, ezf,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
        if(at == 0){
            if(at == 0){
                space = adjust(6, (compress(scp_bin[44],3,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                for(int i=0; i<4; i++){
                    space = adjust(7, (compress(scp_bin[48+i],4,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                }
                space = adjust(6, (compress(scp_bin[17],3,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(6, (compress(scp_bin[23],3,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                if(pzf==0){
                    space = adjust(2, (compress(proton_scp_sum,10,2))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(proton_scp_sum,10,2)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                }
                if(ezf==0){
                    space = adjust(2, (compress(electron_scp_sum,10,2))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                    space = adjust(8, (compress(electron_scp_sum,10,2)) ,pointer,space);    pointer += space>>4;    debug_cntr += space>>4;
                }
            }   // scp data conservaton mode 
        }else if(at == 1){
            space = adjust(1, (compress(scp_bin[44],6,3))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[44],6,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            for(int i=0; i<4; i++){
                space = adjust(4, (compress(scp_bin[48+i],9,3))>>8 ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(scp_bin[48+i],9,3)) ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
            }
            space = adjust(1, (compress(scp_bin[17],6,3)>>8) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[17],6,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(1, (compress(scp_bin[23],6,3))>>8 ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            space = adjust(8, (compress(scp_bin[23],6,3)) ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
            if(pzf==0){
                space = adjust(1, (compress(proton_scp_sum,6,3))>>8 ,pointer,space);        pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(proton_scp_sum,6,3)) ,pointer,space);       pointer += space>>4;    debug_cntr += space>>4;
            }
            if(ezf==0){
                space = adjust(1, (compress(electron_scp_sum,6,3))>>8 ,pointer,space);      pointer += space>>4;    debug_cntr += space>>4;
                space = adjust(8, (compress(electron_scp_sum,6,3)) ,pointer,space);     pointer += space>>4;    debug_cntr += space>>4;
            }
        }
    }//-----------------------------------------------------------------------------------------------------------------------------------------------------
    
    gPC.puts("sci frame starts\r\n");
    
    //time to make scp frame
    id = 0;
    if(srp_mode == 0 && compression_option == 0){
        if(at == 0){
            length = 228;
            if(pzf == 0)
                length += 121;
            if(ezf == 0)
                length +=41;
        }else if(at == 1){
            length = 266;
            if(pzf == 0)
                length += 136;
            if(ezf == 0)
                length += 40;
        }
            
    }else if(srp_mode == 0 && compression_option == 1){     //data conservation mode
        if(at == 0){
            length = 94;
            if(pzf == 0)
                length += 12;
            if(ezf == 0)
                length += 12;
        }else if(at == 1){
            length = 123;
            if(pzf == 0)
                length += 9;
            if(ezf == 0)
                length += 9;
        }
    }else if( srp_mode == 1){
        if(at == 0)
            length = 272;
        else if(at == 1)
            length = 288;
    }
    length = (length%8==0)?(length/8):(length/8)+1;
    for(int j= 0; j < length ; j++){
        frames[id][position_tm_frame[id]] = scp[j];
            position_tm_frame[id]++;
            if(position_tm_frame[id] == 132){   //space full in the frame bro
                pointer = frames[id];
                space = adjust(1,0,pointer,8);
                space = adjust(4,1,pointer,space);
                FSC_science = FSC_CURRENT[1]+1;
                //gPC.printf("SID = 1, FSC = %02X\r\n", FSC_science);
                frames[id][1] = (FSC_science>>16)&0xff;
                frames[id][2] = (FSC_science>>8)&0xff;
                frames[id][3] = (FSC_science)&0xff;
                frames[id][5] = (sci_time>>16)&0x3f;
                frames[id][6] = (sci_time>>8)&0xff;
                frames[id][7] = (sci_time)&0xff;
                temp_crc = crc16_gen(frames[id],132);
                frames[id][132] = temp_crc>>8;
                frames[id][133] = temp_crc & 0xff;
                /*gPC.puts("frame start\r\n");*/
                /*for(int i = 0; i<134; i++){
                    gPC.printf("%02X",frames[id][i]);
                }    
                gPC.puts("frame ends\r\n");*/
                exor(frames[id]);
                convolution(frames[id]);
                interleave(TM_convoluted_data,TM_interleave_data);
                interleave(TM_convoluted_data+ 135,TM_interleave_data + 144);
                sd_stat = SD_WRITE(TM_interleave_data,FSC_CURRENT[1]+1,1);
                if(sd_stat)
                {
                    //gPC.puts("sd write failure");
                    break;
                }
                position_tm_frame[id] = position_tm_starting[id];
                frames[id][4] = (length-1) - j;
            }
    }
    gPC.puts("end srp");
}//srp fucntion end bracket