//changed the receiver bandwidth to 83.3 khz
//experiment on bandwidth stuff
//shaping in transmitter
//rssi thresh, etc.
//sync word ....callsign
//don't wait for sync_match!!!!!!!!!!!!!!!

/*f
regIrq2(0x28) :

regpacketconfig 1(0x37) :
set crc detection/calc. on : | 0x10
crcautoclearoff : | 0x08  

for data whitening : regpacketconfig 1(0x37) :| 0x40
*/

#include "mbed.h"
#define TIMES 20
Serial pc(USBTX, USBRX);           // tx, rx
SPI spi(D11, D12, D13);               // mosi, miso, sclk
DigitalOut cs(D10);                 //slave select or chip select

void writereg(uint8_t reg,uint8_t val)
{
    cs = 0;
    __disable_irq();
    spi.write(reg | 0x80);      
    spi.write(val);
    __enable_irq();
    cs = 1;
}
uint8_t readreg(uint8_t reg)
{
    int val;
    cs = 0;
    __disable_irq();
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    __enable_irq();
    cs = 1;
    return val;
}

int main(){
    wait(0.1);                           //wait for POR to complete
    cs = 1;                              // Chip must be deselected
    int bar = TIMES;            
    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    int u = 0;
    int hk_data_len = 240;
    uint8_t hk[240];
    
       if (readreg(0x15) == 0xB0) pc.printf("spi connection valid\n");
    else {pc.printf("error in spi connection\n"); wait(10); }
    
    //initialization
    //pc.printf("0x%X",readreg(0x01));
    //Common configuration registers
    writereg(0x01,0x00);       //sequencer off,standby mode
    writereg(0x02,0x08);// | 0x01);       //packet, ook, no dc           //0x00 for fsk   //default = 0x08 for ook
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    /*writereg(0x03,0x03);       //38.4kbps
    writereg(0x04,0x41);       //38.4kbps*/
    
    writereg(0x07,0x6C);       
    writereg(0x08,0xC0);
    writereg(0x09,0x00);       //try 6C C0 00 for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915   //6C D6 73 for 435.1Mhz
                               // 6D1015 for 436 MHZ
    //rx registers
    writereg(0x18,0x08);       //RegLNA using agc
    writereg(0x19,0x51);       //Regrxbw (data is successfully received  from 5.2 khz onwards for 1200bps)
                               //keep it as 0x51 for 83.3kHz, 0x42 for 62.5kHz, 0x49 for 100 kHz, 0x40 for 250khz, 57 for 1.3khz, 56 for 2.6khz  
                               //46 for 3.9khz
    
    
    //IRQ and pin mapping
    //irq1: modeready, rssi, syncaddressmatch used.
    //irq2: fifonnotempty, payloadready used.
    //rssi thresh is default = -117 dbm
    writereg(0x29,0xB4);       //rssi_thresh = -110 (0x6E)          //0xB4 for -180       //0x96 for -150dBm
                               //0x78 for -120
    
    //Packet Engine Registers
    writereg(0x2C,0x00);
    writereg(0x2D,0x0A);//preamblesize = 10 bytes
//    writereg(0x2E,0x80);//sync on , FIFO filling condition : if SyncAddress interrupt occurs
    writereg(0x2E,0x80);//sync on , FIFO filling condition : if SyncAddress interrupt occurs
    writereg(0x2F,0x5e);//sync word 1
//    writereg(0x30,0x23);//sync word 1
//    writereg(0x31,0x45);//sync word 1
    writereg(0x37,0x08| 0x10);//| 0x40);//Fixed length, on dc-free(0x40), no crc(0x10),issue packetready even if crc fails, no address filter
    writereg(0x38,0x00);//payload_length= 0 due to unlimited packet mode
    writereg(0x3C,0x27);//fifothresh is 39 because we want it to be set when it reaches 40
    
    pc.printf("press 'r' to start receiver\n");
    while(pc.getc()== 'r'){
    //force rx in WAIT mode
    writereg(0x3D,0x04);//avoid rx deadlocks
    //set to Rx mode
    writereg(0x01,0x10);
    
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);
    pc.printf("receiver is on, ready to accept.....\n");
    
    //wait for rssi to cross rssi_thresh
    while((readreg(0x27)& 0x08) != 0x08)pc.printf("w:rssi\n"); 

    //wait for SyncAddressMatch 
    while((readreg(0x27) & 0x01) != 0x01)pc.printf("w:sync\n");
     
    //pc.printf("receiving.....\n");
    //check for fifo_thresh
    while((readreg(0x28) & 0x20) != 0x20)pc.printf("w:fifo_thresh\n"); 
        
    while(bar == TIMES)//fifo_thresh
    {                
    if((hk_data_len - u - 40) >= TIMES)
        bar = TIMES;
    else
        bar = (hk_data_len - u - 40)%TIMES;
        //reading
        cs = 0;
        spi.write(0x00);
        for(int i=0; i<TIMES;i++,u++)
        hk[u] = spi.write(0);
        cs = 1;               
        //check for fifo_thresh
        while((readreg(0x28) & 0x20) != 0x20);
    }  
    //Check if received
    //while((readreg(0x28) & 0x04) != 0x04);.......donno why not getting fired!!!!!!!
    
    //check for fifo_thresh!!!!!
    while((readreg(0x28) & 0x20) != 0x20);
    
    pc.printf("\n\npacket received!!! \n\n");    
    
    wait(1);
    //Switch back to Standby Mode
    writereg(0x01,0x04);
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);
    
    //reading remaining 40 bytes
    cs = 0;
    spi.write(0x00);
    for (; u < hk_data_len  ; u++)
    hk[u] = spi.write(0);
    cs = 1;
    pc.printf("Received data:\n");
    //for(int i=0;i<240;i++) pc.printf("0x%X",hk[i]);
    // converting uint_8 to bool
    bool shortbeacon[120];
    for(int i = 0; i<120; i++)
    hk[2*i] == 0xFF ? shortbeacon[i] = 1 :shortbeacon[i] =  0; 
    /*for(int i = 0; i<120 ; i++)
    pc.printf(" %d \n",shortbeacon[i]);*/
    
    //converting bool to uint_8
    uint8_t s_beacon[15];
    for(int i = 0, m =0 ; i < 15 ; i++ )
    for(int n = 0; n < 8; n++,m++)
    {
        if(shortbeacon[m])
        {
             s_beacon[i]<<=1;
             s_beacon[i] |= 0x01;
        }  
        else
        s_beacon[i] <<= 1;
    }
    
    
    pc.printf("Call Sign : ");
    for(int i = 0; i<7 ; i++)
    pc.printf(" %X ",s_beacon[i]);
    
    pc.printf("\n\nVoltage[0] : ");
    pc.printf(" 0x%X \n\n",s_beacon[7]);
    
    pc.printf("AngularSpeed[0] : ");
    pc.printf(" 0x%X \n\n",s_beacon[8]);
    
    pc.printf("AngularSpeed[1] : ");
    pc.printf(" 0x%X \n\n",s_beacon[9]);
    
    pc.printf("SubsystemStatus[0] : ");
    pc.printf(" 0x%X \n\n",s_beacon[10]);

    pc.printf("Temp[0] : ");
    pc.printf(" 0x%X \n\n",s_beacon[11]);
    
    pc.printf("Temp[1] : ");
    pc.printf(" 0x%X \n\n",s_beacon[12]);
    
    pc.printf("Temp[2] : ");
    pc.printf(" 0x%X \n\n",s_beacon[13]);
    
    pc.printf("ErrorFlag[0] : ");
    pc.printf(" 0x%X \n\n",s_beacon[14]);
    
    } 
}
