// 6CC000 for 435 MHz
//set all values as FF for checking on spectrum analyzer
#include "beacon.h"
//Serial pc(USBTX, USBRX);           // tx, rx
Serial pc(USBTX, USBRX);
SPI spi(D11, D12, D13);               // mosi, miso, sclk
DigitalOut cs_bar(D10);                 //slave select or chip select
//InterruptIn button(p9);
#define TX_DATA 182    //218-2=216bytes when destuffed becomes 180 bytes      //doesnt work if sync < 11
//Timer t;
#define B(x) S_to_binary_(#x)

static inline unsigned long long S_to_binary_(const char *s)
{
        unsigned long long i = 0;
        while (*s) {
                i <<= 1;
                i += *s++ - '0';
        }
        return i;
}

void writereg(uint8_t reg,uint8_t val)
{
    cs_bar = 0;
    spi.write(reg | 0x80);      
    spi.write(val);
    cs_bar = 1;
}
uint8_t readreg(uint8_t reg)
{
    uint8_t val;
    cs_bar = 0;
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    cs_bar = 1;
    return val;
}
        
main() {
    int n = 0;
    //button.rise(&interrupt_func);         //interrupt enabled ( rising edge of pin 9)
    wait(0.02);                                                           // pl. update this value  or even avoid it!!!                  
    //extract values from short_beacon[]
    
    //pc.baud(115200);
    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    
    cs_bar = 1;                              // Chip must be deselected
    
    if (readreg(0x15) == 0xB0) pc.printf("spi connection valid\n");
    else {pc.printf("error in spi connection\n"); exit(0); }
    
    //initialization
    //Common configuration registers
    writereg(0x01,0x00);       //sequencer on,standby mode
    writereg(0x02,0x08);// |0x01);       //packet, ook, no dc           //0x00 for fsk   //default = 0x08 for ook
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    writereg(0x07,0x6C);       
    writereg(0x08,0xC0);    
    writereg(0x09,0x00);       //try 6C C0 00 for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915
    
    //FSK settings
    writereg(0x06,0x52);// = (actual Fdev)*0.016384 //0x52 for 5khz //0x14 for 1.2khz //0x0A for0.6khz
    
    
    //Transmitter registers
    // RegPaLevel
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //irq1: modeready used
    //irq2: fifofull, fifothresh,packetsent used
    
    //rx registers
    writereg(0x18,0x08);       //RegLNA using agc
    writereg(0x19,0x51);       //Regrxbw (data is successfully received  from 5.2 khz onwards for 1200bps)
                               //keep it as 0x51 for 83.3kHz, 0x42 for 62.5kHz, 0x49 for 100 kHz, 0x40 for 250khz, 57 for 1.3khz, 56 for 2.6khz  
                               //46 for 3.9khz//0x57:2.6khz for 1.2khz
    
    writereg(0x29,0x78);       //rssi_thresh = -110 (0x6E)          //0xB4 for -180       //0x96 for -150dBm
                               //0x78 for -120
    
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //set preamble
    writereg(0x2D,0x0A);        //set preamble default(0x0A)
    writereg(0x2E,0x80);        //sync off               ..........................
    writereg(0x2F,0x5E);        //sync word 1               .........................
    writereg(0x37,0x08);// | 0x10);// | 0x40);        //packetconfig1 data whitening(0x40), crc (0x10)               packet issue even if crc fails???..........................
    writereg(0x38,0x00);        //payload length = 0 ... unlimited payload mode
    writereg(0x3C,20);         //fifothresh = 48      because we want it cleared once its 40!!!!
    //Initialization complete
    
    int data[TX_DATA];
    data[0]=0x7E;
    for(int i = 1; i < TX_DATA-1;)
    {//data[i++] = 0xAA;
    data[i++] = B(11111000);
    data[i++] = B(01111100);
    data[i++] = B(00111110);
    data[i++] = B(00011111);
    data[i++] = B(00001111);
    data[i++] = B(10000111);
    data[i++] = B(11000011);
    data[i++] = B(11100001);
    data[i++] = B(11110000);
    }
    
    data[TX_DATA-1]= 0x7E;
    for(int i = 0; i< TX_DATA;i++)
    printf("%X\n",data[i]);
    int x=0;
    
    pc.printf("press t \n");
    while(pc.getc() == 't'){
    //Check for fifoThresh
    //while((readreg(0x28) & 0x20) != 0x20);                         
    //Check for fifoThresh
    //while((readreg(0x28) & 0x20) != 0x00);  
        
    //Highpower settings
    writereg(0x11,0x7F);    //RegPalevel (20db)                //~
    writereg(0x13,0x0F);    //RegOCP
    writereg(0x5A,0x5D);    //RegTestPa1
    writereg(0x5C,0x7C);    //RegTestPa2
        
    //Set to Tx mode
    writereg(0x01,0x0C);
    
    
   while(x!=TX_DATA){
        //Check for fifoThresh
        //Check for fifoThresh
    while((readreg(0x28) & 0x20) != 0x00);
        //writing again
        cs_bar = 0;
        spi.write(0x80);
        int thresh;
        thresh = TX_DATA-x;
        if((TX_DATA-x)>20)   
        for(int i=0; i<20 ;i++,x++)
        spi.write(data[x]);
        else
        for(int i=0; i<thresh ;i++,x++)
        {spi.write(data[x]);
        printf("%d\n",x);
        }
        cs_bar = 1;
    }  
    //wait for packet sent bit to fire
    while((readreg(0x28) & 0x08) != 0x08);
    pc.printf("packet sent!!! \n");    
    
    //Switch back to Standby Mode
    writereg(0x01,0x04);
   
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);
    //t.stop();
    //pc.printf(" time taken to init + transmit = %f \n", t.read()) ;
    }
}