// 6CC000 for 435 MHz
//set all values as FF for checking on spectrum analyzer
#include "beacon.h"
//Serial pc(USBTX, USBRX);           // tx, rx
Serial pc(USBTX, USBRX);
SPI spi(D11, D12, D13);               // mosi, miso, sclk
DigitalOut cs_bar(D10);                 //slave select or chip select
//InterruptIn button(p9);
#define TX_DATA 180      
//Timer t;

//functons
void copy_bit(uint8_t*,uint8_t*,uint8_t*);
uint8_t read_byte(uint8_t*);
void attach_byte(uint8_t* , struct frame*, uint8_t*, uint8_t *);
void attach_frame(struct frame*, struct frame *,uint8_t*,uint8_t*);
void scan_dstuff(uint8_t*,uint8_t* ,uint8_t*,uint8_t*,uint8_t*);
void post_flag(uint8_t* ,uint8_t* ,uint8_t* );
void post_shift_out(uint8_t*,uint8_t*,uint8_t*);
struct frame{
    uint8_t byte[182];
    }p_frame[32],t_frame;
void writereg(uint8_t reg,uint8_t val)
{
    cs_bar = 0;
    spi.write(reg | 0x80);      
    spi.write(val);
    cs_bar = 1;
}
uint8_t readreg(uint8_t reg)
{
    uint8_t val;
    cs_bar = 0;
    spi.write(reg & ~0x80);        
    val = spi.write(0);
    cs_bar = 1;
    return val;
}
        
main() {
    int n = 0;int x = 0;int thresh=0;
    int data[TX_DATA];
    //button.rise(&interrupt_func);         //interrupt enabled ( rising edge of pin 9)
    wait(0.02);                                                           // pl. update this value  or even avoid it!!!                  
    //extract values from short_beacon[]
    
    //pc.baud(115200);
    spi.format(8,0);                    
    spi.frequency(10000000);             //10MHz SCLK frequency(its max for rfm69hcw)
    
    cs_bar = 1;                              // Chip must be deselected
    
    if (readreg(0x15) == 0xB0) pc.printf("spi connection valid\n");
    else {pc.printf("error in spi connection\n"); exit(0); }
    
    //initialization
    //Common configuration registers
    writereg(0x01,0x00);       //sequencer on,standby mode
    writereg(0x02,0x08);// |0x01);       //packet, ook, no dc           //0x00 for fsk   //default = 0x08 for ook
    writereg(0x03,0x68);       //1200bps
    writereg(0x04,0x2B);       //1200bps
    writereg(0x07,0x6C);       
    writereg(0x08,0xC0);    
    writereg(0x09,0x00);       //try 6C C0 00 for 435 MHZ    //try 6C 40 00 for 432.something            //try E4 C0 00 for 915
    
    //FSK settings
    writereg(0x06,0x52);// = (actual Fdev)*0.016384 //0x52 for 5khz //0x14 for 1.2khz //0x0A for0.6khz
    
    
    
    //Transmitter registers
    // RegPaLevel
    
    //IRQ and Pin Mapping Registers
    //no DIO mapped yet
    //irq1: modeready used
    //irq2: fifofull, fifothresh,packetsent used
    
    //rx registers
    writereg(0x18,0x08);       //RegLNA using agc
    writereg(0x19,0x51);       //Regrxbw (data is successfully received  from 5.2 khz onwards for 1200bps)
                               //keep it as 0x51 for 83.3kHz, 0x42 for 62.5kHz, 0x49 for 100 kHz, 0x40 for 250khz, 57 for 1.3khz, 56 for 2.6khz  
                               //46 for 3.9khz//0x57:2.6khz for 1.2khz
    
    writereg(0x29,0x78);       //rssi_thresh = -110 (0x6E)          //0xB4 for -180       //0x96 for -150dBm
                               //0x78 for -120
    
    
    //Packet Engine Registers
    writereg(0x2C,0x00);        //set preamble
    writereg(0x2D,0x0A);        //set preamble default(0x0A)
    writereg(0x2E,0x80);        //sync off               ..........................
    writereg(0x2F,0x5E);        //sync word 1               .........................
    writereg(0x37,0x08);// | 0x10);// | 0x40);        //packetconfig1 data whitening(0x40), crc (0x10)               packet issue even if crc fails???..........................
    writereg(0x38,0x00);        //payload length = 0 ... unlimited payload mode
    writereg(0x3C,30);         //fifothresh = 48      because we want it cleared once its 40!!!!
    //Initialization complete
    pc.printf("press 'r' to start receiver\n");
    while(pc.getc()== 'r'){
    //force rx in WAIT mode
    writereg(0x3D,0x04);//avoid rx deadlocks
    //set to Rx mode
    writereg(0x01,0x10);
    
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);
    pc.printf("receiver is on, ready to accept.....\n");
    
    //wait for rssi to cross rssi_thresh
    while((readreg(0x27)& 0x08) != 0x08)pc.printf("w:rssi\n"); 

    //wait for SyncAddressMatch 
    while((readreg(0x27) & 0x01) != 0x01)pc.printf("w:sync\n");
     
    //pc.printf("receiving.....\n");
    //check for fifo_thresh
    while((readreg(0x28) & 0x20) != 0x20);//pc.printf("w:fifo_thresh\n"); 
    
    
   /*while(x!=TX_DATA)//fifo_thresh
    {                
    thresh = TX_DATA - x;
        //reading
        cs_bar = 0;
        spi.write(0x00);
        if(TX_DATA-x>20)
        for(int i=0; i<20;i++,x++)
        data[x] = spi.write(0);
        else
        for(int i=0; i<thresh;i++,x++)
        data[x] = spi.write(0);
        cs_bar = 1;               
        //check for fifo_thresh
        while((readreg(0x28) & 0x20) != 0x20);
    }*/  
    
        //~~~~ RX BEGIN
   
   
   
uint8_t test_byte=0,flag =0;
uint8_t fifo_byte=0;
uint8_t dstuff_byte=0;
uint8_t byte_no=0;
uint8_t frame_no=0;
uint8_t shift_in=0,shift_out=0;
uint8_t dstuff_count = 0;

    while(frame_no!=1){
    while(flag == 0)
    {
        //while((readreg(0x28) & 0x20) != 0x20);
        //printf("entered\n");
        //fifo_byte = read_byte(&shift_in);
        if(fifo_byte != 0x7E)
        {fifo_byte = read_byte(&shift_in);continue;//cs_bar = 0;
        //spi.write(0x00);
        //printf("\n\n\n\nbbbyyyte = %X\n\n\n\n", spi.write(0));
        //cs_bar = 1;
        }
        else {flag = 2;fifo_byte = read_byte(&shift_in);post_flag(&fifo_byte, &test_byte, &shift_in);}
    }
    if(flag == 2)
        for(;shift_in < 8;)
        {
        if(shift_out == 8)
            {   if(byte_no < 182 )
                attach_byte(&dstuff_byte,&t_frame,&shift_out,&byte_no);
                else
                {attach_frame(&t_frame,&p_frame[frame_no++],&frame_no,&byte_no);flag =0;post_flag(&fifo_byte,&test_byte,&shift_in);dstuff_byte=0;break;}
            }
        if(!(dstuff_count))
        scan_dstuff(&fifo_byte,&test_byte, &flag,&shift_in,&dstuff_count);
        else
        dstuff_count--;
        if(flag == 3)
        break;
        copy_bit(&test_byte,&dstuff_byte,&shift_out);//shift_out
        post_shift_out(&fifo_byte,&test_byte,&shift_in);//updating last bit of test_byte
        }
        //~~
        
        //a check for fifo... 
        //writereg(0x3C,50);
        //while((readreg(0x28) & 0x20) != 0x20)pc.printf("w:fifo_thresh3\n");
        //pc.printf("waiting for 50\n");
        //writereg(0x3C,10);
        
        //~~

    if(flag == 0)
        continue;
    if(shift_in == 8)
        fifo_byte = read_byte(&shift_in);
    if(flag == 3)
        {   if(shift_out%8 != 0){t_frame = (const struct frame){ 0 };shift_out=0;post_flag(&fifo_byte,&test_byte,&shift_in);}//discarding frame not a multiple of 8...make a function later
            else {attach_frame(&t_frame,&p_frame[frame_no++],&frame_no,&byte_no);flag =2;post_flag(&fifo_byte,&test_byte,&shift_in);dstuff_byte=0;}
        }
    }



//RX END
    
    pc.printf("\n\npacket received!!! \n\n");    
    
    wait(1);
    //Switch back to Standby Mode
    writereg(0x01,0x04);
    //wait for modeready
    while((readreg(0x27)&0x80)!=0x80);

    /*pc.printf("Received data:\n");
    for(int i = 0;i< TX_DATA;i++ )
    printf("%X\n",data[i]);*/
    
    
    }  
}
void copy_bit(uint8_t* a_byte,uint8_t* b_byte, uint8_t* count)
        {
        
        if(*a_byte & 0x80)
        {*b_byte <<= 1;
        *b_byte +=1;}
        else *b_byte<<=1;
        *a_byte<<=1;
        (*count)++;
        
        }    
uint8_t read_byte(uint8_t* shift_in)
        {uint8_t byte;
        while((readreg(0x28) & 0x20) != 0x20);//will surely cause problem if not implemented 
        //pc.printf("waiting for fifo full\n");
        cs_bar = 0;
        spi.write(0x00);
        byte = spi.write(0);
        //byte = data[x++];
        cs_bar = 1;
        *shift_in=0;
        //printf("byte read :0x%X \n",byte);
        return byte;}
        
    void attach_byte(uint8_t* a_byte,struct frame* t_frame,uint8_t* count,uint8_t* byte_no)
        {t_frame->byte[(*byte_no)++] = *a_byte;*count=0;}
        
    void attach_frame(struct frame* t_frame, struct frame* p_frame,uint8_t* frame_no,uint8_t* byte_no)
        {*p_frame = *t_frame;
        printf("byte_no = %d  %X \n",*byte_no,p_frame->byte[(*byte_no-1)]);
        //for(int i = 0; i<*byte_no;i++)
        //printf("frame[%d][%d] = %X\n",*frame_no,i,p_frame->byte[i]);
        *byte_no=0;
        *t_frame = (const struct frame){ 0 };}
        
   void scan_dstuff(uint8_t* fifo_byte,uint8_t* test_byte, uint8_t* flag,uint8_t* shift_in,uint8_t* dstuff_count)
        {
            
            if(*test_byte == 0x7E)//scan for flag
            {*flag = 3;
            return;}
            if(((*test_byte) & 0xFC) == 0xF8)//destuff
            {if(*shift_in == 8 ) *fifo_byte=read_byte(shift_in);
            copy_bit(fifo_byte,test_byte,shift_in);                                                                                                                                                                                                                                                                              
            *test_byte = *test_byte | 0xF8;
            *dstuff_count = 4;}
           
            
        }
    void post_flag(uint8_t* a_byte,uint8_t* b_byte,uint8_t *shift_in )
        {
            
            for(int i = 0 ; i < 8 ; i++)
            {if(*shift_in == 8)
            {*a_byte = read_byte(shift_in);}
            copy_bit(a_byte,b_byte,shift_in);
            }
           
        }
   void post_shift_out(uint8_t* fifo_byte,uint8_t* test_byte,uint8_t* shift_in)
        {
            if(*shift_in == 8 ) *fifo_byte=read_byte(shift_in);
            if(*fifo_byte & 0x80)
            *test_byte |= 0x01;
            (*shift_in)++;
            *fifo_byte <<= 1;
        }    
 
 