#ifndef _DSP_H_
#define _DSP_H_

#define HILBERT_TRANSFORM_FIRSTATE_LENGTH 128*2

extern int16_t htstat_buf[HILBERT_TRANSFORM_FIRSTATE_LENGTH];
// capture interval 10ms onto double buffer (5ms each)
// 48kHz x 2ch * 5ms = 240*2
#define CAPTURE_LEN 240*2
extern int16_t cap_buf[2][CAPTURE_LEN];
// 240*2 * 4 = 1920, single buffer
#define FIRSTATE_LENGTH 16*2
extern int16_t fir_state[FIRSTATE_LENGTH];
extern int16_t fir_buf[CAPTURE_LEN];
#define CICBUF_LEN 1920
extern int16_t cic_buf[CICBUF_LEN];
// 1920 * 10 = 19200, double buffer
#define DMA_DATALEN 19200
extern int16_t dma_buf[2][DMA_DATALEN];


typedef struct {
    uint32_t p0;        
    uint32_t s0;
} CICState;

extern CICState cic;

void cic_interpolate_x10(CICState *cic, uint32_t *src, int src_len, uint32_t *dst);


void fir_resample_x4(uint32_t *src_state, uint32_t *dst, int dst_len);

void interpolate_test();

void hilbert_transform(uint32_t *src, uint32_t *dst, int dst_len, int sign);
void hilbert_transform_save_fir_state(uint32_t *src_tail);

void hilbert_transform_test();


typedef struct {
    uint16_t phase;
} FMModState;

extern FMModState fmmod;

//uint32_t cos_sin(int16_t x);

void fmmod_init(FMModState *fmmod);
void frequency_modulation(FMModState *fmmod, uint32_t *src, uint32_t *dst, int dst_len);

void amplitude_modulation(uint32_t *src, uint32_t *dst, int dst_len);


#endif /* _DSP_H_ */
