#ifndef CH_PPM_IN
#define CH_PPM_IN

#include "mbed.h"
#include "definitions.h"

class PpmRegen
{
    public:
        PpmRegen(InterruptIn* interruptPort);
        void getAllChannels(uint16_t all_channels[]);
    private:
        uint16_t channels[CHANNELS+2]; 
        uint16_t last_channels[CHANNELS+2];
        uint16_t corrections[CHANNELS];
        uint8_t current_channel;
        
        void fall(void);
        void channel_correction(void);
        
    
        Timer timer;
        InterruptIn* ppmPin;
        
};

#endif