/* File: HCSR04.h
 * Author: Antonio Buonanno  
 *Board: STM NUCLEO F401RE, 
 *Hardware: Ultrasonic Range HC-SR04,  
 * 
 *This work derived from Arduino library, 
 *
 * Desc: driver for HCSR04 Ultrasonic Range Finder.  The returned range
 *       is in units of meters.
 *  
 *       
 *
*/

/* EXAMPLE
#include "mbed.h"
#include "hcsr04.h"

//D12 TRIGGER D11 ECHO
   HCSR04 sensor(D12, D11); 
int main() {
    while(1) {
        
     long distance = sensor.distance();   
      printf("distanza  %d  \n",distance);
      wait(1.0); // 1 sec  
        
    }
}
*/
#ifndef hcsr04_H
#define hcsr04_H
#include "mbed.h"
#include "rtos.h"


 
class HCSR04 {
  public:
    HCSR04(PinName t1, PinName e1);

    float getDistan1();
    uint16_t getDistan2();
 
    private:
        static void threadWorker1(void const *p);
        static void threadWorker2(void const *p);
    
        DigitalOut trig1;
        DigitalIn echo1;
        
        // sonic thread can't run longer than thread frequency
        uint32_t limit;
        
        Timer timer1;
        Timer timerLimit;
        Timer timer2;
        
        osThreadId id;
        
        RtosTimer *threadUpdateTimer1;
        RtosTimer *threadUpdateTimer2;
        
        float distan1;
        uint32_t distan2;
        bool tooLong;
};
 
#endif