#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "ADS1299.h"
//SPI device(SPI_MOSI, SPI_MISO, SPI_SCK);
SPI device(PC_12, PC_11, PC_10);
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut CS(D10);
DigitalOut ledG(LED1);
DigitalOut ledR(LED3);
InterruptIn DDRY(D15);
DigitalOut reset(D14);
DigitalOut START(D9);

#define buffe 356

const uint32_t lenght_char=(buffe*3)+3;
unsigned char b1[lenght_char],*b2[lenght_char];
uint32_t ciclo,_m;
bool a,bandera;

int leer(void)    //concatena 24 bits
{
    uint32_t rdata;
    rdata  = device.write(0);
    rdata<<=8;
    rdata|=device.write(0);
    rdata<<=8;
    rdata|=device.write(0);
    return rdata;
}

int complement(uint32_t ch)// conversion twos complement
{
    int32_t sch;
    if(ch>0x7FFFFF) {
        ch|=0xFF800000;
        ch--;
        ch=~ch;
        sch = -ch;
    } else if(ch<=0x7FFFFF) {
        sch = ch;
    }
    sch+= 0x7FFFFF; //offset, solo valores positivos
    return sch;
}

int buffy(uint32_t _ch)
{
    //_ch+=0x7FFFFF;
    uint8_t c1,c2,c3;
    c1=_ch>>16;
    b1[ciclo]=c1;
    ciclo++;
    c2=_ch>>8;
    b1[ciclo]=c2;
    ciclo++;
    c3=_ch;
    b1[ciclo]=c3;
    ciclo++;
    return 0;
}

void send_data()
{
    if (bandera == 0) {
        buffy(0xffffff);
        bandera|=1;
    }

    uint32_t statu,ch1,ch2,ch3,ch4,ch5;
    int32_t sch2;
    //  uint8_t c1,c2,c3;
    statu  = leer();
    ch1  = leer();
    ch2  = leer();
    ch3  = leer();
    ch4  = leer();
    ch5  = leer();

    //  sch2=complement(ch2);
     // buffy(sch2);
      //sch2=complement(ch3);
     // buffy(0);
      //sch2=complement(ch4);
      //buffy(0);
      //sch2=complement(ch5);
      //buffy(0);
            
            sch2=complement(ch2);
     buffy(sch2);
    sch2=complement(ch3);
   buffy(sch2);
    sch2=complement(ch4);
     buffy(sch2);
   sch2=complement(ch5);
     buffy(sch2);

    if(ciclo>=lenght_char) {
        bandera&=~bandera;
        memcpy(&b2, &b1, lenght_char);
        ciclo=0;
        a=1;
    }

}

int main()
{

    pc.printf("hi, ");
////////////seteo de ethernet
    EthernetInterface eth;
    eth.connect();
    pc.printf("The Server IP address is '%s'  ", eth.get_ip_address());
    TCPServer srv;
    TCPSocket client_sock;
    SocketAddress client_addr;
    srv.open(&eth);
    srv.bind(eth.get_ip_address(), 8085);
    srv.listen(1);
    ledG = 1;
    srv.accept(&client_sock, &client_addr);
    pc.printf("Accepted %s:%d  ", client_addr.get_ip_address(),
              client_addr.get_port());

    ///////////////////Wake up ADS
    //  pc.printf("ADS1299- Nucleo -F767ZI \n");
    device.format(8,1);
    device.frequency(4000000);
    START=0;
    reset=1;
    wait(0.2);
    reset=0;
    CS=1;
    wait_us(10);
    reset = !reset;
    wait_us(40);
/////////////////////////////////////



/////////////SDATAC para escribir sobre registros
    CS = 0;
    wait_us(1);
    device.write(0x11);
    wait_us(4);//tsccs = 4 Tclk
    CS = 1;
    wait_us(2);//tsch = 2 Tclk
//////////////////////////////////////////////////////////

    ////////////leer ID
    int _id;
    CS = 0;
    wait_us(1);
    device.write(RREG|ID);  //read
    device.write(0x00);
    _id=device.write(0x00);
    wait_us(4);
    CS=1;
    wait_us(2);
////////////////////////
    pc.printf("ID register: %X\n",_id);



////////// SETEAR CONFIGURACION   (todos los registros)
    CS = 0;
    wait_us(5);
    device.write(WREG|CONFIG1);  //write desde config 1
    device.write(0x16);         // escribir sobre 23 registros
    device.write(0x94);        //CONFIG1
    device.write(0xc0);       //CONFIG2     //c0 normal   //d0 Test source
    device.write(0xe0);      //CONFIG3
    device.write(0x00);     //LOFF
    device.write(0x68);          //CH1SET   //ref channel
    device.write(0x60);         //CH2SET     //65 cuadrada  //60 electrodo
    device.write(0x60);        //CH3SET
    device.write(0x60);       //CH4SET
    device.write(0x60);      //CH5SET // si no los uso 81
    device.write(0x81);     //CH6SET
    device.write(0x81);    //CH7SET
    device.write(0x81);   //CH8SET
    device.write(0x00);          //BIAS_SENSP
    device.write(0x00);         //BIAS_SENSN
    device.write(0x00);        //LOFF_SENSP
    device.write(0x00);       //LOFF_SENSN
    device.write(0x00);      //LOFF_FLIP
    device.write(0x00);     //LOFF_STATP
    device.write(0x00);    //LOFF_STATN
    device.write(0x0f);   //GPIO
    device.write(0x20);  //MISC1
    device.write(0x00); //MISC2
    device.write(0x00);//CONFIG4
    wait_us(4);
    CS=1;
    wait_us(2);
///////////////////////////////////////

////////////////INICIO A _RDATAC
    CS = 0;
    wait_us(1);
    device.write(_RDATAC);
    wait_us(4);
    CS=1;
    wait_us(2);
    START=1;
    CS = 0;
    wait_ms(10);//tsettle
//////////////////////////
//    int _by=0;
    // client_sock.recv(reading, 8);
    // client_sock.set_blocking(false);
    // DDRY.mode(PullUp);
//NVIC_SetPriority(TIMER3_IRQn, 200);
    send_data();
    DDRY.fall(&send_data);
    //  DDRY.disable_irq();
  wait_ms(buffe);
    // restart.attach(&send_data, 0.001);
    while(1) {
        while (a==1) {
            client_sock.send(&b2, lenght_char);
            a=0;
        }
        //   fflush();
        __wfi();
    }
    client_sock.close();
}