#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button1(PTD0);
InterruptIn button2(PTD2);
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);

volatile int pressEvent1 = 0 ;
volatile int pressEvent2 = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur
void buttonCallback1()
{
    pressEvent1 = 1 ;
}
void buttonCallback2()
{
    pressEvent2 = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main()
{
    button1.mode(PullUp);             // Ensure button i/p has pull up
    button2.mode(PullUp);             // Ensure button i/p has pull up
    button1.fall(&buttonCallback1) ;   // Attach function to falling edge
    button2.fall(&buttonCallback2) ;   // Attach function to falling edge

    bool change1=true;
    bool change2=true;
    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEvent1) {
            change1=!change1;
            pressEvent1 = 0 ; // Clear the event variable
        }
        if (change1==true) {
            led1 = !led1 ;
        }
        if (pressEvent2) {
            change2=!change2;
            pressEvent2 = 0 ; // Clear the event variable
        }
        if (change2==true) {
            led2 = !led2 ;
        }

        Thread::wait(500) ;
    }
}
