#include "mbed.h"
#include "TSISensor.h"
//#pragma import __use_two_region_memory


// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED1);
DigitalOut greenLED(LED2);
DigitalOut blueLED(LED3);
DigitalOut red2LED(PTD0);   
TSISensor tsi;

Thread thread1;//(osPriorityNormal, 500);
Thread thread2;//(osPriorityNormal, 500);
Thread thread3;//(osPriorityNormal, 500);
Thread thread4;//(osPriorityNormal, 500);
Thread thread5;//(osPriorityNormal, 2000);



void led1()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1);
        redLED = !redLED ; // turn on
        //Thread::signal_wait(0x2);
        //redLED = true ; // turn off
        thread1.signal_clr(0x1);
        //thread1.signal_clr(0x2) ;
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again while LED on
    }
}

void led2()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1);
        greenLED = !greenLED ; // turn on
        //Thread::signal_wait(0x2);
        //greenLED = true ; // turn off
        thread2.signal_clr(0x1) ;
        //thread2.signal_clr(0x2) ;
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again while LED on
    }
}

void led3()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1);
        blueLED = !blueLED ; // turn on
        //Thread::signal_wait(0x2);
        //blueLED = true ; // turn off
        thread3.signal_clr(0x1) ;
        //thread3.signal_clr(0x2) ;
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again while LED on
    }
}

void led4()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1);
        red2LED = !red2LED ; // turn on
        //Thread::signal_wait(0x2);
        //red2LED = true ; // turn off
        thread4.signal_clr(0x1) ;
        //thread4.signal_clr(0x2) ;
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again while LED on
    }
}
/*
void led5()    // method to run in thread
{
    while (true) {
        Thread::signal_wait(0x1);
        greenLED = false ; // turn on
        blueLED = false ; // turn on
        Thread::signal_wait(0x2);
        greenLED = true ; // turn off
        blueLED = true ; // turn off
        thread5.signal_clr(0x1) ;
        thread5.signal_clr(0x2) ;
        // Signal are automatically cleared by wait_signal but
        // the signal might have been set again while LED on
    }
}
*/

int main(void)
{
    redLED = true ; // turn off
    greenLED = true ; // turn off
    blueLED= true;  // turn off
    red2LED=false;
    thread1.start(&led1) ; // start the red thread
    thread2.start(&led2) ; // start the green thread
    thread3.start(&led3) ; // start the green thread
    thread4.start(&led4) ; // start the green thread

    int touchstate=0;
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
        // When no touch --> 0
        // Left --> low value  Right --> high value
        pc.printf("%d\n\r", d) ;
        pc.putc(' ') ;


        switch (touchstate) {
            case 0://none state
                if (d>3 && d<9) {
                    touchstate=1;
                    thread1.signal_set(0x1);
                } else if (d>13 && d<19) {
                    touchstate=2;
                    thread2.signal_set(0x1);
                } else if (d>23 && d<29) {
                    touchstate=3;
                    thread3.signal_set(0x1);
                } else if (d>33) {
                    touchstate=4;
                    thread4.signal_set(0x1);
                }
                break;
            case 1://leftOut state
                if (d<3 || d>9 && touchstate==1) {
                    touchstate=0;
                    //thread1.signal_set(0x2);
                }
                break;
            case 2://leftIn
                if (d<13 || d>19 && touchstate==2 ) {
                    touchstate=0;
                    //thread2.signal_set(0x2);
                }
                break;
            case 3://rightIn
                if (d<23 || d>29 && touchstate==3) {
                    touchstate=0;
                    //thread3.signal_set(0x2);
                }
                break;
            case 4://rightOut
                if (d<33 && touchstate==4 ) {
                    touchstate=0;
                    //thread4.signal_set(0x2);
                }
                break;
        }

        Thread::wait(50);  // 
    }
}