// Lab 3 Example Program 2
// -----------------------
// Periodically write to the AnalogOut to create a sine wave
// Alternate between two fixed frequencies every 5 sec
//
// Updated for mbed 5

// THIS VERSION HAS NO DEBUGGING CODE

#include "mbed.h"
#include "sineTable.h"

Ticker tick ;          // Creates periodic interrupt
AnalogOut ao(PTE30) ;  // Analog output
Ticker tick2;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalIn b1(PTC9, PullUp);
DigitalOut led1(PTA13);  // Red LED
DigitalOut led2(PTD5);   // Yellow LED
DigitalOut led3(PTD0);   // Green LED
DigitalOut led4(PTD2);   // Green LED
DigitalOut led5(PTD3);   // Green LED


Serial pc(USBTX, USBRX); // tx, rx, for debugging

// Message type
typedef struct {
    uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;


// Function called every 10ms to read ADC
// Low pass filter
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ;
void readA0()
{
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s)
{
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}
Thread pollV;            // thread to set new max voltage
volatile int pressEvent = 0 ;  // Variabe set by the polling thread
enum buttonPos { up, down, bounce }; // Button positions

void switchPoll(){
        buttonPos pos = up ;
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down
                    pressEvent = 1 ;  // transition occurred
                    pos = down ;
                }
                break ;
            case down :
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }        
    }
// Function called periodically
// Write new value to AnalogOut 
volatile int index = 0 ; // index into array of sin values
void writeAout() {
    ao.write_u16(sine[index]) ;
    index = (index + 1) % 64 ;   
}

int main()
{
    pollV.start(callback(switchPoll));
    //led1 = 1 ; // turn off
    int volts = 0 ;
    int maxVolts=330;
    int update_us=(1/(64*(1+((49*volts)/maxVolts))));
    const int threshold = 100 ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;

    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            if (pressEvent) {
                pressEvent = 0 ; // clear the event variable
                maxVolts=volts;
            }
        update_us=(1/(64*(1+((49*volts)/maxVolts))));
        tick2.attach_us(callback(&writeAout), update_us); 
            
            mailbox.free(mess) ;  // free the message space
            if (volts >= ((maxVolts/6)*1) && volts < ((maxVolts/6)*2)) {
                led1 = 1 ;
                led2 = 0 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts >= ((maxVolts/6)*2) && volts < ((maxVolts/6)*3)) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts >= ((maxVolts/6)*3) && volts < ((maxVolts/6)*4)) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts >= ((maxVolts/6)*4) && volts < ((maxVolts/6)*5)) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 1 ;
                led5 = 0 ;
            } else if (volts >= ((maxVolts/6)*5)) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 1 ;
                led5 = 1 ;
            } else {
                led1 = 0 ;
                led2 = 0 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            }
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }

    }
}