#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    accState2=0;

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        int accState;
        float accmin=0.95;
        float accmax=1.05;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        //rled = 1.0f - abs(x);
        //gled = 1.0f - abs(y);
        //bled = 1.0f - abs(z);
        Thread::wait(300);


        if(z>=accmin && z<=accmax) {
            accState=1;
        } else if(y<=-(accmin) && y>=-(accmax)) {
            accState=2;
        } else if(y>=accmin && y<=accmax) {
            accState=3;
        } else if(x<=-(accmin) && x>=-(accmax)) {
            accState=4;
        } else if(x>=accmin && x<=accmax) {
            accState=5;
        } else if(z<=-(accmin) && z>=-(accmax)) {
            accState=6;
        } else {
            accState=0;
        }
        if accState2==accState
        switch (accState) {
            case 0: //Intermidiate
                //
                rled=1;
                gled=1;
                bled=1;
                break;
            case 1: //Flat
                pc.printf("flat\n\r");
                rled=0;
                gled=1;
                bled=1;
                break;
            case 2: //right
                pc.printf("right\n\r");
                rled=1;
                gled=0;
                bled=1;
                break;
            case 3: //left
                pc.printf("left\n\r");
                rled=1;
                gled=1;
                bled=0;
                break;
            case 4: //up
                pc.printf("up\n\r");
                rled=0;
                gled=0;
                bled=1;
                break;
            case 5: //down
                pc.printf("down\n\r");
                rled=0;
                gled=1;
                bled=0;
                break;
            case 6: //over
                pc.printf("over\n\r");
                rled=1;
                gled=0;
                bled=0;
                break;
        }
    }
}
