
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"


Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(PTA13);   // Red LED
DigitalOut led2(PTD3);   // Red LED
DigitalOut led3(PTD2);   // Red LED
DigitalOut led4(PTD0);   // Red LED
DigitalOut led5(PTD5);   // Red LED


Serial pc(USBTX, USBRX); // tx, rx, for debugging

// Message type
typedef struct {
    uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ;
void readA0()
{
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s)
{
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox
int main()
{
    led1 = 1 ; // turn off
    int volts = 0 ;
    const int threshold = 100 ;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;

    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            if (volts > 55 && volts < 109) {
                led1 = 1 ;
                led2 = 0 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts > 110 && volts < 164) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts > 165 && volts < 219) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 0 ;
                led5 = 0 ;
            } else if (volts > 220 && volts < 274) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 1 ;
                led5 = 0 ;
            } else if (volts > 275) {
                led1 = 1 ;
                led2 = 1 ;
                led3 = 1 ;
                led4 = 1 ;
                led5 = 1 ;
            } else {
                led1 = 0 ;
                led2 = 0 ;
                led3 = 0 ;
                led4 = 0 ;
                led5 = 0 ;
            }
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }

    }
}
