#ifndef MBED_PS2ASCII_H
#define MBED_PS2ASCII_H

#include "PS2Kbd.h"
#include "mbed.h"

class PS2ASCII {

public:

    PS2ASCII(PinName data, PinName clk);
    unsigned char getChar();
    bool caps();
    bool shift();
    bool E0flag();
    bool numlock();
        
private:

    PS2Kbd kbd;
    bool _caps;                        
    bool _shift; 
    bool _E0flag; 
    bool _numlock;
};

    static const unsigned char shift_on[] = {
//   0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  '`',  ' ', // 00-0F
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // 10-1F
    ' ', 0x21, 0x22,  '~', 0x24, 0x25, 0x26,  '@', 0x28, 0x29, 0x30, 0x31,  '<',  '_',  '>',  '?', // 20-2F
    ')',  '!', '\"', 0x9C,  '$',  '%',  '^',  '&',  '*',  '(',  ' ',  ':',  ' ',  '+',  ' ',  ' ', // 30-3F
    0xAA, 'a',  'b',  'c',  'd',  'e',  'f',  'g',  'h',  'i',  'j',  'k',  'l',  'm',  'n',  'o', // 40-6F
    'p',  'q',  'r',  's',  't',  'u',  'v',  'w',  'x',  'y',  'z',  '{',  '|',  '}',  ' ',  ' ', // 50-7F
    ' ',  'A',  'B',  'C',  'D',  'E',  'F',  'G',  'H',  'I',  'J',  'K',  'L',  'M',  'N',  'O', // 60-4F
    'P',  'Q',  'R',  'S',  'T',  'U',  'V',  'W',  'X',  'Y',  'Z', 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, // 70-5F
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // 80-8F
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // 90-9F
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // A0-AF
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // B0-BF
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // C0-CF
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // D0-DF
    ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // E0-EF
    NULL, ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ',  ' ', // F0-FF
};

#endif
