#include "PS2ASCII.h"

//===================================
//*Constructor*
//===================================

PS2ASCII::PS2ASCII(PinName data, PinName clk) : kbd(data,clk) ,_caps(false), _shift(false),  _E0flag(false) ,_numlock(false)
{
    
}

//===================================
//Functions
//===================================

unsigned char PS2ASCII::getChar()
{
     while(1)
     {
         _E0flag = false;
         unsigned char keypress = kbd.rd();                //code in
        
        if(keypress == 0xE0)                            //is it a special E0 key?
        {
            keypress = kbd.rd();                        //next byte in
            if(keypress == NULL)                        //is it a break code?
            {
                keypress = kbd.rd();                    //if so chew it up and back to start
                
                continue;
            }
            
            _E0flag = true;                                //tell us that it is an E0 function
            return keypress;
        }
        
        if((keypress == 0x12) || (keypress == 0x59))    //SHIFT pressed?
        {
            _shift = true;
            continue;
        }
        
        if(keypress == NULL)                            //gets rid of byte 1 of break code
        {
            keypress = kbd.rd();                        //byte 2 of break code in
                
            if((keypress == 0x12) || (keypress == 0x59))
            {
                _shift = false;
            }
            continue;
        }
        
        switch (keypress) {
            case 0x58:
                _caps = !_caps;                            //CAPS LOCK key
                continue;
            case 0x80:
                _numlock = !_numlock;
                continue;
            default:
                break;
        }
        
        unsigned char initial_keypress = keypress;
        
        if(_shift == true)                                //if SHIFT is pressed take shifted character
        {
            keypress = shift_on[keypress];
        }
            
        if((_caps == true)&&(initial_keypress >= 97)&&(initial_keypress <= 127))
        {
            keypress = shift_on[keypress];                //if caps is on shift the letter up
        }
            
        return(keypress);
        
    }
}
    
bool PS2ASCII::E0flag()
{
    return _E0flag;
}

bool PS2ASCII::numlock()
{
    return _numlock;
}
     
     
