#include "PS2Kbd.h"
#include "mbed.h"


/* ==================================================================
 * Constructor
 ================================================================= */

PS2Kbd::PS2Kbd(PinName clk, PinName din) 
    : _ps2clk(clk), _ps2din(din) {
   
}    

// =============================
// 
// =============================
unsigned char PS2Kbd::rd(void)
{
    unsigned int buf = 0x00;
    int i;
    
    _ps2clk = 0;

    // both input
    _ps2din.input();
    _ps2clk.input();

    for(i=0;i<11;i++) {
        while(_ps2clk);
        while(!_ps2clk);
        buf = buf >> 1;
        buf |= _ps2din ? 512 : 0;
    }

    // output
    _ps2clk.output();

    buf &= 0xFF;

    return(ps2KeyMap[(unsigned char)buf]);
    //return (unsigned char)buf;
}


// =============================
// 
// =============================
void PS2Kbd::wr(unsigned char)
{
    unsigned int buf = 0x00;
    int i;
    
    _ps2clk = 0;

    // both input
    _ps2din.input();
    _ps2clk.input();

    for(i=0;i<11;i++) {
        while(_ps2clk);
        while(!_ps2clk);
        buf = buf >> 1;
        buf |= _ps2din ? 512 : 0;
    }

    // output
    _ps2clk.output();

    buf &= 0xFF;

}


