/**
 *     @file        main.c
 *     @author      Edward Wilson (edwilson1989@gmail.com)
 *     @date        Nov 3, 2010
 *     @brief       BrainFuck Interpretter
 */

/**
* Place a file called in.txt on the mbed and reset the device. The system will execute the BF code, delete the file and replace it with
* a file called out.txt which is the output from the script.
* Here is one to try:
* ++++++++++[>+++++++>++++++++++>+++>+<<<<-]>++.>+.+++++++..+++.>++.<<+++++++++++++++.>.+++.------.--------.>+.>S
*/
#include "mbed.h"
#include <stdlib.h>

#define PROG_ALLOC 3000
#define MEM_ALLOC 1000

LocalFileSystem local("local");

FILE *input, *output;

DigitalOut led1(LED1);
char program[PROG_ALLOC];
int memory[MEM_ALLOC];
int memPointer = 0;
int progPointer = 0;
int progSize = 0;

void execute(char instruction) {
    switch (instruction) {
        case '>':
            memPointer++;
            break;
        case '<':
            memPointer--;
            break;
        case '.':
            output = fopen("/local/output.txt","a");
            if (output != NULL) {
                if (memory[memPointer] > 31) {
                    fprintf(output,"%c", (char) (memory[memPointer]));
                } else {
                    fprintf(output,"%d", memory[memPointer]);
                }
                fclose(output);
            }
            break;
        case ',':
            fscanf(input,"%c", &memory[memPointer]);
            break;
        case '[':
            if (memory[memPointer] == 0) {
                int bracketCount = 0;
                while (bracketCount > 0 || program[progPointer] != ']') {
                    if (program[progPointer] == '[') {
                        bracketCount++;
                    } else if (program[progPointer] == ']') {
                        bracketCount--;
                    }
                    progPointer++;
                }
            }
            break;
        case ']':
            if (memory[memPointer] != 0) {
                int bracketCount = -1;
                while (bracketCount > 0 || program[progPointer] != '[') {
                    if (program[progPointer] == '[') {
                        bracketCount--;
                    } else if (program[progPointer] == ']') {
                        bracketCount++;
                    }
                    progPointer--;
                }
            }
            break;
        case '+':
            memory[memPointer]++;
            break;
        case '-':
            memory[memPointer]--;
            break;
    }
}

void run() {
    while (progPointer < progSize) {
        execute(program[progPointer]);
        progPointer++;
    }
    led1 = !led1;
}

void reset() {
    progSize = 0;
    progPointer = 0;
}

void loop() {
    reset();
    input = fopen("/local/in.txt","r");
    if (input == NULL) {
        led1 = 1;
        while(1);
    }

    do {
        fscanf(input, "%c", &program[progSize]);
        progSize++;
    } while (program[progSize-1] != 'S');
    run();
    remove("/local/in.txt");
}

int main() {
    while (1) {
        loop();
    }
    return 0;
}
