/* 
 * This program toggles the green and red LEDs of the FRDM K22F Board 
 * at the register level. Refer to the MK22FN512VLH12 datasheet
 * to understand the registers.
 * 
 * At the general level:
 * Sets PTA1 and PTA2 which LEDs are connected to GPIO mode.
 * Sets both pins to be digital output.
 * Turns red LED off by writing a 1 and leaves green on.
 * Enters a loop which uses the Toggle Output Register to turn 
 * LEDs on and off.  
*/
#include "mbed.h"
Serial pc(USBTX, USBRX);
void pr(volatile uint32_t *reg);

int main(){

    PORTA_PCR1 = 0x143; //Sets pin to GPIO mode
    PORTA_PCR2 = 0x143; //Sets pin to GPIO mode
    GPIOA_PDDR = 0x6; //Sets pin to output
    GPIOA_PSOR = 0x2; //Turns RED off, Leaves GREEN on
    
    while (1){
        int volatile counter = 0;
        while(counter < 10000000){
            counter++;
        }
        GPIOA_PTOR = 0x6; //Toggles RED and GREEN LEDs 
    }
}
//Debuggin tool, it prints register [address]--> [contents]
//Pass the "address of" a register, i.e: pr(&PORTA_PCR1)
void pr(volatile uint32_t *reg){
    pc.printf("%x --> %x \n", reg, *reg);
}
