#include "mbed.h"
#include "string.h"
#include "time.h"

#define numsamples 1

int touchsense1(void);
int touchsense2(void);
DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);
AnalogIn input1(p20);
DigitalIn charger1(p19);
DigitalOut ground1(p18);
AnalogIn input2(p17);
DigitalIn charger2(p16);
DigitalOut ground2(p15);
Serial pc(USBTX,USBRX);



//This  is called when the T0 capacitor is touched.
int touchsense1(void) {
    float sample;
    ground1 = 0;
    charger1.mode(PullUp); //p19 used for charging the capacitor.
    charger1.mode(PullNone);
    sample = input1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

//This function is called when the T1 capacitor is touched.

int touchsense2(void) {
    float sample;
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample = input2.read();
    if (sample < 0.4) {
        return 1;
    } else {
        return 0;
    }
}




int main() {
    //Getting the trigger string from the user
    /* Module-1 */
    char triggerString1[1];
    char triggerString2[1];
    int index1=0,index2 = 0;
    char realTriggerString[20];
    //char finalTriggerString[20];
    int count=0,i = 0;
    bool isSensor1Pressed = false;
    bool isSensor2Pressed = false;
    char inputChar;
   
    int triggerStringlength;
    bool isStartEncountered = false;
    bool bitsEncountered = false;
    
    int countBits = 0;
    int k = 0;
    //The user is allowed to enter the trigger string.
    a:
    char triggerString[30];char triggerStringBits[20]; count = 0;
    pc.printf("Enter the Trigger String: "); 
    
    while (1) {
        pc.putc(inputChar = pc.getc());
        if (inputChar == 'e' || inputChar == 'E') {
            triggerString[k] = inputChar;
            k++;
            break;
        } else {
            triggerString[k] = inputChar;
            k++;
        }
    }
    //All the entered characters from the user are strored in the array.
    triggerString[k] = '\0';
    //Getting the total length of the trigger string.
    while (triggerString[count] != '\0') {
        count++;
    }
    triggerStringlength = count;
    //Checking for the validity of the input validation string.
    for (int i = 0 ;i<triggerStringlength; i++) 
    {
        if(triggerString[0] != 's' && triggerString[0] != 'S')
        {
            pc.printf("\n\nInvalid Trigger String 1\n");
            for(i=0;i<triggerStringlength;i++)
            {
                triggerString[i]='\0';
            }
            k=0;
            goto a;            
        }   
        
         for(int j=1;j<triggerStringlength-2;j++)
        {
            if(triggerString[j] == '0' || triggerString[j] == '1' || triggerString[j] == ' ')
            {
                continue;
            }
            else
            {
                pc.printf("\n\nInvalid Trigger String2\n");
                for(i=0;i<triggerStringlength;i++)
                {
                    triggerString[i]='\0';                              
                }
                 k=0;
                 goto a; 
            }
        }
               
         
        
            //If the input string contains spaces, simply continue.
            if (triggerString[i] == ' ') {
                continue;
            }

            if (triggerString[i] == 'S' || triggerString[i] == 's') {
                isStartEncountered = true;
                continue;
            }
       
        if (isStartEncountered && (triggerString[i]!= 'E' || triggerString[i] != 'e')) {
            if (triggerString[i] == ' ') {
                continue;
            } else {
                if (triggerString[i] == '0' || triggerString[i] == '1') {
                    triggerStringBits[countBits] = triggerString[i];
                    bitsEncountered = true;
                    countBits++;
                }
            }
        } else {
            //If the user enters E character first without enterting the S character then the user has entered and invalid trigger string.
            if (isStartEncountered && !bitsEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) {
                pc.printf("Please enter a valid Trigger String");
            } else {
                if (isStartEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) {
                    break;
                }
            }
        }
    }
    //Ending the triggerString Bit array.
    triggerStringBits[countBits] = '\0';
    pc.printf("\n\nPlease input on sensor:");
    /* Module -2 Verifying the trigger string with the input from the user */
    //Getting the touch sensor inputs from the user and verifying it with the host string.
    count =0;
    int bufferSeconds = 10;
    clock_t endwait;
    clock_t storeendwait;
    endwait = clock() + bufferSeconds * CLOCKS_PER_SEC ;
    storeendwait = endwait;
    
    while (1) {
        if (touchsense2()) {
            triggerString2[index2] = '1';
            myLed2 = 1;
            wait(0.01);
            isSensor2Pressed = true;
            bufferSeconds = 3;
            //Increasing the endwait time with every touch.
            endwait = storeendwait + bufferSeconds * CLOCKS_PER_SEC;
        } else {
            if (isSensor2Pressed) {
                realTriggerString[count] = triggerString2[0];
                count++;
            }
            myLed2 = 0;
            for (i=0;i<strlen(triggerString2);i++) {
                triggerString2[i] = '\0';
            }
            isSensor2Pressed = false;
        }

        if (touchsense1()) {
            triggerString1[index1] = '0';
            myLed1 = 1;
            wait(0.05);
            isSensor1Pressed = true;
            bufferSeconds = 3 ;
            endwait = storeendwait + bufferSeconds * CLOCKS_PER_SEC;
        } else {
            if (isSensor1Pressed) {
                realTriggerString[count] = triggerString1[0];
                count++;
            }
            myLed1 = 0;
            for (i=0;i<strlen(triggerString1);i++) {
                triggerString1[i] = '\0';
            }
            isSensor1Pressed = false;
        }
        if (clock() > endwait) {           
            break;
        }
    }
    //Marking the end of the trigger string captured through the sensors from the users. This value needs to be matched to the trigger string entered from the user through pc.
    realTriggerString[count] = '\0';
    int matchCount = 0;
    //Only if the trigger string length equals the length of the string entered by the user, then only the validation for each character should take place.
    if (strlen(realTriggerString) == strlen(triggerStringBits)) {
        for (i=0;i<strlen(realTriggerString);i++) {
            if (realTriggerString[i] == triggerStringBits[i]) {
                matchCount++;
            }
            //if (realTriggerString[i]== '0' || realTriggerString[i] == '1')
            //  pc.printf("%c",realTriggerString[i]);
        }
        if (matchCount == strlen(realTriggerString)) {
            pc.printf("HOST MATCH\n");
        }
    } else {
        pc.printf("HOST ERROR or TOUCH ERROR\n");
    }
}

