#include "mbed.h"
#include "pt.h"
#include "time.h"

DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);
AnalogIn input1(p20);
DigitalIn charger1(p19);
DigitalOut ground1(p18);
AnalogIn input2(p17);
DigitalIn charger2(p16);
DigitalOut ground2(p15);
Serial pc(USBTX,USBRX);

//Global variables for the touchsense1 and touchsense2 functions that are running in the foreground process.
bool isSensor1Pressed = false;
bool isSensor2Pressed = false;
int count = 0;
char triggerString1[1];
char triggerString2[1];
char realTriggerString[20];
char inputChar; char triggerString[20]; int k=0;

//Global variable to get the total no of bits in the trigger string.
int countBits = 0;
char triggerStringBits[20];

int globalTouchSenseCount=0;
//Static variables used to transfer the control from one thread to the other.
static int protoThread0 = 0;
static int protoThread1 = 0;
static int protoThread2 = 0;

//This thread is useful to monitor the Serial port and get the input from the user.
static int Monitor_Serial_Port_Thread(struct pt *pt)
{    
    int counter=0,triggerStringlength;
    bool isStartEncountered = false; bool bitsEncountered = false;
    PT_BEGIN(pt);
    pc.printf("Enter the Trigger String: ");
    while(1)
    {
        pc.putc(inputChar = pc.getc());
        if (inputChar == 'e' || inputChar == 'E') 
        {
            triggerString[k] = inputChar;
            k++; 
            break;                   
        } 
        else 
        {
            triggerString[k] = inputChar;
            k++;
        }
    }
    
    //All the entered characters from the user are strored in the array.
    triggerString[k] = '\0';
    //Getting the total length of the trigger string.
    while (triggerString[counter] != '\0') 
    {
        counter++;
    }
    triggerStringlength = counter;
    //Checking for the validity of the input validation string.
    for (int i = 0 ;i<triggerStringlength; i++) 
    {
        //If the input string does not start with required characters, then we continue.
        if (triggerString[i] != 'S' && triggerString[i] != 's' && triggerString[i] != '0' && triggerString[i] != '1' && triggerString[i] != 'E' && triggerString[i] != 'e' && triggerString[i] != ' ') 
        {           
            pc.printf("Invalid Trigger String");
            PT_RESTART(pt);
        } else
        {
            //If the input string contains spaces, simply continue.
            if (triggerString[i] == ' ') 
            {
                continue;
            }

            if (triggerString[i] == 'S' || triggerString[i] == 's') 
            {
                isStartEncountered = true;
                continue;
            }
        }
        if (isStartEncountered && (triggerString[i]!= 'E' || triggerString[i] != 'e')) 
        {
            if (triggerString[i] == ' ') 
            {
                continue;
            } 
            else 
            {
                if (triggerString[i] == '0' || triggerString[i] == '1') 
                {
                    triggerStringBits[countBits] = triggerString[i];
                    bitsEncountered = true;
                    countBits++;
                }
            }
        } 
        else 
        {
            //If the user enters E character first without enterting the S character then the user has entered and invalid trigger string.
            if (isStartEncountered && !bitsEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) 
            {
                pc.printf("Please enter a valid Trigger String");
                //Restart the protothread if the string entered is not a valied trigger string.
                PT_RESTART(pt);
            } 
            else 
            {
                if (isStartEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) 
                {
                    break;
                }
            }
        }
    }
    //Ending the triggerString Bit array.
    triggerStringBits[countBits] = '\0';
    //This variable is used to start the other sensor threads.
    protoThread0 = 1;
    PT_END(pt);
}
//This thread is used to monitor the To capacitor sensor.
static int Touchsense1_Thread(struct pt *pt)
{
    PT_BEGIN(pt);  
    PT_WAIT_UNTIL(pt, protoThread0 == 1); 
    float sample;    
    ground1 = 0;
    charger1.mode(PullUp); //p19 used for charging the capacitor.
    charger1.mode(PullNone);
    sample = input1.read();
    if (sample < 0.3) 
    {        
        triggerString1[0] = '0';
        myLed1 = 1;
        wait(0.005);
        isSensor1Pressed = true; 
    } 
    else 
    {    
        if (isSensor1Pressed) 
        {
             realTriggerString[count] = triggerString1[0];          
             count++;
             if(count < strlen(triggerStringBits))
             {
                protoThread1 = 0;
             }
             else
             {
                protoThread1 = 1;
             }
        }
        myLed1 = 0;
        for (int i=0;i<strlen(triggerString1);i++) 
        {
            triggerString1[i] = '\0';
        }
        isSensor1Pressed = false; 
    }   
    PT_END(pt);
}


//This thread is used to monitor the touch sensor T1.

static int Touchsense2_Thread(struct pt *pt)
{
    PT_BEGIN(pt);
    PT_WAIT_UNTIL(pt, protoThread0 == 1);
    float sample;   
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample = input2.read();   
    if (sample < 0.3) 
    {        
        triggerString2[0] = '1';
        myLed2 = 1;
        wait(0.005);
        isSensor2Pressed = true;       
    } 
    else 
    {
        if (isSensor2Pressed) 
        {
             realTriggerString[count] = triggerString2[0];
             count++;
             if(count < strlen(triggerStringBits))
             {
                protoThread2 = 0;
             }
             else
             {
                protoThread2 = 1;
             }            
        }
        myLed2 = 0;
        for (int i=0;i<strlen(triggerString2);i++) 
        {
           triggerString2[i] = '\0';
        }
        isSensor2Pressed = false;
    }
    PT_END(pt);
}

static int Check_Trigger_String_Thread(struct pt *pt)
{
    PT_BEGIN(pt);
    pc.printf("Value of proto thread: %d",protoThread1);
    PT_WAIT_UNTIL(pt, (protoThread1 == 1 || protoThread2 == 1));
    //Marking the end of the trigger string captured through the sensors from the users. This value needs to be matched to the trigger string entered from the user through pc.
    realTriggerString[count] = '\0';
    pc.printf("\n\nReal Trigger String Len: %d",strlen(realTriggerString));  
    pc.printf("\n\nTrigger String Bits: %d",strlen(triggerStringBits));
    int matchCount = 0;
    //Only if the trigger string length equals the length of the string entered by the user, then only the validation for each character should take place.
    if (strlen(realTriggerString) == strlen(triggerStringBits)) {
        for (int i=0;i<strlen(realTriggerString);i++) {
            if (realTriggerString[i] == triggerStringBits[i]) {
                matchCount++;
            }
            //if (realTriggerString[i]== '0' || realTriggerString[i] == '1')
            //  pc.printf("%c",realTriggerString[i]);
        }
        if (matchCount == strlen(realTriggerString)) {
            pc.printf("HOST MATCH\n");
            protoThread0 = 0;
            protoThread1 = 0;
            protoThread2 = 0;
        }
    } 
    else 
    {
        pc.printf("HOST ERROR or TOUCH ERROR\n"); 
        protoThread0 = 0;
        protoThread1 = 0;
        protoThread2 = 0;       
    }   
    PT_END(pt);
}


//Protothreads state variables.
struct pt pt0, pt1, pt2,pt3;

int main() 
{
    //Initializing the threads.
    PT_INIT(&pt0);
    PT_INIT(&pt1);
    PT_INIT(&pt2);     
    PT_INIT(&pt3);
    
    //Thread to monitor the serial input.
    Monitor_Serial_Port_Thread(&pt0);
    
    //Only after the trigger string is got from the user, the touch sensors need to be enabled.    
    pc.printf("\n\nPlease input on sensor:");
    while(1)
    {  
        Touchsense1_Thread(&pt1);
        Touchsense2_Thread(&pt2);        
         //Check if the Input from the sensors matches the trigger string.
        Check_Trigger_String_Thread(&pt3);
    }       
}
